/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.helpers;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.renderer.GLAllocation;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.proxy.ClientProxy;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;

public class SoundDeviceThread
extends Thread {
    private static final int ALC_CONNECTED = 787;
    private IntBuffer connectionBuffer = GLAllocation.func_74527_f((int)1);

    public SoundDeviceThread() {
        this.setName("Default Sound Device Checker");
        this.setDaemon(true);
    }

    private String getDefault() {
        return ALC10.alcGetString(null, (int)4100);
    }

    private boolean isDisconnected(ALCdevice device) {
        if (!ALC10.alcIsExtensionPresent((ALCdevice)device, (String)"ALC_EXT_disconnect")) {
            return false;
        }
        ALC10.alcGetInteger((ALCdevice)device, (int)787, (IntBuffer)this.connectionBuffer);
        return this.connectionBuffer.get(0) == 0;
    }

    @Override
    public void run() {
        try {
            String previousDefault = null;
            SoundManager manager = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (String[])new String[]{"sndManager", "field_147694_f"});
            while (!Thread.interrupted()) {
                boolean managerLoaded = (Boolean)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)manager, (String[])new String[]{"loaded", "field_148617_f"});
                if (managerLoaded && !ClientProxy.soundSystemReloadLock) {
                    if (previousDefault == null) {
                        previousDefault = this.getDefault();
                        continue;
                    }
                    ALCdevice device = AL.getDevice();
                    if (device != null && !device.isValid() || this.isDisconnected(device) || !previousDefault.equals(this.getDefault())) {
                        ArchaicLogger.LOGGER.info("Sound device is not valid anymore, reloading sound system");
                        previousDefault = this.getDefault();
                        ClientProxy.soundSystemReloadLock = true;
                        Minecraft.func_71410_x().func_152344_a(() -> ((SoundManager)manager).func_148596_a());
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable e) {
            ArchaicLogger.LOGGER.error("An exception occured while checking sound device status", e);
        }
    }
}

