/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.lighting.world.lighting;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.lighting.api.IChunkLighting;
import org.embeddedt.archaicfix.lighting.api.IChunkLightingData;
import org.embeddedt.archaicfix.lighting.api.ILightingEngine;
import org.embeddedt.archaicfix.lighting.api.ILightingEngineProvider;
import org.embeddedt.archaicfix.lighting.world.lighting.AxisDirection;
import org.embeddedt.archaicfix.lighting.world.lighting.BlockPos;
import org.embeddedt.archaicfix.lighting.world.lighting.LightingEngineHelpers;

public class LightingHooks {
    private static final EnumSkyBlock[] ENUM_SKY_BLOCK_VALUES = EnumSkyBlock.values();
    private static final AxisDirection[] ENUM_AXIS_DIRECTION_VALUES = AxisDirection.values();
    public static final EnumFacing[] HORIZONTAL_FACINGS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};
    private static final int FLAG_COUNT = 32;
    public static final String neighborLightChecksKey = "NeighborLightChecks";

    public static void relightSkylightColumn(World world, Chunk chunk, int x, int z, int height1, int height2) {
        int yMin = Math.min(height1, height2);
        int yMax = Math.max(height1, height2) - 1;
        ExtendedBlockStorage[] sections = chunk.func_76587_i();
        int xBase = (chunk.field_76635_g << 4) + x;
        int zBase = (chunk.field_76647_h << 4) + z;
        LightingHooks.scheduleRelightChecksForColumn(world, EnumSkyBlock.Sky, xBase, zBase, yMin, yMax);
        if (sections[yMin >> 4] == null && yMin > 0) {
            world.func_147463_c(EnumSkyBlock.Sky, xBase, yMin - 1, zBase);
        }
        short emptySections = 0;
        for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
            if (sections[sec] != null) continue;
            emptySections = (short)(emptySections | 1 << sec);
        }
        if (emptySections != 0) {
            for (EnumFacing dir : HORIZONTAL_FACINGS) {
                int zOffset;
                boolean neighborColumnExists;
                int xOffset = dir.func_82601_c();
                boolean bl = neighborColumnExists = ((x + xOffset | z + (zOffset = dir.func_82599_e())) & 0x10) == 0 || LightingEngineHelpers.getLoadedChunk(world.func_72863_F(), chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset) != null;
                if (neighborColumnExists) {
                    for (int sec = yMax >> 4; sec >= yMin >> 4; --sec) {
                        if ((emptySections & 1 << sec) == 0) continue;
                        LightingHooks.scheduleRelightChecksForColumn(world, EnumSkyBlock.Sky, xBase + xOffset, zBase + zOffset, sec << 4, (sec << 4) + 15);
                    }
                    continue;
                }
                LightingHooks.flagChunkBoundaryForUpdate(chunk, emptySections, EnumSkyBlock.Sky, dir, LightingHooks.getAxisDirection(dir, x, z), EnumBoundaryFacing.OUT);
            }
        }
    }

    public static void scheduleRelightChecksForArea(World world, EnumSkyBlock lightType, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LightingHooks.scheduleRelightChecksForColumn(world, lightType, x, z, yMin, yMax);
            }
        }
    }

    private static void scheduleRelightChecksForColumn(World world, EnumSkyBlock lightType, int x, int z, int yMin, int yMax) {
        for (int y = yMin; y <= yMax; ++y) {
            world.func_147463_c(lightType, x, y, z);
        }
    }

    public static void flagSecBoundaryForUpdate(Chunk chunk, BlockPos pos, EnumSkyBlock lightType, EnumFacing dir, EnumBoundaryFacing boundaryFacing) {
        LightingHooks.flagChunkBoundaryForUpdate(chunk, (short)(1 << (pos.getY() >> 4)), lightType, dir, LightingHooks.getAxisDirection(dir, pos.getX(), pos.getZ()), boundaryFacing);
    }

    public static void flagChunkBoundaryForUpdate(Chunk chunk, short sectionMask, EnumSkyBlock lightType, EnumFacing dir, AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        LightingHooks.initNeighborLightChecks(chunk);
        short[] sArray = ((IChunkLightingData)chunk).getNeighborLightChecks();
        int n = LightingHooks.getFlagIndex(lightType, dir, axisDirection, boundaryFacing);
        sArray[n] = (short)(sArray[n] | sectionMask);
        chunk.func_76630_e();
    }

    public static int getFlagIndex(EnumSkyBlock lightType, int xOffset, int zOffset, AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return (lightType == EnumSkyBlock.Block ? 0 : 16) | xOffset + 1 << 2 | zOffset + 1 << 1 | axisDirection.getOffset() + 1 | boundaryFacing.ordinal();
    }

    public static int getFlagIndex(EnumSkyBlock lightType, EnumFacing dir, AxisDirection axisDirection, EnumBoundaryFacing boundaryFacing) {
        return LightingHooks.getFlagIndex(lightType, dir.func_82601_c(), dir.func_82599_e(), axisDirection, boundaryFacing);
    }

    private static AxisDirection getAxisDirection(EnumFacing dir, int x, int z) {
        return ((dir == EnumFacing.EAST || dir == EnumFacing.WEST ? z : x) & 0xF) < 8 ? AxisDirection.NEGATIVE : AxisDirection.POSITIVE;
    }

    private static EnumFacing getOpposite(EnumFacing in) {
        switch (in) {
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
        }
        throw new IllegalArgumentException();
    }

    private static AxisDirection getAxisDirection(EnumFacing in) {
        switch (in) {
            case NORTH: 
            case WEST: 
            case DOWN: {
                return AxisDirection.NEGATIVE;
            }
        }
        return AxisDirection.POSITIVE;
    }

    public static void scheduleRelightChecksForChunkBoundaries(World world, Chunk chunk) {
        for (EnumFacing dir : HORIZONTAL_FACINGS) {
            int xOffset = dir.func_82601_c();
            int zOffset = dir.func_82599_e();
            Chunk nChunk = LightingEngineHelpers.getLoadedChunk(world.func_72863_F(), chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset);
            if (nChunk == null) continue;
            for (EnumSkyBlock lightType : ENUM_SKY_BLOCK_VALUES) {
                for (AxisDirection axisDir : ENUM_AXIS_DIRECTION_VALUES) {
                    LightingHooks.mergeFlags(lightType, chunk, nChunk, dir, axisDir);
                    LightingHooks.mergeFlags(lightType, nChunk, chunk, LightingHooks.getOpposite(dir), axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, chunk, nChunk, null, lightType, xOffset, zOffset, axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, nChunk, chunk, null, lightType, -xOffset, -zOffset, axisDir);
                    LightingHooks.scheduleRelightChecksForBoundary(world, nChunk, null, chunk, lightType, zOffset != 0 ? axisDir.getOffset() : 0, xOffset != 0 ? axisDir.getOffset() : 0, LightingHooks.getAxisDirection(dir) == AxisDirection.POSITIVE ? AxisDirection.NEGATIVE : AxisDirection.POSITIVE);
                }
            }
        }
    }

    private static void mergeFlags(EnumSkyBlock lightType, Chunk inChunk, Chunk outChunk, EnumFacing dir, AxisDirection axisDir) {
        IChunkLightingData outChunkLightingData = (IChunkLightingData)outChunk;
        if (outChunkLightingData.getNeighborLightChecks() == null) {
            return;
        }
        IChunkLightingData inChunkLightingData = (IChunkLightingData)inChunk;
        LightingHooks.initNeighborLightChecks(inChunk);
        int inIndex = LightingHooks.getFlagIndex(lightType, dir, axisDir, EnumBoundaryFacing.IN);
        int outIndex = LightingHooks.getFlagIndex(lightType, LightingHooks.getOpposite(dir), axisDir, EnumBoundaryFacing.OUT);
        short[] sArray = inChunkLightingData.getNeighborLightChecks();
        int n = inIndex;
        sArray[n] = (short)(sArray[n] | outChunkLightingData.getNeighborLightChecks()[outIndex]);
    }

    private static void scheduleRelightChecksForBoundary(World world, Chunk chunk, Chunk nChunk, Chunk sChunk, EnumSkyBlock lightType, int xOffset, int zOffset, AxisDirection axisDir) {
        IChunkLightingData chunkLightingData = (IChunkLightingData)chunk;
        if (chunkLightingData.getNeighborLightChecks() == null) {
            return;
        }
        int flagIndex = LightingHooks.getFlagIndex(lightType, xOffset, zOffset, axisDir, EnumBoundaryFacing.IN);
        short flags = chunkLightingData.getNeighborLightChecks()[flagIndex];
        if (flags == 0) {
            return;
        }
        if (nChunk == null && (nChunk = LightingEngineHelpers.getLoadedChunk(world.func_72863_F(), chunk.field_76635_g + xOffset, chunk.field_76647_h + zOffset)) == null) {
            return;
        }
        if (sChunk == null) {
            int theX = chunk.field_76635_g + (zOffset != 0 ? axisDir.getOffset() : 0);
            int theZ = chunk.field_76647_h + (xOffset != 0 ? axisDir.getOffset() : 0);
            sChunk = LightingEngineHelpers.getLoadedChunk(world.func_72863_F(), theX, theZ);
            if (sChunk == null) {
                return;
            }
        }
        int reverseIndex = LightingHooks.getFlagIndex(lightType, -xOffset, -zOffset, axisDir, EnumBoundaryFacing.OUT);
        chunkLightingData.getNeighborLightChecks()[flagIndex] = 0;
        IChunkLightingData nChunkLightingData = (IChunkLightingData)nChunk;
        if (nChunkLightingData.getNeighborLightChecks() != null) {
            nChunkLightingData.getNeighborLightChecks()[reverseIndex] = 0;
        }
        chunk.func_76630_e();
        nChunk.func_76630_e();
        int xMin = chunk.field_76635_g << 4;
        int zMin = chunk.field_76647_h << 4;
        if ((xOffset | zOffset) > 0) {
            xMin += 15 * xOffset;
            zMin += 15 * zOffset;
        }
        if (axisDir == AxisDirection.POSITIVE) {
            xMin += 8 * (zOffset & 1);
            zMin += 8 * (xOffset & 1);
        }
        int xMax = xMin + 7 * (zOffset & 1);
        int zMax = zMin + 7 * (xOffset & 1);
        for (int y = 0; y < 16; ++y) {
            if ((flags & 1 << y) == 0) continue;
            LightingHooks.scheduleRelightChecksForArea(world, lightType, xMin, y << 4, zMin, xMax, (y << 4) + 15, zMax);
        }
    }

    public static void initNeighborLightChecks(Chunk chunk) {
        IChunkLightingData lightingData = (IChunkLightingData)chunk;
        if (lightingData.getNeighborLightChecks() == null) {
            lightingData.setNeighborLightChecks(new short[32]);
        }
    }

    public static void writeNeighborLightChecksToNBT(Chunk chunk, NBTTagCompound nbt) {
        short[] neighborLightChecks = ((IChunkLightingData)chunk).getNeighborLightChecks();
        if (neighborLightChecks == null) {
            return;
        }
        boolean empty = true;
        NBTTagList list = new NBTTagList();
        for (short flags : neighborLightChecks) {
            list.func_74742_a((NBTBase)new NBTTagShort(flags));
            if (flags == 0) continue;
            empty = false;
        }
        if (!empty) {
            nbt.func_74782_a(neighborLightChecksKey, (NBTBase)list);
        }
    }

    public static void readNeighborLightChecksFromNBT(Chunk chunk, NBTTagCompound nbt) {
        if (nbt.func_150297_b(neighborLightChecksKey, 9)) {
            NBTTagList list = nbt.func_150295_c(neighborLightChecksKey, 2);
            if (list.func_74745_c() == 32) {
                LightingHooks.initNeighborLightChecks(chunk);
                short[] neighborLightChecks = ((IChunkLightingData)chunk).getNeighborLightChecks();
                for (int i = 0; i < 32; ++i) {
                    neighborLightChecks[i] = ((NBTTagShort)list.field_74747_a.get(i)).func_150289_e();
                }
            } else {
                ArchaicLogger.LOGGER.warn("Chunk field {} had invalid length, ignoring it (chunk coordinates: {} {})", new Object[]{neighborLightChecksKey, chunk.field_76635_g, chunk.field_76647_h});
            }
        }
    }

    public static void initChunkLighting(Chunk chunk, World world) {
        int xBase = chunk.field_76635_g << 4;
        int zBase = chunk.field_76647_h << 4;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xBase, 0, zBase);
        if (world.func_72904_c(xBase - 16, 0, zBase - 16, xBase + 31, 255, zBase + 31)) {
            ExtendedBlockStorage[] extendedBlockStorage = chunk.func_76587_i();
            for (int j = 0; j < extendedBlockStorage.length; ++j) {
                ExtendedBlockStorage storage = extendedBlockStorage[j];
                if (storage == null) continue;
                int yBase = j * 16;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            Block block = storage.func_150819_a(x, y, z);
                            if (block == Blocks.field_150350_a) continue;
                            pos.setPos(xBase + x, yBase + y, zBase + z);
                            int light = LightingEngineHelpers.getLightValueForState(block, (IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
                            if (light <= 0) continue;
                            world.func_147463_c(EnumSkyBlock.Block, pos.getX(), pos.getY(), pos.getZ());
                        }
                    }
                }
            }
            if (!world.field_73011_w.field_76576_e) {
                ((IChunkLightingData)chunk).setSkylightUpdatedPublic();
            }
            ((IChunkLightingData)chunk).setLightInitialized(true);
        }
    }

    public static void checkChunkLighting(Chunk chunk, World world) {
        if (!((IChunkLightingData)chunk).isLightInitialized()) {
            LightingHooks.initChunkLighting(chunk, world);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Chunk nChunk;
                if (x == 0 && z == 0 || (nChunk = LightingEngineHelpers.getLoadedChunk(world.func_72863_F(), chunk.field_76635_g + x, chunk.field_76647_h + z)) != null && ((IChunkLightingData)nChunk).isLightInitialized()) continue;
                return;
            }
        }
        chunk.field_150814_l = true;
    }

    public static void initSkylightForSection(World world, Chunk chunk, ExtendedBlockStorage section) {
        if (!world.field_73011_w.field_76576_e) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.func_76611_b(x, z) > section.func_76662_d()) continue;
                    for (int y = 0; y < 16; ++y) {
                        section.func_76657_c(x, y, z, EnumSkyBlock.Sky.field_77198_c);
                    }
                }
            }
        }
    }

    private static short[] getNeighborLightChecks(Chunk chunk) {
        return ((IChunkLightingData)chunk).getNeighborLightChecks();
    }

    private static void setNeighborLightChecks(Chunk chunk, short[] table) {
        ((IChunkLightingData)chunk).setNeighborLightChecks(table);
    }

    public static int getCachedLightFor(Chunk chunk, EnumSkyBlock type, int x, int y, int z) {
        return ((IChunkLighting)chunk).getCachedLightFor(type, x, y, z);
    }

    public static ILightingEngine getLightingEngine(World world) {
        return ((ILightingEngineProvider)world).getLightingEngine();
    }

    public static int getIntrinsicOrSavedBlockLightValue(Chunk chunk, int x, int y, int z) {
        int savedLightValue = chunk.func_76614_a(EnumSkyBlock.Block, x, y, z);
        int bx = x + chunk.field_76635_g * 16;
        int bz = z + chunk.field_76647_h * 16;
        Block block = chunk.func_150810_a(x, y, z);
        int lightValue = LightingEngineHelpers.getLightValueForState(block, (IBlockAccess)chunk.field_76637_e, bx, y, bz);
        return Math.max(savedLightValue, lightValue);
    }

    public static enum EnumBoundaryFacing {
        IN,
        OUT;


        public EnumBoundaryFacing getOpposite() {
            return this == IN ? OUT : IN;
        }
    }
}

