/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core;

import com.gitlab.cdagaming.craftpresence.core.integrations.logging.ApacheLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.integrations.logging.JavaLogger;
import io.github.cdagaming.unicore.integrations.logging.LoggingImpl;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class Constants {
    public static final String NAME = "CraftPresence";
    public static final String VERSION_ID = "v2.3.5";
    public static final String VERSION_TYPE = "Release";
    public static final String MOD_ID = "craftpresence";
    public static final String MCBuildVersion = "1.7.10";
    public static final int MCBuildProtocol = StringUtils.getValidInteger("5").getSecond();
    public static final String configDir = OSUtils.USER_DIR + File.separator + "config";
    public static final String modsDir = OSUtils.USER_DIR + File.separator + "mods";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/CraftPresence/update.json";
    public static final boolean IS_LEGACY_SOFT = StringUtils.getValidBoolean("false").getSecond();
    public static final boolean IS_DEV_FLAG = StringUtils.getValidBoolean("false").getSecond();
    public static final boolean IS_VERBOSE_FLAG = StringUtils.getValidBoolean("false").getSecond();
    public static final LoggingImpl LOG = IS_LEGACY_SOFT ? new JavaLogger("craftpresence") : new ApacheLogger("craftpresence");
    public static final TranslationUtils TRANSLATOR = new TranslationUtils("craftpresence", true).build();
    public static boolean HAS_GAME_LOADED = false;
    public static boolean IS_GAME_CLOSING = false;

    public static ScheduledExecutorService getThreadPool() {
        return FileUtils.getThreadPool(NAME);
    }

    public static ThreadFactory getThreadFactory() {
        return FileUtils.getThreadFactory(NAME);
    }

    public static int getModCount() {
        Object mods;
        Object loaderInstance;
        int modCount = -1;
        Class<?> fmlLoader = FileUtils.findValidClass("net.minecraftforge.fml.common.Loader");
        Class<?> quiltLoader = FileUtils.findValidClass("org.quiltmc.loader.api.QuiltLoader");
        Class<?> fabricLoader = FileUtils.findValidClass("net.fabricmc.loader.api.FabricLoader");
        if (fmlLoader != null) {
            Object mods2;
            Object loaderInstance2 = StringUtils.executeMethod(fmlLoader, null, null, null, "instance");
            if (loaderInstance2 != null && (mods2 = StringUtils.executeMethod(fmlLoader, loaderInstance2, null, null, "getModList")) instanceof List) {
                modCount = ((List)mods2).size();
            }
        } else if (quiltLoader != null) {
            Object mods3 = StringUtils.executeMethod(quiltLoader, null, null, null, "getAllMods");
            if (mods3 instanceof List) {
                modCount = ((List)mods3).size();
            }
        } else if (fabricLoader != null && (loaderInstance = StringUtils.executeMethod(fabricLoader, null, null, null, "getInstance")) != null && (mods = StringUtils.executeMethod(fabricLoader, loaderInstance, null, null, "getAllMods")) instanceof List) {
            modCount = ((List)mods).size();
        }
        return modCount > 0 ? modCount : Constants.getRawModCount();
    }

    public static int getRawModCount() {
        int modCount = 0;
        File[] mods = new File(modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return Math.max(1, modCount);
    }
}

