/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_370;

public class TextWidget
extends ExtendedTextControl {
    private String title;
    private int titleLeft;
    private int titleRight;
    private boolean setDimensions;
    private Runnable onHoverEvent = null;

    public TextWidget(int componentId, class_370 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable onHoverEvent) {
        super(componentId, fontRendererObj, 0, y, widthIn, heightIn);
        this.title = title;
        this.setDimensions = false;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(int componentId, class_370 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(componentId, fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_370 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable onHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn);
        this.title = title;
        this.setDimensions = false;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(class_370 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_370 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title, Runnable onHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn, keyEvent);
        this.title = title;
        this.setDimensions = false;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(class_370 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title) {
        this(fontRendererObj, y, widthIn, heightIn, keyEvent, title, null);
    }

    public String getTitle() {
        return this.title;
    }

    public TextWidget setTitle(String title) {
        this.title = title;
        return this;
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        if (!this.setDimensions) {
            int middle = screen.getScreenWidth() / 2;
            this.setControlPosX(middle + 3);
            this.titleLeft = middle - 180;
            this.titleRight = middle - 6;
            this.setDimensions = true;
        }
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title) && this.setDimensions) {
            String mainTitle = Constants.TRANSLATOR.getLocalizedMessage(this.title);
            screen.renderScrollingString(mainTitle, this.titleLeft + screen.getStringWidth(mainTitle) / 2, this.titleLeft, this.getTop(), this.titleRight, this.getBottom(), 0xFFFFFF);
        }
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title) && this.setDimensions && screen.isOverScreen() && RenderUtils.isMouseOver(screen.getMouseX(), screen.getMouseY(), this.titleLeft, this.getTop(), this.titleRight - this.titleLeft, this.getControlHeight())) {
            this.onHover();
        }
    }
}

