/*
 * Decompiled with CFR 0.152.
 */
package net.vfyjxf.nechar.shadow.me.towdium.pinin.utils;

import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public class IndexSet {
    public static final IndexSet ZERO = new IndexSet(1);
    public static final IndexSet ONE = new IndexSet(2);
    public static final IndexSet NONE = new IndexSet(0);
    int value = 0;

    public IndexSet() {
    }

    public IndexSet(IndexSet set) {
        this.value = set.value;
    }

    public IndexSet(int value) {
        this.value = value;
    }

    public void set(int index) {
        int i = 1 << index;
        this.value |= i;
    }

    public boolean get(int index) {
        int i = 1 << index;
        return (this.value & i) != 0;
    }

    public void merge(IndexSet s) {
        this.value = this.value == 1 ? s.value : this.value | s.value;
    }

    public boolean traverse(IntPredicate p) {
        int v = this.value;
        for (int i = 0; i < 7; ++i) {
            if ((v & 1) == 1 && p.test(i)) {
                return true;
            }
            if (v == 0) {
                return false;
            }
            v >>= 1;
        }
        return false;
    }

    public void foreach(IntConsumer c) {
        int v = this.value;
        for (int i = 0; i < 7; ++i) {
            if ((v & 1) == 1) {
                c.accept(i);
            } else if (v == 0) {
                return;
            }
            v >>= 1;
        }
    }

    public void offset(int i) {
        this.value <<= i;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.foreach(i -> {
            builder.append(i);
            builder.append(", ");
        });
        if (builder.length() != 0) {
            builder.delete(builder.length() - 2, builder.length());
            return builder.toString();
        }
        return "0";
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public IndexSet copy() {
        return new IndexSet(this.value);
    }

    static class Storage {
        IndexSet tmp = new Immutable();
        int[] data = new int[16];

        Storage() {
        }

        public void set(IndexSet is, int index) {
            if (index >= this.data.length) {
                int size = index;
                size |= size >> 1;
                size |= size >> 2;
                size |= size >> 4;
                size |= size >> 8;
                size |= size >> 16;
                int[] replace = new int[size + 1];
                System.arraycopy(this.data, 0, replace, 0, this.data.length);
                this.data = replace;
            }
            this.data[index] = is.value + 1;
        }

        public IndexSet get(int index) {
            if (index >= this.data.length) {
                return null;
            }
            int ret = this.data[index];
            if (ret == 0) {
                return null;
            }
            this.tmp.value = ret - 1;
            return this.tmp;
        }
    }

    static class Immutable
    extends IndexSet {
        Immutable() {
        }

        @Override
        public void set(int index) {
            throw new UnsupportedOperationException("Immutable collection");
        }

        @Override
        public void merge(IndexSet s) {
            throw new UnsupportedOperationException("Immutable collection");
        }

        @Override
        public void offset(int i) {
            throw new UnsupportedOperationException("Immutable collection");
        }
    }
}

