/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.Util;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCropSeed
extends ItemIC2 {
    public ItemCropSeed(InternalName internalName) {
        super(internalName);
        this.func_77625_d(1);
        if (!Util.inDev()) {
            this.func_77637_a(null);
        }
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        if (itemstack == null) {
            return "ic2.crop.unknown";
        }
        CropCard cropCard = Crops.instance.getCropCard(itemstack);
        byte level = ItemCropSeed.getScannedFromStack(itemstack);
        if (level == 0) {
            return "ic2.crop.unknown";
        }
        if (level < 0 || cropCard == null) {
            return "ic2.crop.invalid";
        }
        return cropCard.displayName();
    }

    @Override
    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74837_a((String)"ic2.crop.seeds", (Object[])new Object[]{super.func_77653_i(itemStack)});
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean debugTooltips) {
        if (ItemCropSeed.getScannedFromStack(stack) >= 4) {
            info.add("\u00a72Gr\u00a77 " + ItemCropSeed.getGrowthFromStack(stack));
            info.add("\u00a76Ga\u00a77 " + ItemCropSeed.getGainFromStack(stack));
            info.add("\u00a73Re\u00a77 " + ItemCropSeed.getResistanceFromStack(stack));
        }
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int side, float a, float b, float c) {
        TileEntityCrop crop;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop && (crop = (TileEntityCrop)te).tryPlantIn(Crops.instance.getCropCard(itemstack), 1, ItemCropSeed.getGrowthFromStack(itemstack), ItemCropSeed.getGainFromStack(itemstack), ItemCropSeed.getResistanceFromStack(itemstack), ItemCropSeed.getScannedFromStack(itemstack))) {
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
            }
            return true;
        }
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List items) {
        for (CropCard crop : Crops.instance.getCrops()) {
            items.add(ItemCropSeed.generateItemStackFromValues(crop, (byte)1, (byte)1, (byte)1, (byte)4));
        }
    }

    public static ItemStack generateItemStackFromValues(CropCard crop, byte statGrowth, byte statGain, byte statResistance, byte scan) {
        ItemStack stack = new ItemStack(Ic2Items.cropSeed.func_77973_b());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("owner", crop.owner());
        tag.func_74778_a("name", crop.name());
        tag.func_74774_a("growth", statGrowth);
        tag.func_74774_a("gain", statGain);
        tag.func_74774_a("resistance", statResistance);
        tag.func_74774_a("scan", scan);
        stack.func_77982_d(tag);
        return stack;
    }

    public static byte getGrowthFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("growth");
    }

    public static byte getGainFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("gain");
    }

    public static byte getResistanceFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("resistance");
    }

    public static byte getScannedFromStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return -1;
        }
        return is.func_77978_p().func_74771_c("scan");
    }

    public static void incrementScannedOfStack(ItemStack is) {
        if (is.func_77978_p() == null) {
            return;
        }
        is.func_77978_p().func_74774_a("scan", (byte)(ItemCropSeed.getScannedFromStack(is) + 1));
    }
}

