/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import java.awt.Color;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiButtonSmall;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorItem;
import mods.railcraft.common.gui.containers.ContainerDetectorItem;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiDetectorItem
extends TileGui {
    private final String label;
    private final TileDetector tile;
    private final DetectorItem detector;
    private GuiButton filterLeft;
    private GuiButton filterRight;

    public GuiDetectorItem(InventoryPlayer inv, TileDetector tile) {
        super(tile, new ContainerDetectorItem(inv, tile), "railcraft:textures/gui/gui_detector_item.png");
        this.tile = tile;
        this.detector = (DetectorItem)tile.getDetector();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.label = tile.getName();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.tile == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonSmall(0, w + 10, h + 20, 20, "<"));
        this.field_146292_n.add(new GuiButtonSmall(1, w + 146, h + 20, 20, ">"));
        this.filterLeft = new GuiButtonSmall(2, w + 10, h + 40, 20, "<");
        this.field_146292_n.add(this.filterLeft);
        this.filterRight = new GuiButtonSmall(3, w + 146, h + 40, 20, ">");
        this.field_146292_n.add(this.filterRight);
    }

    protected void func_146284_a(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        int primary = this.detector.getPrimaryMode().ordinal();
        int filter = this.detector.getFilterMode().ordinal();
        switch (button.field_146127_k) {
            case 0: {
                --primary;
                break;
            }
            case 1: {
                ++primary;
                break;
            }
            case 2: {
                --filter;
                break;
            }
            case 3: {
                ++filter;
            }
        }
        if (primary < 0) {
            primary = DetectorItem.PrimaryMode.values().length - 1;
        }
        if (primary >= DetectorItem.PrimaryMode.values().length) {
            primary = 0;
        }
        this.detector.setPrimaryMode(DetectorItem.PrimaryMode.values()[primary]);
        if (filter < 0) {
            filter = DetectorItem.FilterMode.values().length - 1;
        }
        if (filter >= DetectorItem.FilterMode.values().length) {
            filter = 0;
        }
        this.detector.setFilterMode(DetectorItem.FilterMode.values()[filter]);
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendToServer(pkt);
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        this.filterLeft.field_146125_m = this.detector.getPrimaryMode() == DetectorItem.PrimaryMode.FILTERED;
        this.filterRight.field_146125_m = this.detector.getPrimaryMode() == DetectorItem.PrimaryMode.FILTERED;
        super.func_146976_a(f, i, j);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int sWidth = this.field_146289_q.func_78256_a(this.label);
        int sPos = this.field_146999_f / 2 - sWidth / 2;
        this.field_146289_q.func_78276_b(this.label, sPos, 6, 0x404040);
        GuiTools.drawCenteredString(this.field_146289_q, this.detector.getPrimaryMode().toString(), 25);
        if (this.detector.getPrimaryMode() != DetectorItem.PrimaryMode.FILTERED) {
            Color color = new Color(0, 0, 0, 80);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            for (int slotNum = 0; slotNum < 9; ++slotNum) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(slotNum);
                int displayX = slot.field_75223_e;
                int displayY = slot.field_75221_f;
                this.func_73733_a(displayX, displayY, displayX + 16, displayY + 16, color.getRGB(), color.getRGB());
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        } else {
            GuiTools.drawCenteredString(this.field_146289_q, this.detector.getFilterMode().toString(), 45);
        }
    }
}

