/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileSignalBase
extends TileSignalFoundation
implements ISignalTile,
IAspectProvider {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    protected static final float BOUNDS = 0.15f;
    private ForgeDirection facing = ForgeDirection.NORTH;
    private int prevLightValue;

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.func_145838_q().func_149676_a(0.15f, 0.35f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            boolean needsUpdate = false;
            int lightValue = this.getLightValue();
            if (this.prevLightValue != lightValue) {
                this.prevLightValue = lightValue;
                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.markBlockForUpdate();
            }
        }
    }

    protected boolean isLit(SignalAspect aspect) {
        return aspect != SignalAspect.OFF && !aspect.isBlinkAspect();
    }

    protected boolean isLit() {
        return this.isLit(this.getSignalAspect());
    }

    protected boolean isBlinking() {
        return this.getSignalAspect().isBlinkAspect();
    }

    @Override
    public int getLightValue() {
        if (this.isLit()) {
            return 5;
        }
        if (this.isBlinking()) {
            return 3;
        }
        return 0;
    }

    public void setFacing(ForgeDirection facing) {
        this.facing = facing;
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("Facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("Facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public abstract SignalAspect getSignalAspect();

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getSignalAspect();
    }
}

