/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.steam;

import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.IndicatorController;
import mods.railcraft.common.util.steam.IFuelProvider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class SteamBoiler {
    public double burnTime;
    public double currentItemBurnTime;
    protected boolean isBurning = false;
    protected byte burnCycle;
    private final StandardTank tankWater;
    private final StandardTank tankSteam;
    private double partialConversions = 0.0;
    private double heat = 20.0;
    private double maxHeat = 500.0;
    private double efficiencyModifier = 1.0;
    private int ticksPerCycle = 16;
    private RailcraftTileEntity tile;
    private IFuelProvider fuelProvider;
    public final IIndicatorController heatIndicator = new HeatIndicator();

    public SteamBoiler(StandardTank tankWater, StandardTank tankSteam) {
        this.tankWater = tankWater;
        this.tankSteam = tankSteam;
    }

    public SteamBoiler setFuelProvider(IFuelProvider fuelProvider) {
        this.fuelProvider = fuelProvider;
        return this;
    }

    public SteamBoiler setTile(RailcraftTileEntity tile) {
        this.tile = tile;
        return this;
    }

    public SteamBoiler setTicksPerCycle(int ticks) {
        this.ticksPerCycle = ticks;
        return this;
    }

    public SteamBoiler setEfficiencyModifier(double modifier) {
        this.efficiencyModifier = modifier;
        return this;
    }

    public SteamBoiler setMaxHeat(double maxHeat) {
        this.maxHeat = maxHeat;
        return this;
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }

    public double getHeatStep() {
        if (this.fuelProvider != null) {
            return this.fuelProvider.getHeatStep();
        }
        return 0.05f;
    }

    public void reset() {
        this.heat = 20.0;
    }

    public double getHeat() {
        return this.heat;
    }

    public void setHeat(double heat) {
        this.heat = heat;
        if (this.heat < 20.0) {
            this.heat = 20.0;
        }
    }

    public double getHeatLevel() {
        return this.heat / 500.0;
    }

    public void increaseHeat(int numTanks) {
        double max = this.getMaxHeat();
        if (this.heat == max) {
            return;
        }
        double step = this.getHeatStep();
        double change = step + (max - this.heat) / max * step * 3.0;
        this.heat += (change /= (double)numTanks);
        this.heat = Math.min(this.heat, max);
    }

    public void reduceHeat(int numTanks) {
        if (this.heat == 20.0) {
            return;
        }
        double step = 0.05f;
        double change = step + this.heat / this.getMaxHeat() * step * 3.0;
        this.heat -= (change /= (double)numTanks);
        this.heat = Math.max(this.heat, 20.0);
    }

    public boolean isBoiling() {
        return this.getHeat() >= 100.0;
    }

    public boolean isSuperHeated() {
        return this.getHeat() >= 300.0;
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean isBurning) {
        this.isBurning = isBurning;
    }

    public boolean hasFuel() {
        return this.burnTime > 0.0;
    }

    public int getBurnProgressScaled(int i) {
        if (!this.isBoiling()) {
            return 0;
        }
        int scale = (int)(this.burnTime / this.currentItemBurnTime * (double)i);
        scale = Math.max(0, scale);
        scale = Math.min(i, scale);
        return scale;
    }

    private boolean addFuel() {
        if (this.fuelProvider == null) {
            return false;
        }
        double fuel = this.fuelProvider.getMoreFuel();
        if (fuel <= 0.0) {
            return false;
        }
        this.burnTime += fuel;
        this.currentItemBurnTime = this.burnTime;
        return true;
    }

    public double getFuelPerCycle(int numTanks) {
        double fuel = 8.0;
        fuel -= (double)((float)numTanks * 8.0f * 0.0125f);
        fuel += (double)0.8f * Math.min(this.getHeatLevel(), 1.0);
        fuel += 4.0 * (this.getMaxHeat() / 1000.0);
        fuel *= (double)numTanks;
        fuel *= this.efficiencyModifier;
        return fuel *= (double)RailcraftConfig.fuelPerSteamMultiplier();
    }

    public void tick(int numTanks) {
        this.burnCycle = (byte)(this.burnCycle + 1);
        if (this.burnCycle >= this.ticksPerCycle) {
            boolean addedFuel;
            this.burnCycle = 0;
            double fuelNeeded = this.getFuelPerCycle(numTanks);
            while (this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
            }
            boolean wasBurning = this.isBurning;
            boolean bl = this.isBurning = this.burnTime >= fuelNeeded;
            if (this.isBurning) {
                this.burnTime -= fuelNeeded;
            }
            if (this.tile != null && this.isBurning != wasBurning) {
                this.tile.sendUpdateToClient();
            }
            this.convertSteam(numTanks);
        }
        if (this.isBurning) {
            this.increaseHeat(numTanks);
        } else {
            this.reduceHeat(numTanks);
        }
    }

    public int convertSteam(int numTanks) {
        if (!this.isBoiling()) {
            return 0;
        }
        this.partialConversions += (double)numTanks * this.getHeatLevel();
        int waterCost = (int)this.partialConversions;
        if (waterCost <= 0) {
            return 0;
        }
        this.partialConversions -= (double)waterCost;
        FluidStack water = this.tankWater.drain(waterCost, false);
        if (water == null) {
            return 0;
        }
        FluidStack steam = Fluids.STEAM.get(160 * (waterCost = Math.min(waterCost, water.amount)));
        if (steam == null) {
            return 0;
        }
        this.tankWater.drain(waterCost, true);
        this.tankSteam.fill(steam, true);
        return steam.amount;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74776_a("heat", (float)this.heat);
        data.func_74776_a("maxHeat", (float)this.maxHeat);
        data.func_74776_a("burnTime", (float)this.burnTime);
        data.func_74776_a("currentItemBurnTime", (float)this.currentItemBurnTime);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.heat = data.func_74760_g("heat");
        this.maxHeat = data.func_74760_g("maxHeat");
        this.burnTime = data.func_74760_g("burnTime");
        this.currentItemBurnTime = data.func_74760_g("currentItemBurnTime");
    }

    private class HeatIndicator
    extends IndicatorController {
        private HeatIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", SteamBoiler.this.getHeat());
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((SteamBoiler.this.getHeat() - 20.0) * (double)size / (SteamBoiler.this.getMaxHeat() - 20.0));
        }
    }
}

