/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet.manager;

import buildcraft.core.tablet.TabletServer;
import buildcraft.core.tablet.manager.TabletThread;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class TabletManagerServer {
    public static final TabletManagerServer INSTANCE = new TabletManagerServer();
    private HashMap<EntityPlayer, TabletThread> threads = new HashMap();

    public TabletServer get(EntityPlayer player) {
        if (!this.threads.containsKey(player)) {
            TabletServer tablet = new TabletServer(player);
            TabletThread thread = new TabletThread(tablet);
            this.threads.put(player, thread);
            new Thread(thread).start();
        }
        return (TabletServer)this.threads.get(player).getTablet();
    }

    public void onServerStopping() {
        for (TabletThread thread : this.threads.values()) {
            thread.stop();
        }
        this.threads.clear();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        for (TabletThread thread : this.threads.values()) {
            thread.tick(0.05f);
        }
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TabletThread thread = this.threads.get(event.player);
        if (thread != null) {
            thread.stop();
            this.threads.remove(event.player);
        }
    }
}

