/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftCore;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileRequester
extends TileBuildCraft
implements IInventory,
IRequestProvider,
ICommandReceiver {
    public static final int NB_ITEMS = 20;
    private SimpleInventory inv = new SimpleInventory(20, "items", 64);
    private SimpleInventory requests = new SimpleInventory(20, "requests", 64);

    public void setRequest(final int index, final ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setRequest", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeByte(index);
                    NetworkUtils.writeStack(data, stack);
                }
            }));
        } else {
            this.requests.func_70299_a(index, stack);
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "setRequest".equals(command)) {
            this.setRequest(stream.readUnsignedByte(), NetworkUtils.readStack(stream));
        }
    }

    public ItemStack getRequestTemplate(int index) {
        return this.requests.func_70301_a(index);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inv.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inv.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inv.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemStack) {
        this.inv.func_70299_a(slotId, itemStack);
    }

    public String func_145825_b() {
        return this.inv.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.inv.func_70300_a(entityPlayer);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (this.requests.func_70301_a(i) == null) {
            return false;
        }
        if (!StackHelper.isMatchingItemOrList(this.requests.func_70301_a(i), itemStack)) {
            return false;
        }
        return this.inv.func_94041_b(i, itemStack);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound invNBT = new NBTTagCompound();
        this.inv.writeToNBT(invNBT);
        nbt.func_74782_a("inv", (NBTBase)invNBT);
        NBTTagCompound reqNBT = new NBTTagCompound();
        this.requests.writeToNBT(reqNBT);
        nbt.func_74782_a("req", (NBTBase)reqNBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt.func_74775_l("inv"));
        this.requests.readFromNBT(nbt.func_74775_l("req"));
    }

    public boolean isFulfilled(int i) {
        if (this.requests.func_70301_a(i) == null) {
            return true;
        }
        if (this.inv.func_70301_a(i) == null) {
            return false;
        }
        return StackHelper.isMatchingItemOrList(this.requests.func_70301_a(i), this.inv.func_70301_a(i)) && this.inv.func_70301_a((int)i).field_77994_a >= this.requests.func_70301_a((int)i).field_77994_a;
    }

    @Override
    public int getRequestsCount() {
        return 20;
    }

    @Override
    public ItemStack getRequest(int i) {
        if (this.requests.func_70301_a(i) == null) {
            return null;
        }
        if (this.isFulfilled(i)) {
            return null;
        }
        ItemStack request = this.requests.func_70301_a(i).func_77946_l();
        ItemStack existingStack = this.inv.func_70301_a(i);
        if (existingStack == null) {
            return request;
        }
        if (!StackHelper.isMatchingItemOrList(request, existingStack)) {
            return null;
        }
        request.field_77994_a -= existingStack.field_77994_a;
        if (request.field_77994_a <= 0) {
            return null;
        }
        return request;
    }

    @Override
    public ItemStack offerItem(int i, ItemStack stack) {
        ItemStack existingStack = this.inv.func_70301_a(i);
        if (this.requests.func_70301_a(i) == null) {
            return stack;
        }
        if (existingStack == null) {
            if (!StackHelper.isMatchingItemOrList(stack, this.requests.func_70301_a(i))) {
                return stack;
            }
            int maxQty = this.requests.func_70301_a((int)i).field_77994_a;
            if (stack.field_77994_a <= maxQty) {
                this.inv.func_70299_a(i, stack);
                return null;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = maxQty;
            stack.field_77994_a -= maxQty;
            this.inv.func_70299_a(i, newStack);
            return stack;
        }
        if (!StackHelper.isMatchingItemOrList(stack, existingStack)) {
            return stack;
        }
        if (StackHelper.isMatchingItemOrList(stack, this.requests.func_70301_a(i))) {
            int maxQty = this.requests.func_70301_a((int)i).field_77994_a;
            if (existingStack.field_77994_a + stack.field_77994_a <= maxQty) {
                existingStack.field_77994_a += stack.field_77994_a;
                return null;
            }
            stack.field_77994_a -= maxQty - existingStack.field_77994_a;
            existingStack.field_77994_a = maxQty;
            return stack;
        }
        return stack;
    }
}

