/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.events.PipeEventFluid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsClay
extends Pipe<PipeTransportFluids> {
    public PipeFluidsClay(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.PipeFluidsClay.ordinal();
    }

    public void eventHandler(PipeEventFluid.FindDest event) {
        HashSet<ForgeDirection> machineDirs = new HashSet<ForgeDirection>();
        HashSet<ForgeDirection> pipeDirs = new HashSet<ForgeDirection>();
        for (ForgeDirection dir : event.destinations) {
            IFluidHandler h;
            TileEntity e;
            if (!this.container.isPipeConnected(dir) || !((e = this.container.getTile(dir)) instanceof IFluidHandler) || (h = (IFluidHandler)e).fill(dir.getOpposite(), event.fluidStack, false) <= 0) continue;
            if (e instanceof IPipeTile) {
                pipeDirs.add(dir);
                continue;
            }
            machineDirs.add(dir);
        }
        event.destinations.clear();
        event.destinations.addAll(machineDirs.size() > 0 ? machineDirs : pipeDirs);
    }
}

