/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandGameRule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFYeti;
import twilightforest.integration.TFBaublesIntegration;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class TFEventListener {
    protected HashMap<String, InventoryPlayer> playerKeepsMap = new HashMap();
    protected HashMap<String, ItemStack[]> playerBaublesMap = new HashMap();
    private boolean isBreakingWithGiantPick = false;
    private boolean shouldMakeGiantCobble = false;
    private int amountOfCobbleToReplace = 0;
    private long lastSpawnedHintMonsterTime;

    @SubscribeEvent
    public void pickupItem(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_73011_w.field_76574_g == TwilightForestMod.dimensionID) {
            Item item = event.item.func_92059_d().func_77973_b();
            if (item == TFItems.scepterTwilight || item == TFItems.scepterLifeDrain || item == TFItems.scepterZombie) {
                this.checkPlayerForScepterMastery(event.entityPlayer);
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressLich);
            } else if (item == TFItems.nagaScale) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressNaga);
            } else if (item == TFItems.trophy) {
                switch (event.item.func_92059_d().func_77960_j()) {
                    case 0: {
                        event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightKillHydra);
                        break;
                    }
                    case 1: {
                        event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightKillNaga);
                        break;
                    }
                    case 2: {
                        event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightKillLich);
                        break;
                    }
                    case 3: {
                        event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressUrghast);
                        break;
                    }
                    case 4: {
                        event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressGlacier);
                    }
                }
            } else if (item == TFItems.mazebreakerPick) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightMazebreaker);
            } else if (item == TFItems.meefStroganoff || item == TFItems.minotaurAxe) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressLabyrinth);
            } else if (item == TFItems.fieryBlood) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressHydra);
            } else if (item == TFItems.phantomHelm || item == TFItems.phantomPlate) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressKnights);
            } else if (item == TFItems.fieryTears) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressUrghast);
            } else if (item == TFItems.alphaFur || item == TFItems.yetiBoots || item == TFItems.yetiHelm || item == TFItems.yetiPlate || item == TFItems.yetiLegs) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressYeti);
            } else if (item == TFItems.lampOfCinders) {
                event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightProgressTroll);
            }
        }
    }

    private void checkPlayerForScepterMastery(EntityPlayer player) {
        boolean scepterTwilight = false;
        boolean scepterLifeDrain = false;
        boolean scepterZombie = false;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item == TFItems.scepterTwilight) {
                scepterTwilight = true;
                continue;
            }
            if (item == TFItems.scepterLifeDrain) {
                scepterLifeDrain = true;
                continue;
            }
            if (item != TFItems.scepterZombie) continue;
            scepterZombie = true;
        }
        if (scepterTwilight & scepterLifeDrain & scepterZombie) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightLichScepters);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        Item item = itemStack.func_77973_b();
        if (item == TFItems.plateNaga || item == TFItems.legsNaga) {
            this.checkPlayerForNagaArmorer(player);
        } else if (item == TFItems.magicMapFocus) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMapFocus);
        } else if (item == TFItems.emptyMagicMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMap);
        } else if (item == TFItems.emptyMazeMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMazeMap);
        } else if (item == TFItems.emptyOreMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightOreMap);
        } else if (item == Item.func_150898_a((Block)Blocks.field_150344_f) && itemStack.field_77994_a == 64 && this.doesCraftMatrixHaveGiantLog(event.craftMatrix)) {
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.field_150344_f, 64));
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.field_150344_f, 64));
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.field_150344_f, 64));
        }
    }

    private void addToPlayerInventoryOrDrop(EntityPlayer player, ItemStack itemStack) {
        if (!player.field_71071_by.func_70441_a(itemStack)) {
            player.func_71019_a(itemStack, false);
        }
    }

    private boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)TFBlocks.giantLog)) continue;
            return true;
        }
        return false;
    }

    private void checkPlayerForNagaArmorer(EntityPlayer player) {
        boolean nagaScale = false;
        boolean legsNaga = false;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item == TFItems.nagaScale) {
                nagaScale = true;
                continue;
            }
            if (item != TFItems.legsNaga) continue;
            legsNaga = true;
        }
        if (nagaScale & legsNaga) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightNagaArmors);
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.harvester.field_71071_by.func_70448_g() != null && event.harvester.field_71071_by.func_70448_g().func_77973_b().func_150897_b(event.block) && event.harvester.field_71071_by.func_70448_g().func_77973_b() == TFItems.fieryPick) {
            ArrayList<ItemStack> removeThese = new ArrayList<ItemStack>(1);
            ArrayList<ItemStack> addThese = new ArrayList<ItemStack>(1);
            for (ItemStack input : event.drops) {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
                if (result == null) continue;
                addThese.add(new ItemStack(result.func_77973_b(), input.field_77994_a));
                removeThese.add(input);
                this.spawnSpeltXP(result, event.world, event.x, event.y, event.z);
            }
            event.drops.removeAll(removeThese);
            event.drops.addAll(addThese);
        }
        if (this.shouldMakeGiantCobble && event.drops.size() > 0 && ((ItemStack)event.drops.get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            event.drops.remove(0);
            if (this.amountOfCobbleToReplace == 64) {
                event.drops.add(new ItemStack(TFBlocks.giantCobble));
            }
            --this.amountOfCobbleToReplace;
            if (this.amountOfCobbleToReplace <= 0) {
                this.shouldMakeGiantCobble = false;
            }
        }
    }

    private void spawnSpeltXP(ItemStack smelted, World world, int x, int y, int z) {
        int smeltXP;
        float floatXP = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
        if (floatXP > (float)(smeltXP = (int)floatXP) && world.field_73012_v.nextFloat() < floatXP - (float)smeltXP) {
            ++smeltXP;
        }
        while (smeltXP > 0) {
            int splitXP = EntityXPOrb.func_70527_a((int)smeltXP);
            smeltXP -= splitXP;
            world.func_72838_d((Entity)new EntityXPOrb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, splitXP));
        }
    }

    @SubscribeEvent
    public void entityHurts(LivingHurtEvent event) {
        EntityPlayer player;
        boolean damageSourceIsNotNull;
        boolean entityIsPlayer = event.entityLiving instanceof EntityPlayer;
        boolean damageSourceIsMob = event.source.field_76373_n.equals("mob");
        boolean damageSourceIsArrow = event.source.field_76373_n.equals("arrow");
        boolean damageSourceIsPlayer = event.source.func_76346_g() instanceof EntityPlayer;
        boolean bl = damageSourceIsNotNull = event.source.func_76346_g() != null;
        if (damageSourceIsNotNull) {
            ItemStack playerHeldItemStack;
            if (entityIsPlayer && damageSourceIsMob) {
                int chillLevel;
                player = (EntityPlayer)event.entityLiving;
                int fireLevel = TFEnchantment.getFieryAuraLevel(player.field_71071_by, event.source);
                if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                    event.source.func_76346_g().func_70015_d(fireLevel / 2);
                }
                if (event.source.func_76346_g() instanceof EntityLivingBase && (chillLevel = TFEnchantment.getChillAuraLevel(player.field_71071_by, event.source)) > 0) {
                    ((EntityLivingBase)event.source.func_76346_g()).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, chillLevel * 5 + 5, chillLevel));
                }
            }
            if (damageSourceIsArrow && damageSourceIsPlayer && (playerHeldItemStack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null) {
                Item playerHeldItem = playerHeldItemStack.func_77973_b();
                if (playerHeldItem == TFItems.tripleBow) {
                    event.entityLiving.field_70172_ad = 0;
                } else if (playerHeldItem == TFItems.iceBow) {
                    event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2, true));
                } else if (playerHeldItem == TFItems.enderBow) {
                    double sourceX = player.field_70165_t;
                    double sourceY = player.field_70163_u;
                    double sourceZ = player.field_70161_v;
                    float sourceYaw = player.field_70177_z;
                    float sourcePitch = player.field_70125_A;
                    player.field_70177_z = event.entityLiving.field_70177_z;
                    player.field_70125_A = event.entityLiving.field_70125_A;
                    player.func_70634_a(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v);
                    player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                    event.entityLiving.func_70080_a(sourceX, sourceY, sourceZ, sourceYaw, sourcePitch);
                    event.entityLiving.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                }
            }
        }
        if (entityIsPlayer && this.willEntityDie(event)) {
            boolean charm2;
            player = (EntityPlayer)event.entityLiving;
            boolean charm1 = false;
            boolean bl2 = charm2 = TFBaublesIntegration.consumeBaublesItem(player, TFItems.charmOfLife2) != false || player.field_71071_by.func_146026_a(TFItems.charmOfLife2);
            if (!charm2) {
                boolean bl3 = charm1 = TFBaublesIntegration.consumeBaublesItem(player, TFItems.charmOfLife1) != false || player.field_71071_by.func_146026_a(TFItems.charmOfLife1);
            }
            if (charm2 || charm1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.ammount = 0.0f;
                if (charm1) {
                    player.func_70606_j(8.0f);
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 0));
                } else if (charm2) {
                    player.func_70606_j((float)player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 600, 3));
                    player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 600, 0));
                    player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 600, 0));
                }
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
        }
    }

    public boolean willEntityDie(LivingHurtEvent event) {
        float amount = event.ammount;
        DamageSource source = event.source;
        EntityLivingBase living = event.entityLiving;
        if (!source.func_76363_c()) {
            int armor = 25 - living.func_70658_aO();
            amount = amount * (float)armor / 25.0f;
        }
        if (living.func_70644_a(Potion.field_76429_m)) {
            int resistance = 25 - (living.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            amount = amount * (float)resistance / 25.0f;
        }
        return Math.ceil(amount) >= Math.floor(living.func_110143_aJ());
    }

    @SubscribeEvent
    public void bonemealUsed(BonemealEvent event) {
        if (event.block == TFBlocks.sapling && !event.world.field_72995_K) {
            ((BlockSapling)TFBlocks.sapling).func_149878_d(event.world, event.x, event.y, event.z, event.world.field_73012_v);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void livingDies(LivingDeathEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            if (!event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                int i;
                ItemStack[] baublesInventory;
                InventoryPlayer keepInventory;
                if (TFBaublesIntegration.consumeBaublesItem(player, TFItems.charmOfKeeping3).booleanValue() || player.field_71071_by.func_146026_a(TFItems.charmOfKeeping3)) {
                    FMLLog.info((String)"[TwilightForest] Player died with charm of keeping III!  Keep it all!", (Object[])new Object[0]);
                    keepInventory = new InventoryPlayer(null);
                    baublesInventory = TFBaublesIntegration.keepAllBaubles(player);
                    this.keepAllArmor(player, keepInventory);
                    for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                        player.field_71071_by.field_70462_a[i] = null;
                    }
                    keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping3));
                    this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
                    if (baublesInventory != null) {
                        this.playerBaublesMap.put(player.func_70005_c_(), baublesInventory);
                    }
                } else if (TFBaublesIntegration.consumeBaublesItem(player, TFItems.charmOfKeeping2).booleanValue() || player.field_71071_by.func_146026_a(TFItems.charmOfKeeping2)) {
                    FMLLog.info((String)"[TwilightForest] Player died with charm of keeping II!  Keep armor and hotbar!", (Object[])new Object[0]);
                    keepInventory = new InventoryPlayer(null);
                    baublesInventory = TFBaublesIntegration.keepAllBaubles(player);
                    this.keepAllArmor(player, keepInventory);
                    for (i = 0; i < 9; ++i) {
                        keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                        player.field_71071_by.field_70462_a[i] = null;
                    }
                    keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping2));
                    this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
                    if (baublesInventory != null) {
                        this.playerBaublesMap.put(player.func_70005_c_(), baublesInventory);
                    }
                } else if (TFBaublesIntegration.consumeBaublesItem(player, TFItems.charmOfKeeping1).booleanValue() || player.field_71071_by.func_146026_a(TFItems.charmOfKeeping1)) {
                    int currentItem;
                    FMLLog.info((String)"[TwilightForest] Player died with charm of keeping I!  Keep armor and current item!", (Object[])new Object[0]);
                    keepInventory = new InventoryPlayer(null);
                    baublesInventory = TFBaublesIntegration.keepAllBaubles(player);
                    this.keepAllArmor(player, keepInventory);
                    if (player.field_71071_by.func_70448_g() != null && (currentItem = player.field_71071_by.field_70461_c) <= 8 & currentItem >= 0) {
                        keepInventory.field_70462_a[currentItem] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[currentItem]);
                        player.field_71071_by.field_70462_a[currentItem] = null;
                    }
                    keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping1));
                    this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
                    if (baublesInventory != null) {
                        this.playerBaublesMap.put(player.func_70005_c_(), baublesInventory);
                    }
                }
                if (player.field_71071_by.func_146028_b(TFItems.towerKey)) {
                    keepInventory = this.retrieveOrMakeKeepInventory(player);
                    for (int i2 = 0; i2 < player.field_71071_by.field_70462_a.length; ++i2) {
                        if (player.field_71071_by.field_70462_a[i2] == null || player.field_71071_by.field_70462_a[i2].func_77973_b() != TFItems.towerKey) continue;
                        keepInventory.field_70462_a[i2] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i2]);
                        player.field_71071_by.field_70462_a[i2] = null;
                    }
                    this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
                }
            }
        }
        if (this.playerKeepsMap.size() > 1) {
            FMLLog.warning((String)"[TwilightForest] Twilight Forest mod is keeping track of a lot of dead player inventories.  Has there been an apocalypse?", (Object[])new Object[0]);
        }
    }

    private InventoryPlayer retrieveOrMakeKeepInventory(EntityPlayer player) {
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            return this.playerKeepsMap.get(player.func_70005_c_());
        }
        return new InventoryPlayer(null);
    }

    private void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            keepInventory.field_70460_b[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70460_b[i]);
            player.field_71071_by.field_70460_b[i] = null;
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_()) || this.playerBaublesMap.containsKey(player.func_70005_c_())) {
            FMLLog.info((String)"[TwilightForest] Player %s respawned and recieved items held in storage", (Object[])new Object[]{player.func_70005_c_()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            ItemStack[] baublesInventory = this.playerBaublesMap.get(player.func_70005_c_());
            if (keepInventory != null) {
                int i;
                for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                    if (keepInventory.field_70460_b[i] == null) continue;
                    player.field_71071_by.field_70460_b[i] = keepInventory.field_70460_b[i];
                }
                for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    if (keepInventory.field_70462_a[i] == null) continue;
                    player.field_71071_by.field_70462_a[i] = keepInventory.field_70462_a[i];
                }
            }
            if (TwilightForestMod.areBaublesLoaded && baublesInventory != null) {
                InventoryBaubles inventoryBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
                for (int i = 0; i < inventoryBaubles.func_70302_i_(); ++i) {
                    if (baublesInventory[i] == null) continue;
                    inventoryBaubles.func_70299_a(i, baublesInventory[i]);
                }
            }
            if (keepInventory.func_70445_o() != null) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            FMLLog.warning((String)"[TwilightForest] Mod was keeping inventory items in reserve for player %s but they logged out!  Items are being dropped.", (Object[])new Object[]{player.func_70005_c_()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public boolean preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && this.isRidingUnfriendly((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public boolean livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.func_70093_af() && this.isRidingUnfriendly(event.entityLiving)) {
            event.entity.func_70095_a(false);
        }
        return true;
    }

    private boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.func_70115_ae() && (entity.field_70154_o instanceof EntityTFPinchBeetle || entity.field_70154_o instanceof EntityTFYeti);
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().field_71075_bZ.field_75098_d && this.isAreaProtected(event.world, event.getPlayer(), event.x, event.y, event.z) && this.isBlockProtectedFromBreaking(event.world, event.x, event.y, event.z)) {
            event.setCanceled(true);
        } else if (!this.isBreakingWithGiantPick && event.getPlayer().func_71045_bC() != null && event.getPlayer().func_71045_bC().func_77973_b() == TFItems.giantPick && event.getPlayer().func_71045_bC().func_77973_b().func_150897_b(event.block)) {
            int metaThere;
            Block blockThere;
            int dz;
            int dy;
            int dx;
            this.isBreakingWithGiantPick = true;
            int bx = event.x >> 2 << 2;
            int by = event.y >> 2 << 2;
            int bz = event.z >> 2 << 2;
            boolean allCobble = event.block.func_149650_a(event.blockMetadata, event.world.field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        blockThere = event.world.func_147439_a(bx + dx, by + dy, bz + dz);
                        allCobble &= blockThere.func_149650_a(metaThere = event.world.func_72805_g(bx + dx, by + dy, bz + dz), event.world.field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
                    }
                }
            }
            if (allCobble && !event.getPlayer().field_71075_bZ.field_75098_d) {
                this.shouldMakeGiantCobble = true;
                this.amountOfCobbleToReplace = 64;
            } else {
                this.shouldMakeGiantCobble = false;
                this.amountOfCobbleToReplace = 0;
            }
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        EntityPlayer entityPlayer;
                        blockThere = event.world.func_147439_a(bx + dx, by + dy, bz + dz);
                        metaThere = event.world.func_72805_g(bx + dx, by + dy, bz + dz);
                        if (event.x == bx + dx && event.y == by + dy && event.z == bz + dz || blockThere != event.block || metaThere != event.blockMetadata || !((entityPlayer = event.getPlayer()) instanceof EntityPlayerMP)) continue;
                        EntityPlayerMP playerMP = (EntityPlayerMP)entityPlayer;
                        playerMP.field_71134_c.func_73084_b(bx + dx, by + dy, bz + dz);
                    }
                }
            }
            this.isBreakingWithGiantPick = false;
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent event) {
        ItemStack currentItem;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest && !event.entityPlayer.field_71075_bZ.field_75098_d) {
            World world = event.entityPlayer.field_70170_p;
            EntityPlayer player = event.entityPlayer;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            if (!world.field_72995_K && this.isBlockProtectedFromInteraction(world, x, y, z) && this.isAreaProtected(world, player, x, y, z)) {
                event.useBlock = Event.Result.DENY;
            }
        }
        if ((currentItem = event.entityPlayer.field_71071_by.func_70448_g()) != null && (currentItem.func_77973_b() == TFItems.fierySword || currentItem.func_77973_b() == TFItems.fieryPick) && this.checkPlayerForFieryArmor(event.entityPlayer)) {
            event.entityPlayer.func_71029_a((StatBase)TFAchievementPage.twilightFierySet);
        }
    }

    private boolean isBlockProtectedFromInteraction(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == TFBlocks.towerDevice || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_150430_aB || block == Blocks.field_150471_bO || block == Blocks.field_150442_at;
    }

    private boolean isBlockProtectedFromBreaking(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return !block.func_149739_a().equals("tile.openblocks.grave");
    }

    private boolean checkPlayerForFieryArmor(EntityPlayer entityPlayer) {
        ItemStack[] armor = entityPlayer.field_71071_by.field_70460_b;
        if (armor[0] != null && armor[0].func_77973_b() == TFItems.fieryBoots) {
            return true;
        }
        if (armor[1] != null && armor[1].func_77973_b() == TFItems.fieryLegs) {
            return true;
        }
        if (armor[2] != null && armor[2].func_77973_b() == TFItems.fieryPlate) {
            return true;
        }
        return armor[3] != null && armor[3].func_77973_b() == TFItems.fieryHelm;
    }

    private boolean isAreaProtected(World world, EntityPlayer player, int x, int y, int z) {
        TFFeature nearbyFeature;
        ChunkProviderTwilightForest chunkProvider;
        if (world.func_82736_K().func_82766_b("tfEnforcedProgression") && world.field_73011_w instanceof WorldProviderTwilightForest && (chunkProvider = ((WorldProviderTwilightForest)world.field_73011_w).getChunkProvider()) != null && chunkProvider.isBlockInStructureBB(x, y, z) && !(nearbyFeature = ((TFWorldChunkManager)world.field_73011_w.field_76578_c).getFeatureAt(x, z, world)).doesPlayerHaveRequiredAchievement(player) && chunkProvider.isBlockProtected(x, y, z)) {
            StructureBoundingBox sbb = chunkProvider.getSBBAt(x, y, z);
            this.sendAreaProtectionPacket(world, x, y, z, sbb);
            nearbyFeature.trySpawnHintMonster(world, player, x, y, z);
            return true;
        }
        return false;
    }

    private void sendAreaProtectionPacket(World world, int x, int y, int z, StructureBoundingBox sbb) {
        FMLProxyPacket message = TFGenericPacketHandler.makeAreaProtectionPacket(sbb, x, y, z);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 64.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        if (event.entityLiving instanceof IMob && event.source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)event.source.func_76346_g()).field_71075_bZ.field_75098_d && event.entityLiving.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest && event.entityLiving.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression")) {
            TFFeature nearbyFeature;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)event.entityLiving.field_70170_p.field_73011_w).getChunkProvider();
            int mx = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t);
            int my = MathHelper.func_76128_c((double)event.entityLiving.field_70163_u);
            int mz = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v);
            if (chunkProvider != null && chunkProvider.isBlockInStructureBB(mx, my, mz) && chunkProvider.isBlockProtected(mx, my, mz) && !(nearbyFeature = ((TFWorldChunkManager)event.entityLiving.field_70170_p.field_73011_w.field_76578_c).getFeatureAt(mx, mz, event.entityLiving.field_70170_p)).doesPlayerHaveRequiredAchievement((EntityPlayer)event.source.func_76346_g())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                for (int i = 0; i < 20; ++i) {
                    TwilightForestMod.proxy.spawnParticle(event.entityLiving.field_70170_p, "protection", event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        TwilightForestMod.hasBiomeIdConflicts = TFBiomeBase.areThereBiomeIdConflicts();
        if (TwilightForestMod.hasBiomeIdConflicts) {
            event.player.func_145747_a((IChatComponent)new ChatComponentText("[TwilightForest] Biome ID conflict detected.  Fix by editing the config file."));
        }
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            this.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
        }
    }

    @SubscribeEvent
    public void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP && event.toDim == TwilightForestMod.dimensionID) {
            this.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
        }
    }

    private void sendEnforcedProgressionStatus(EntityPlayerMP player, boolean isEnforced) {
        TwilightForestMod.genericChannel.sendTo(TFGenericPacketHandler.makeEnforcedProgressionStatusPacket(isEnforced), player);
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load event) {
        if (!event.world.field_72995_K && !event.world.func_82736_K().func_82765_e("tfEnforcedProgression")) {
            FMLLog.info((String)"[TwilightForest] Loaded a world with the tfEnforcedProgression game rule not defined.  Defining it.", (Object[])new Object[0]);
            event.world.func_82736_K().func_82769_a("tfEnforcedProgression", "true");
        }
    }

    @SubscribeEvent
    public void commandSent(CommandEvent event) {
        if (event.command instanceof CommandGameRule && event.parameters.length > 1 && "tfEnforcedProgression".equals(event.parameters[0])) {
            boolean isEnforced = Boolean.parseBoolean(event.parameters[1]);
            TwilightForestMod.genericChannel.sendToAll(TFGenericPacketHandler.makeEnforcedProgressionStatusPacket(isEnforced));
        }
    }
}

