/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Slope;
import com.carpentersblocks.renderer.BlockHandlerSloped;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.renderer.helper.slope.oblique.HelperCorner;
import com.carpentersblocks.renderer.helper.slope.oblique.HelperOblWedge;
import com.carpentersblocks.renderer.helper.slope.oblique.HelperOblique;
import com.carpentersblocks.renderer.helper.slope.oblique.HelperPrism;
import com.carpentersblocks.renderer.helper.slope.orthogonal.HelperOrthoWedge;
import com.carpentersblocks.renderer.helper.slope.orthogonal.HelperTriangle;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersSlope
extends BlockHandlerSloped {
    private int slopeID;
    private float LIGHTNESS_XYNN = 0.6f;
    private float LIGHTNESS_XYPN = 0.55f;
    private float LIGHTNESS_ZYNN = 0.7f;
    private float LIGHTNESS_ZYPN = 0.65f;
    private float LIGHTNESS_XYNP = 0.85f;
    private float LIGHTNESS_XYPP = 0.8f;
    private float LIGHTNESS_ZYNP = 0.95f;
    private float LIGHTNESS_ZYPP = 0.9f;
    private float LIGHTNESS_XZPP = 0.7f;
    private float LIGHTNESS_XYZPPP = 0.9f;
    private float LIGHTNESS_XYZPNP = 0.65f;
    private final int NORMAL_YN = 0;
    private final int NORMAL_YP = 1;
    private final int NORMAL_ZN = 2;
    private final int NORMAL_ZP = 3;
    private final int NORMAL_XN = 4;
    private final int NORMAL_XP = 5;
    private final int TRIANGLE_XZNN = 6;
    private final int TRIANGLE_XZNP = 7;
    private final int TRIANGLE_XZPP = 8;
    private final int TRIANGLE_XZPN = 9;
    private final int TRIANGLE_ZXNP = 10;
    private final int TRIANGLE_ZXNN = 11;
    private final int TRIANGLE_ZXPN = 12;
    private final int TRIANGLE_ZXPP = 13;
    private final int WEDGE_YN = 14;
    private final int WEDGE_YP = 15;
    private final int WEDGE_SLOPED_ZN = 16;
    private final int WEDGE_ZN = 17;
    private final int WEDGE_SLOPED_ZP = 18;
    private final int WEDGE_ZP = 19;
    private final int WEDGE_SLOPED_XN = 20;
    private final int WEDGE_XN = 21;
    private final int WEDGE_SLOPED_XP = 22;
    private final int WEDGE_XP = 23;
    private final int WEDGE_CORNER_SLOPED_ZN = 24;
    private final int WEDGE_CORNER_SLOPED_ZP = 25;
    private final int WEDGE_CORNER_SLOPED_XN = 26;
    private final int WEDGE_CORNER_SLOPED_XP = 27;
    private final int OBL_INT_YN = 28;
    private final int OBL_INT_YP = 29;
    private final int OBL_EXT_LEFT_YP = 30;
    private final int OBL_EXT_RIGHT_YP = 31;
    private final int OBL_EXT_LEFT_YN = 32;
    private final int OBL_EXT_RIGHT_YN = 33;
    private final int PRISM_YZNN = 34;
    private final int PRISM_YZNP = 35;
    private final int PRISM_YXNN = 36;
    private final int PRISM_YXNP = 37;
    private final int PRISM_YZPN = 38;
    private final int PRISM_YZPP = 39;
    private final int PRISM_YXPN = 40;
    private final int PRISM_YXPP = 41;
    private final int PRISM_NORTH_XN = 42;
    private final int PRISM_NORTH_XP = 43;
    private final int PRISM_SOUTH_XN = 44;
    private final int PRISM_SOUTH_XP = 45;
    private final int PRISM_WEST_ZN = 46;
    private final int PRISM_WEST_ZP = 47;
    private final int PRISM_EAST_ZN = 48;
    private final int PRISM_EAST_ZP = 49;
    private final int PRISM_WEDGE_ZN = 50;
    private final int PRISM_WEDGE_ZP = 51;
    private final int PRISM_WEDGE_XN = 52;
    private final int PRISM_WEDGE_XP = 53;
    private boolean forceFullFrame = false;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        IIcon icon = renderBlocks.func_147758_b(((BlockCoverable)block).getIcon());
        renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        switch (metadata) {
            case 4: {
                tessellator.func_78371_b(4);
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
                HelperTriangle.renderFaceXNegZNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
                HelperTriangle.renderFaceXNegZPos(renderBlocks, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(0.0f, 0.5f, -1.0f);
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
                HelperPrism.renderWestPointSlopeZNeg(renderBlocks, 0.0, 0.0, 0.0, IconRegistry.icon_uncovered_quartered);
                tessellator.func_78375_b(0.0f, 0.5f, 1.0f);
                renderBlocks.func_147782_a(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
                HelperPrism.renderWestPointSlopeZPos(renderBlocks, 0.0, 0.0, 0.0, IconRegistry.icon_uncovered_quartered);
                tessellator.func_78381_a();
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case 0: {
                tessellator.func_78371_b(4);
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                HelperOrthoWedge.renderFaceZNeg(renderBlocks, 10, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                HelperOrthoWedge.renderFaceZPos(renderBlocks, 10, 0.0, 0.0, 0.0, icon);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                RenderHelper.renderFaceYNeg(renderBlocks, 0.0, 0.0, 0.0, block.func_149691_a(0, 16));
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                RenderHelper.renderFaceXPos(renderBlocks, 0.0, 0.0, 0.0, block.func_149691_a(2, 16));
                tessellator.func_78375_b(-1.0f, 0.5f, 0.0f);
                HelperOblWedge.renderSlopeXNeg(renderBlocks, 10, 0.0, 0.0, 0.0, icon);
                break;
            }
            case 1: {
                tessellator.func_78371_b(4);
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                HelperOrthoWedge.renderFaceYPos(renderBlocks, 35, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                HelperOrthoWedge.renderFaceZPos(renderBlocks, 35, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                HelperOrthoWedge.renderFaceXNeg(renderBlocks, 35, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(-1.0f, 0.5f, 1.0f);
                HelperOblique.renderIntObliqueYPos(renderBlocks, 35, 0.0, 0.0, 0.0, IconRegistry.icon_uncovered_oblique_pos);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                RenderHelper.renderFaceZNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                RenderHelper.renderFaceXPos(renderBlocks, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                RenderHelper.renderFaceYNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                break;
            }
            case 2: {
                tessellator.func_78371_b(4);
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                HelperOrthoWedge.renderFaceYNeg(renderBlocks, 43, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                HelperOrthoWedge.renderFaceZNeg(renderBlocks, 43, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                HelperOrthoWedge.renderFaceXPos(renderBlocks, 43, 0.0, 0.0, 0.0, icon);
                tessellator.func_78375_b(-1.0f, 0.5f, 1.0f);
                HelperOblique.renderExtObliqueYPosLeft(renderBlocks, 43, 0.0, 0.0, 0.0, IconRegistry.icon_uncovered_oblique_pos);
                HelperOblique.renderExtObliqueYPosRight(renderBlocks, 43, 0.0, 0.0, 0.0, IconRegistry.icon_uncovered_oblique_pos);
                break;
            }
            case 3: {
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                tessellator.func_78371_b(4);
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
                tessellator.func_78375_b(-1.0f, 0.5f, 0.0f);
                HelperPrism.renderSlopeYPosZNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
                tessellator.func_78375_b(1.0f, 0.5f, 0.0f);
                HelperPrism.renderSlopeYPosZPos(renderBlocks, 0.0, 0.0, 0.0, icon);
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
                tessellator.func_78375_b(0.0f, 0.5f, -1.0f);
                HelperPrism.renderSlopeYPosXNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
                tessellator.func_78375_b(0.0f, 0.5f, 1.0f);
                HelperPrism.renderSlopeYPosXPos(renderBlocks, 0.0, 0.0, 0.0, icon);
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                RenderHelper.renderFaceYNeg(renderBlocks, 0.0, 0.0, 0.0, icon);
                break;
            }
            default: {
                return;
            }
        }
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        if (isSideSloped) {
            Block block = BlockProperties.toBlock(itemStack);
            Slope slope = Slope.getSlope(this.TE);
            int metadata = itemStack.func_77960_j();
            if (!this.TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                switch (slope.type) {
                    case OBLIQUE_EXT: 
                    case OBLIQUE_INT: {
                        icon = slope.isPositive ? IconRegistry.icon_uncovered_oblique_pos : IconRegistry.icon_uncovered_oblique_neg;
                        break;
                    }
                    case PRISM: 
                    case PRISM_1P: 
                    case PRISM_2P: 
                    case PRISM_3P: 
                    case PRISM_4P: 
                    case PRISM_WEDGE: {
                        if (this.forceFullFrame) {
                            icon = IconRegistry.icon_uncovered_full;
                            break;
                        }
                        icon = IconRegistry.icon_uncovered_quartered;
                        break;
                    }
                }
            } else {
                if (BlockProperties.blockRotates(itemStack)) {
                    icon = metadata % 8 == 0 ? block.func_149691_a(slope.isPositive ? 1 : 0, metadata) : block.func_149691_a(2, metadata);
                } else if (block instanceof BlockDirectional && !slope.type.equals((Object)Slope.Type.WEDGE)) {
                    icon = block.func_149733_h(1);
                }
                if (slope.isPositive && block.func_149688_o().equals(Material.field_151577_b)) {
                    icon = block.func_149691_a(1, metadata);
                }
            }
        }
        return icon;
    }

    @Override
    protected void renderBaseSide(int x, int y, int z, int side, IIcon icon) {
        switch (this.renderID) {
            case 0: {
                RenderHelper.renderFaceYNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 1: {
                RenderHelper.renderFaceYPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 2: {
                RenderHelper.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 3: {
                RenderHelper.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 4: {
                RenderHelper.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 5: {
                RenderHelper.renderFaceXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 6: {
                HelperTriangle.renderFaceXNegZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 7: {
                HelperTriangle.renderFaceXNegZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 8: {
                HelperTriangle.renderFaceXPosZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 9: {
                HelperTriangle.renderFaceXPosZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 10: {
                HelperTriangle.renderFaceZNegXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 11: {
                HelperTriangle.renderFaceZNegXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 12: {
                HelperTriangle.renderFaceZPosXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 13: {
                HelperTriangle.renderFaceZPosXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 14: {
                HelperOrthoWedge.renderFaceYNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 15: {
                HelperOrthoWedge.renderFaceYPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 16: {
                HelperOblWedge.renderSlopeZNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 17: {
                HelperOrthoWedge.renderFaceZNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 18: {
                HelperOblWedge.renderSlopeZPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 19: {
                HelperOrthoWedge.renderFaceZPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 20: {
                HelperOblWedge.renderSlopeXNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 21: {
                HelperOrthoWedge.renderFaceXNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 22: {
                HelperOblWedge.renderSlopeXPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 23: {
                HelperOrthoWedge.renderFaceXPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 24: {
                HelperCorner.renderSlopeZNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 25: {
                HelperCorner.renderSlopeZPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 26: {
                HelperCorner.renderSlopeXNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 27: {
                HelperCorner.renderSlopeXPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 28: {
                HelperOblique.renderIntObliqueYNeg(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 29: {
                HelperOblique.renderIntObliqueYPos(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 30: {
                HelperOblique.renderExtObliqueYPosLeft(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 31: {
                HelperOblique.renderExtObliqueYPosRight(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 32: {
                HelperOblique.renderExtObliqueYNegLeft(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 33: {
                HelperOblique.renderExtObliqueYNegRight(this.renderBlocks, this.slopeID, x, y, z, icon);
                break;
            }
            case 34: {
                HelperPrism.renderSlopeYNegZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 35: {
                HelperPrism.renderSlopeYNegZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 36: {
                HelperPrism.renderSlopeYNegXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 37: {
                HelperPrism.renderSlopeYNegXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 38: {
                HelperPrism.renderSlopeYPosZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 39: {
                HelperPrism.renderSlopeYPosZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 40: {
                HelperPrism.renderSlopeYPosXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 41: {
                HelperPrism.renderSlopeYPosXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 42: {
                HelperPrism.renderNorthPointSlopeXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 43: {
                HelperPrism.renderNorthPointSlopeXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 44: {
                HelperPrism.renderSouthPointSlopeXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 45: {
                HelperPrism.renderSouthPointSlopeXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 46: {
                HelperPrism.renderWestPointSlopeZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 47: {
                HelperPrism.renderWestPointSlopeZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 48: {
                HelperPrism.renderEastPointSlopeZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 49: {
                HelperPrism.renderEastPointSlopeZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 50: {
                HelperPrism.renderWedgeSlopeZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 51: {
                HelperPrism.renderWedgeSlopeZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 52: {
                HelperPrism.renderWedgeSlopeXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 53: {
                HelperPrism.renderWedgeSlopeXPos(this.renderBlocks, x, y, z, icon);
            }
        }
    }

    public void renderSlope(ItemStack itemStack, Slope slope, int x, int y, int z, boolean ignoreSideRenderChecks) {
        this.slopeID = slope.slopeID;
        this.renderBlocks.field_147863_w = this.getEnableAO(itemStack);
        isSideSloped = true;
        switch (slope.getPrimaryType()) {
            case WEDGE_SIDE: {
                this.prepareHorizontalWedge(itemStack, slope, x, y, z);
                break;
            }
            case WEDGE: {
                this.prepareVerticalWedge(itemStack, slope, x, y, z);
                break;
            }
            case WEDGE_INT: {
                this.prepareWedgeIntCorner(itemStack, slope, x, y, z);
                break;
            }
            case WEDGE_EXT: {
                this.prepareWedgeExtCorner(itemStack, slope, x, y, z);
                break;
            }
            case OBLIQUE_INT: {
                this.prepareObliqueIntCorner(itemStack, slope, x, y, z);
                break;
            }
            case OBLIQUE_EXT: {
                this.prepareObliqueExtCorner(itemStack, slope, x, y, z);
                break;
            }
            case PRISM: {
                this.preparePrism(itemStack, slope, x, y, z);
                break;
            }
            case PRISM_WEDGE: {
                this.preparePrismWedge(itemStack, slope, x, y, z);
                break;
            }
        }
        isSideSloped = false;
        this.lightingHelper.clearLightnessOverride();
        if (slope.hasSide(ForgeDirection.DOWN) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x, y - 1, z, 0))) {
            this.prepareFaceYNeg(itemStack, slope, x, y, z);
        }
        if (slope.hasSide(ForgeDirection.UP) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x, y + 1, z, 1))) {
            this.prepareFaceYPos(itemStack, slope, x, y, z);
        }
        if (slope.hasSide(ForgeDirection.NORTH) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x, y, z - 1, 2))) {
            this.prepareFaceZNeg(itemStack, slope, x, y, z);
        }
        if (slope.hasSide(ForgeDirection.SOUTH) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x, y, z + 1, 3))) {
            this.prepareFaceZPos(itemStack, slope, x, y, z);
        }
        if (slope.hasSide(ForgeDirection.WEST) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x - 1, y, z, 4))) {
            this.prepareFaceXNeg(itemStack, slope, x, y, z);
        }
        if (slope.hasSide(ForgeDirection.EAST) && (ignoreSideRenderChecks || this.srcBlock.func_149646_a(this.renderBlocks.field_147845_a, x + 1, y, z, 5))) {
            this.prepareFaceXPos(itemStack, slope, x, y, z);
        }
        VertexHelper.startDrawing(7);
        this.renderBlocks.field_147863_w = false;
    }

    @Override
    public void renderBaseBlock(ItemStack itemStack, int x, int y, int z) {
        Slope slope = Slope.getSlope(this.TE);
        this.renderSlope(itemStack, slope, x, y, z, false);
    }

    @Override
    protected boolean isPositiveFace(int side) {
        return super.isPositiveFace(side) || isSideSloped && Slope.getSlope((TEBase)this.TE).isPositive;
    }

    private void preparePrism(ItemStack itemStack, Slope slope, int x, int y, int z) {
        int POINT_N = 0;
        int POINT_S = 1;
        int POINT_W = 2;
        int POINT_E = 3;
        ArrayList<Integer> pieceList = new ArrayList<Integer>();
        if (slope.facings.contains(ForgeDirection.NORTH)) {
            pieceList.add(POINT_N);
        }
        if (slope.facings.contains(ForgeDirection.SOUTH)) {
            pieceList.add(POINT_S);
        }
        if (slope.facings.contains(ForgeDirection.WEST)) {
            pieceList.add(POINT_W);
        }
        if (slope.facings.contains(ForgeDirection.EAST)) {
            pieceList.add(POINT_E);
        }
        VertexHelper.startDrawing(4);
        if (pieceList.contains(POINT_N)) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
            this.setIDAndRender(itemStack, 42, x, y, z, 4);
            this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
            this.setIDAndRender(itemStack, 43, x, y, z, 5);
        } else if (slope.isPositive) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
            this.setIDAndRender(itemStack, 38, x, y, z, 2);
        } else {
            this.renderBlocks.func_147782_a(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_NEG_N, x, y, z);
            this.setIDAndRender(itemStack, 34, x, y, z, 2);
        }
        if (pieceList.contains(POINT_S)) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
            this.setIDAndRender(itemStack, 44, x, y, z, 4);
            this.renderBlocks.func_147782_a(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
            this.setIDAndRender(itemStack, 45, x, y, z, 5);
        } else if (slope.isPositive) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
            this.setIDAndRender(itemStack, 39, x, y, z, 3);
        } else {
            this.renderBlocks.func_147782_a(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_NEG_S, x, y, z);
            this.setIDAndRender(itemStack, 35, x, y, z, 3);
        }
        if (pieceList.contains(POINT_W)) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
            this.setIDAndRender(itemStack, 46, x, y, z, 2);
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
            this.setIDAndRender(itemStack, 47, x, y, z, 3);
        } else if (slope.isPositive) {
            this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
            this.setIDAndRender(itemStack, 40, x, y, z, 4);
        } else {
            this.renderBlocks.func_147782_a(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_NEG_W, x, y, z);
            this.setIDAndRender(itemStack, 36, x, y, z, 4);
        }
        if (pieceList.contains(POINT_E)) {
            this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
            this.setIDAndRender(itemStack, 48, x, y, z, 2);
            this.renderBlocks.func_147782_a(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
            this.setIDAndRender(itemStack, 49, x, y, z, 3);
        } else if (slope.isPositive) {
            this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
            this.setIDAndRender(itemStack, 41, x, y, z, 5);
        } else {
            this.renderBlocks.func_147782_a(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
            this.setWedgeLighting(itemStack, Slope.WEDGE_NEG_E, x, y, z);
            this.setIDAndRender(itemStack, 37, x, y, z, 5);
        }
    }

    private void preparePrismWedge(ItemStack itemStack, Slope slope, int x, int y, int z) {
        switch (slope.slopeID) {
            case 61: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
                this.setIDAndRender(itemStack, 42, x, y, z, 4);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
                this.setIDAndRender(itemStack, 43, x, y, z, 5);
                VertexHelper.startDrawing(7);
                this.forceFullFrame = true;
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
                this.setIDAndRender(itemStack, 50, x, y, z, 2);
                this.forceFullFrame = false;
                break;
            }
            case 62: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
                this.setIDAndRender(itemStack, 44, x, y, z, 4);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
                this.setIDAndRender(itemStack, 45, x, y, z, 5);
                VertexHelper.startDrawing(7);
                this.forceFullFrame = true;
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
                this.setIDAndRender(itemStack, 51, x, y, z, 3);
                this.forceFullFrame = false;
                break;
            }
            case 63: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
                this.setIDAndRender(itemStack, 46, x, y, z, 2);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
                this.setIDAndRender(itemStack, 47, x, y, z, 3);
                VertexHelper.startDrawing(7);
                this.forceFullFrame = true;
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_W, x, y, z);
                this.setIDAndRender(itemStack, 52, x, y, z, 4);
                this.forceFullFrame = false;
                break;
            }
            case 64: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_N, x, y, z);
                this.setIDAndRender(itemStack, 48, x, y, z, 2);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_S, x, y, z);
                this.setIDAndRender(itemStack, 49, x, y, z, 3);
                VertexHelper.startDrawing(7);
                this.forceFullFrame = true;
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.setWedgeLighting(itemStack, Slope.WEDGE_POS_E, x, y, z);
                this.setIDAndRender(itemStack, 53, x, y, z, 5);
                this.forceFullFrame = false;
            }
        }
    }

    private void setWedgeLighting(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.prepareLighting(itemStack, x, y, z);
        IBlockAccess world = this.renderBlocks.field_147845_a;
        boolean solid_YP = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d + 1, this.TE.field_145849_e, ForgeDirection.DOWN, false);
        boolean solid_YN = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d - 1, this.TE.field_145849_e, ForgeDirection.UP, false);
        switch (slope.slopeID) {
            case 1: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XZPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[4][0];
                this.lightingHelper.ao[1] = this.offset_ao[4][1];
                this.lightingHelper.ao[2] = this.offset_ao[2][2];
                this.lightingHelper.ao[3] = this.offset_ao[2][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[4][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[4][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[2][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[2][3];
                break;
            }
            case 2: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XZPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[2][0];
                this.lightingHelper.ao[1] = this.offset_ao[2][1];
                this.lightingHelper.ao[2] = this.offset_ao[5][2];
                this.lightingHelper.ao[3] = this.offset_ao[5][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[2][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[2][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[5][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[5][3];
                break;
            }
            case 3: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XZPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[3][0];
                this.lightingHelper.ao[1] = this.offset_ao[3][1];
                this.lightingHelper.ao[2] = this.offset_ao[4][2];
                this.lightingHelper.ao[3] = this.offset_ao[4][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[3][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[3][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[4][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[4][3];
                break;
            }
            case 0: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XZPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[5][0];
                this.lightingHelper.ao[1] = this.offset_ao[5][1];
                this.lightingHelper.ao[2] = this.offset_ao[3][2];
                this.lightingHelper.ao[3] = this.offset_ao[3][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[5][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[5][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[3][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[3][3];
                break;
            }
            case 4: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_ZYNN);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = solid_YN ? this.offset_ao[1][0] : this.ao[0][0];
                this.lightingHelper.ao[1] = this.offset_ao[0][1];
                this.lightingHelper.ao[2] = this.offset_ao[0][2];
                this.lightingHelper.ao[3] = solid_YN ? this.offset_ao[1][3] : this.ao[0][3];
                this.renderBlocks.field_147864_al = solid_YN ? this.offset_brightness[1][0] : this.brightness[0][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[0][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[0][2];
                this.renderBlocks.field_147870_ao = solid_YN ? this.offset_brightness[1][3] : this.brightness[0][3];
                break;
            }
            case 8: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_ZYNP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][0] : this.ao[1][0];
                this.lightingHelper.ao[1] = this.offset_ao[1][1];
                this.lightingHelper.ao[2] = this.offset_ao[1][2];
                this.lightingHelper.ao[3] = solid_YP ? this.offset_ao[0][3] : this.ao[1][3];
                this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][0] : this.brightness[1][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[1][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[1][2];
                this.renderBlocks.field_147870_ao = solid_YP ? this.offset_brightness[0][3] : this.brightness[1][3];
                break;
            }
            case 5: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_ZYPN);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[0][0];
                this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][1] : this.ao[0][1];
                this.lightingHelper.ao[2] = solid_YN ? this.offset_ao[1][2] : this.ao[0][2];
                this.lightingHelper.ao[3] = this.offset_ao[0][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[0][0];
                this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][1] : this.brightness[0][1];
                this.renderBlocks.field_147876_an = solid_YN ? this.offset_brightness[1][2] : this.brightness[0][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[0][3];
                break;
            }
            case 9: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_ZYPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[1][0];
                this.lightingHelper.ao[1] = solid_YP ? this.offset_ao[0][1] : this.ao[1][1];
                this.lightingHelper.ao[2] = solid_YP ? this.offset_ao[0][2] : this.ao[1][2];
                this.lightingHelper.ao[3] = this.offset_ao[1][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[1][0];
                this.renderBlocks.field_147874_am = solid_YP ? this.offset_brightness[0][1] : this.brightness[1][1];
                this.renderBlocks.field_147876_an = solid_YP ? this.offset_brightness[0][2] : this.brightness[1][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[1][3];
                break;
            }
            case 6: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYNN);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = solid_YN ? this.offset_ao[1][0] : this.ao[0][0];
                this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][1] : this.ao[0][1];
                this.lightingHelper.ao[2] = this.offset_ao[0][2];
                this.lightingHelper.ao[3] = this.offset_ao[0][3];
                this.renderBlocks.field_147864_al = solid_YN ? this.offset_brightness[1][0] : this.brightness[0][0];
                this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][1] : this.brightness[0][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[0][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[0][3];
                break;
            }
            case 10: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYNP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][0] : this.ao[1][0];
                this.lightingHelper.ao[1] = solid_YP ? this.offset_ao[0][1] : this.ao[1][1];
                this.lightingHelper.ao[2] = this.offset_ao[1][2];
                this.lightingHelper.ao[3] = this.offset_ao[1][3];
                this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][0] : this.brightness[1][0];
                this.renderBlocks.field_147874_am = solid_YP ? this.offset_brightness[0][1] : this.brightness[1][1];
                this.renderBlocks.field_147876_an = this.offset_brightness[1][2];
                this.renderBlocks.field_147870_ao = this.offset_brightness[1][3];
                break;
            }
            case 7: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYPN);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[0][0];
                this.lightingHelper.ao[1] = this.offset_ao[0][1];
                this.lightingHelper.ao[2] = solid_YN ? this.offset_ao[1][2] : this.ao[0][2];
                this.lightingHelper.ao[3] = solid_YN ? this.offset_ao[1][3] : this.ao[0][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[0][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[0][1];
                this.renderBlocks.field_147876_an = solid_YN ? this.offset_brightness[1][2] : this.brightness[0][2];
                this.renderBlocks.field_147870_ao = solid_YN ? this.offset_brightness[1][3] : this.brightness[0][3];
                break;
            }
            case 11: {
                this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYPP);
                if (!this.renderBlocks.field_147863_w) break;
                this.lightingHelper.ao[0] = this.offset_ao[1][0];
                this.lightingHelper.ao[1] = this.offset_ao[1][1];
                this.lightingHelper.ao[2] = solid_YP ? this.offset_ao[0][2] : this.ao[1][2];
                this.lightingHelper.ao[3] = solid_YP ? this.offset_ao[0][3] : this.ao[1][3];
                this.renderBlocks.field_147864_al = this.offset_brightness[1][0];
                this.renderBlocks.field_147874_am = this.offset_brightness[1][1];
                this.renderBlocks.field_147876_an = solid_YP ? this.offset_brightness[0][2] : this.brightness[1][2];
                this.renderBlocks.field_147870_ao = solid_YP ? this.offset_brightness[0][3] : this.brightness[1][3];
            }
        }
    }

    private void prepareHorizontalWedge(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(7);
        this.setWedgeLighting(itemStack, slope, x, y, z);
        if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setIDAndRender(itemStack, 16, x, y, z, 5);
        } else {
            this.setIDAndRender(itemStack, 18, x, y, z, 4);
        }
    }

    private void prepareVerticalWedge(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(7);
        this.setWedgeLighting(itemStack, slope, x, y, z);
        if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setIDAndRender(itemStack, 16, x, y, z, 2);
        } else if (slope.facings.contains(ForgeDirection.SOUTH)) {
            this.setIDAndRender(itemStack, 18, x, y, z, 3);
        } else if (slope.facings.contains(ForgeDirection.WEST)) {
            this.setIDAndRender(itemStack, 20, x, y, z, 4);
        } else {
            this.setIDAndRender(itemStack, 22, x, y, z, 5);
        }
    }

    private void prepareWedgeIntCorner(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(4);
        Slope slopeX = slope.facings.contains(ForgeDirection.WEST) ? (slope.isPositive ? Slope.WEDGE_POS_W : Slope.WEDGE_NEG_W) : (slope.isPositive ? Slope.WEDGE_POS_E : Slope.WEDGE_NEG_E);
        this.setWedgeLighting(itemStack, slopeX, x, y, z);
        if (slopeX.facings.contains(ForgeDirection.WEST)) {
            this.setIDAndRender(itemStack, 26, x, y, z, 4);
        } else {
            this.setIDAndRender(itemStack, 27, x, y, z, 5);
        }
        Slope slopeZ = slope.facings.contains(ForgeDirection.NORTH) ? (slope.isPositive ? Slope.WEDGE_POS_N : Slope.WEDGE_NEG_N) : (slope.isPositive ? Slope.WEDGE_POS_S : Slope.WEDGE_NEG_S);
        this.setWedgeLighting(itemStack, slopeZ, x, y, z);
        if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setIDAndRender(itemStack, 24, x, y, z, 2);
        } else {
            this.setIDAndRender(itemStack, 25, x, y, z, 3);
        }
    }

    private void prepareWedgeExtCorner(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(4);
        Slope slopeX = slope.facings.contains(ForgeDirection.WEST) ? (slope.isPositive ? Slope.WEDGE_POS_W : Slope.WEDGE_NEG_W) : (slope.isPositive ? Slope.WEDGE_POS_E : Slope.WEDGE_NEG_E);
        this.setWedgeLighting(itemStack, slopeX, x, y, z);
        if (slopeX.facings.contains(ForgeDirection.WEST)) {
            this.setIDAndRender(itemStack, 26, x, y, z, 4);
        } else {
            this.setIDAndRender(itemStack, 27, x, y, z, 5);
        }
        Slope slopeZ = slope.facings.contains(ForgeDirection.NORTH) ? (slope.isPositive ? Slope.WEDGE_POS_N : Slope.WEDGE_NEG_N) : (slope.isPositive ? Slope.WEDGE_POS_S : Slope.WEDGE_NEG_S);
        this.setWedgeLighting(itemStack, slopeZ, x, y, z);
        if (slope.facings.contains(ForgeDirection.NORTH)) {
            this.setIDAndRender(itemStack, 24, x, y, z, 2);
        } else {
            this.setIDAndRender(itemStack, 25, x, y, z, 3);
        }
    }

    private void prepareObliqueIntCorner(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(4);
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.prepareLighting(itemStack, x, y, z);
        IBlockAccess world = this.renderBlocks.field_147845_a;
        boolean solid_YP = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d + 1, this.TE.field_145849_e, ForgeDirection.DOWN, false);
        boolean solid_YN = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d - 1, this.TE.field_145849_e, ForgeDirection.UP, false);
        if (this.renderBlocks.field_147863_w) {
            switch (slope.slopeID) {
                case 29: {
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][1] : this.ao[0][1];
                    this.lightingHelper.ao[2] = this.offset_ao[0][2];
                    this.lightingHelper.ao[3] = solid_YN ? this.offset_ao[1][3] : this.ao[0][3];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][1] : this.brightness[0][1];
                    this.renderBlocks.field_147876_an = this.offset_brightness[0][2];
                    this.renderBlocks.field_147870_ao = solid_YN ? this.offset_brightness[1][3] : this.brightness[0][3];
                    break;
                }
                case 30: {
                    this.lightingHelper.ao[0] = solid_YN ? this.offset_ao[1][0] : this.ao[0][0];
                    this.lightingHelper.ao[1] = this.offset_ao[0][1];
                    this.lightingHelper.ao[2] = solid_YN ? this.offset_ao[1][2] : this.ao[0][2];
                    this.renderBlocks.field_147864_al = solid_YN ? this.offset_brightness[1][0] : this.brightness[0][0];
                    this.renderBlocks.field_147874_am = this.offset_brightness[0][1];
                    this.renderBlocks.field_147876_an = solid_YN ? this.offset_brightness[1][2] : this.brightness[0][2];
                    break;
                }
                case 31: {
                    this.lightingHelper.ao[0] = solid_YN ? this.offset_ao[1][0] : this.ao[0][0];
                    this.lightingHelper.ao[2] = solid_YN ? this.offset_ao[1][2] : this.ao[0][2];
                    this.lightingHelper.ao[3] = this.offset_ao[0][3];
                    this.renderBlocks.field_147864_al = solid_YN ? this.offset_brightness[1][0] : this.brightness[0][0];
                    this.renderBlocks.field_147876_an = solid_YN ? this.offset_brightness[1][2] : this.brightness[0][2];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[0][3];
                    break;
                }
                case 28: {
                    this.lightingHelper.ao[0] = this.offset_ao[0][0];
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][1] : this.ao[0][1];
                    this.lightingHelper.ao[3] = solid_YN ? this.offset_ao[1][3] : this.ao[0][3];
                    this.renderBlocks.field_147864_al = this.offset_brightness[0][0];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][1] : this.brightness[0][1];
                    this.renderBlocks.field_147870_ao = solid_YN ? this.offset_brightness[1][3] : this.brightness[0][3];
                    break;
                }
                case 33: {
                    this.lightingHelper.ao[1] = solid_YP ? this.offset_ao[0][1] : this.ao[1][1];
                    this.lightingHelper.ao[2] = this.offset_ao[1][2];
                    this.lightingHelper.ao[3] = solid_YP ? this.offset_ao[0][3] : this.ao[1][3];
                    this.renderBlocks.field_147874_am = solid_YP ? this.offset_brightness[0][1] : this.brightness[1][1];
                    this.renderBlocks.field_147876_an = this.offset_brightness[1][2];
                    this.renderBlocks.field_147870_ao = solid_YP ? this.offset_brightness[0][3] : this.brightness[1][3];
                    break;
                }
                case 34: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][0] : this.ao[1][0];
                    this.lightingHelper.ao[1] = this.offset_ao[1][1];
                    this.lightingHelper.ao[2] = solid_YP ? this.offset_ao[0][2] : this.ao[1][2];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][0] : this.brightness[1][0];
                    this.renderBlocks.field_147874_am = this.offset_brightness[1][1];
                    this.renderBlocks.field_147876_an = solid_YP ? this.offset_brightness[0][2] : this.brightness[1][2];
                    break;
                }
                case 35: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][0] : this.ao[1][0];
                    this.lightingHelper.ao[2] = solid_YP ? this.offset_ao[0][2] : this.ao[1][2];
                    this.lightingHelper.ao[3] = this.offset_ao[1][3];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][0] : this.brightness[1][0];
                    this.renderBlocks.field_147876_an = solid_YP ? this.offset_brightness[0][2] : this.brightness[1][2];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[1][3];
                    break;
                }
                case 32: {
                    this.lightingHelper.ao[0] = this.offset_ao[1][0];
                    this.lightingHelper.ao[1] = solid_YP ? this.offset_ao[0][1] : this.ao[1][1];
                    this.lightingHelper.ao[3] = solid_YP ? this.offset_ao[0][3] : this.ao[1][3];
                    this.renderBlocks.field_147864_al = this.offset_brightness[1][0];
                    this.renderBlocks.field_147874_am = solid_YP ? this.offset_brightness[0][1] : this.brightness[1][1];
                    int n = this.renderBlocks.field_147870_ao = solid_YP ? this.offset_brightness[0][3] : this.brightness[1][3];
                }
            }
        }
        if (slope.isPositive) {
            this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYZPPP);
            this.setIDAndRender(itemStack, 29, x, y, z, 2);
        } else {
            this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYZPNP);
            this.setIDAndRender(itemStack, 28, x, y, z, 2);
        }
    }

    private void prepareObliqueExtCorner(ItemStack itemStack, Slope slope, int x, int y, int z) {
        VertexHelper.startDrawing(4);
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.prepareLighting(itemStack, x, y, z);
        IBlockAccess world = this.renderBlocks.field_147845_a;
        boolean solid_YP = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d + 1, this.TE.field_145849_e, ForgeDirection.DOWN, false);
        boolean solid_YN = world.isSideSolid(this.TE.field_145851_c, this.TE.field_145848_d - 1, this.TE.field_145849_e, ForgeDirection.UP, false);
        if (this.renderBlocks.field_147863_w) {
            switch (slope.slopeID) {
                case 37: {
                    this.lightingHelper.ao[0] = this.offset_ao[0][1];
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][0] : this.ao[0][0];
                    this.lightingHelper.ao[3] = this.offset_ao[0][3];
                    this.renderBlocks.field_147864_al = this.offset_brightness[0][1];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][0] : this.brightness[0][0];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[0][3];
                    break;
                }
                case 38: {
                    this.lightingHelper.ao[0] = this.offset_ao[0][0];
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][3] : this.ao[0][3];
                    this.lightingHelper.ao[3] = this.offset_ao[0][2];
                    this.renderBlocks.field_147864_al = this.offset_brightness[0][0];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][3] : this.brightness[0][3];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[0][2];
                    break;
                }
                case 39: {
                    this.lightingHelper.ao[0] = this.offset_ao[0][2];
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][1] : this.ao[0][1];
                    this.lightingHelper.ao[3] = this.offset_ao[0][0];
                    this.renderBlocks.field_147864_al = this.offset_brightness[0][2];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][1] : this.brightness[0][1];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[0][0];
                    break;
                }
                case 36: {
                    this.lightingHelper.ao[0] = this.offset_ao[0][3];
                    this.lightingHelper.ao[1] = solid_YN ? this.offset_ao[1][2] : this.ao[0][2];
                    this.lightingHelper.ao[3] = this.offset_ao[0][1];
                    this.renderBlocks.field_147864_al = this.offset_brightness[0][3];
                    this.renderBlocks.field_147874_am = solid_YN ? this.offset_brightness[1][2] : this.brightness[0][2];
                    this.renderBlocks.field_147870_ao = this.offset_brightness[0][1];
                    break;
                }
                case 41: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][0] : this.ao[1][0];
                    this.lightingHelper.ao[1] = this.offset_ao[1][1];
                    this.lightingHelper.ao[2] = this.offset_ao[1][3];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][0] : this.brightness[1][0];
                    this.renderBlocks.field_147874_am = this.offset_brightness[1][1];
                    this.renderBlocks.field_147876_an = this.offset_brightness[1][3];
                    break;
                }
                case 42: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][3] : this.ao[1][3];
                    this.lightingHelper.ao[1] = this.offset_ao[1][0];
                    this.lightingHelper.ao[2] = this.offset_ao[1][2];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][3] : this.brightness[1][3];
                    this.renderBlocks.field_147874_am = this.offset_brightness[1][0];
                    this.renderBlocks.field_147876_an = this.offset_brightness[1][2];
                    break;
                }
                case 43: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][1] : this.ao[1][1];
                    this.lightingHelper.ao[1] = this.offset_ao[1][2];
                    this.lightingHelper.ao[2] = this.offset_ao[1][0];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][1] : this.brightness[1][1];
                    this.renderBlocks.field_147874_am = this.offset_brightness[1][2];
                    this.renderBlocks.field_147876_an = this.offset_brightness[1][0];
                    break;
                }
                case 40: {
                    this.lightingHelper.ao[0] = solid_YP ? this.offset_ao[0][2] : this.ao[1][2];
                    this.lightingHelper.ao[1] = this.offset_ao[1][3];
                    this.lightingHelper.ao[2] = this.offset_ao[1][1];
                    this.renderBlocks.field_147864_al = solid_YP ? this.offset_brightness[0][2] : this.brightness[1][2];
                    this.renderBlocks.field_147874_am = this.offset_brightness[1][3];
                    this.renderBlocks.field_147876_an = this.offset_brightness[1][1];
                }
            }
        }
        if (slope.isPositive) {
            this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYZPPP);
            this.setIDAndRender(itemStack, 30, x, y, z, 2);
            this.setIDAndRender(itemStack, 31, x, y, z, 2);
        } else {
            this.lightingHelper.setLightnessOverride(this.LIGHTNESS_XYZPNP);
            this.setIDAndRender(itemStack, 32, x, y, z, 2);
            this.setIDAndRender(itemStack, 33, x, y, z, 2);
        }
    }

    private void prepareFaceYNeg(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.DOWN)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 14, x, y, z, 0);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 0, x, y, z, 0);
            }
        }
    }

    private void prepareFaceYPos(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.UP)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 15, x, y, z, 1);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 1, x, y, z, 1);
            }
        }
    }

    private void prepareFaceZNeg(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.NORTH)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 17, x, y, z, 2);
                break;
            }
            case TRIANGLE: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
                this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 10, x, y, z, 2);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
                this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 11, x, y, z, 2);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 2, x, y, z, 2);
            }
        }
    }

    private void prepareFaceZPos(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.SOUTH)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 19, x, y, z, 3);
                break;
            }
            case TRIANGLE: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
                this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 12, x, y, z, 3);
                this.renderBlocks.func_147782_a(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
                this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 13, x, y, z, 3);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 3, x, y, z, 3);
            }
        }
    }

    private void prepareFaceXNeg(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.WEST)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 21, x, y, z, 4);
                break;
            }
            case TRIANGLE: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
                this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 6, x, y, z, 4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
                this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 7, x, y, z, 4);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 4, x, y, z, 4);
            }
        }
    }

    private void prepareFaceXPos(ItemStack itemStack, Slope slope, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
        switch (slope.getFace(ForgeDirection.EAST)) {
            case WEDGE: {
                VertexHelper.startDrawing(4);
                this.setIDAndRender(itemStack, 23, x, y, z, 5);
                break;
            }
            case TRIANGLE: {
                VertexHelper.startDrawing(4);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
                this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 8, x, y, z, 5);
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
                this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
                this.setIDAndRender(itemStack, 9, x, y, z, 5);
                break;
            }
            default: {
                VertexHelper.startDrawing(7);
                this.setIDAndRender(itemStack, 5, x, y, z, 5);
            }
        }
    }
}

