/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.objects.XSTR;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum Bonsais {
    OAK("Oak", 1, new String[]{"Tree", "Bonsai", "Leafy", "Food"}, "Notch", new ItemStack(Blocks.field_150345_g), new ItemStack[]{new ItemStack(Blocks.field_150364_r, 10), new ItemStack(Blocks.field_150345_g), new ItemStack(Items.field_151034_e)}, new int[]{100, 50, 10}, null, null, "Can drop apples"),
    SPRUCE("Spruce", 1, new String[]{"Tree", "Bonsai", "Leafy"}, "Notch", new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack[]{new ItemStack(Blocks.field_150364_r, 10, 1), new ItemStack(Blocks.field_150345_g, 1, 1)}, new int[]{80, 30}, null, null, new String[0]),
    BIRCH("Birch", 1, new String[]{"Tree", "Bonsai", "Leafy"}, "Notch", new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack[]{new ItemStack(Blocks.field_150364_r, 10, 2), new ItemStack(Blocks.field_150345_g, 1, 2)}, new int[]{80, 30}, null, null, new String[0]),
    JUNGLE("Jungle", 1, new String[]{"Tree", "Bonsai", "Leafy"}, "Notch", new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack[]{new ItemStack(Blocks.field_150364_r, 10, 3), new ItemStack(Blocks.field_150345_g, 1, 3)}, new int[]{80, 30}, null, null, new String[0]),
    ACACIA("Acacia", 1, new String[]{"Tree", "Bonsai", "Leafy"}, "Notch", new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack[]{new ItemStack(Blocks.field_150363_s, 10), new ItemStack(Blocks.field_150345_g, 1, 4)}, new int[]{80, 30}, null, null, new String[0]),
    DARKOAK("Dark Oak", 1, new String[]{"Tree", "Bonsai", "Leafy", "Dark"}, "Notch", new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack[]{new ItemStack(Blocks.field_150363_s, 10, 1), new ItemStack(Blocks.field_150345_g, 1, 5)}, new int[]{80, 30}, null, null, new String[0]);

    private static final int LOGSPERHARVEST = 10;
    final InternalVanillaBonsais bonsais;
    final ItemStack seed;
    final boolean load;

    public InternalVanillaBonsais getBonsais() {
        return this.bonsais;
    }

    public ItemStack getSeed() {
        return this.seed;
    }

    private Bonsais(String name, int tier, String[] attributes, String discoveredBy, ItemStack seed, ItemStack[] gain, int[] chances, String[] pathToSprites, String modID, String ... additionalDescription) {
        this.bonsais = new InternalVanillaBonsais(name, tier, attributes, discoveredBy, gain, chances, pathToSprites, additionalDescription);
        this.seed = seed;
        this.load = modID == null || Loader.isModLoaded((String)modID);
    }

    public static void registerAllBonsais() {
        for (Bonsais bonsai : Bonsais.values()) {
            if (!bonsai.load) continue;
            Crops.instance.registerCrop((CropCard)bonsai.getBonsais());
            if (bonsai.getSeed() == null) continue;
            Crops.instance.registerBaseSeed(bonsai.getSeed(), (CropCard)bonsai.getBonsais(), 1, 1, 1, 1);
        }
    }

    static class InternalVanillaBonsais
    extends BasicCrop {
        String name;
        int tier;
        String[] attributes;
        String discoveredBy;
        ItemStack[] gain;
        String[] additionalDescription;
        int[] chances;
        String[] pathToSprites;
        final int maxChance;

        public InternalVanillaBonsais(String name, int tier, String[] attributes, String discoveredBy, ItemStack[] gain, int[] chances, String[] pathToSprites, String[] additionalDescription) {
            this.name = name;
            this.tier = tier;
            this.attributes = attributes;
            this.discoveredBy = discoveredBy;
            this.gain = gain;
            this.additionalDescription = additionalDescription;
            this.chances = chances;
            this.pathToSprites = pathToSprites;
            this.maxChance = InternalVanillaBonsais.maxChance(chances);
        }

        private static int maxChance(int[] chances) {
            int max = 0;
            for (int chance : chances) {
                max = Math.max(max, chance);
            }
            return max;
        }

        public int tier() {
            return this.tier;
        }

        public String name() {
            return this.name + " Bonsai";
        }

        public int stat(int i) {
            return i == 3 ? 1 : 0;
        }

        public String[] attributes() {
            return this.attributes;
        }

        @Override
        public String discoveredBy() {
            return this.discoveredBy;
        }

        public int maxSize() {
            return 3;
        }

        public int growthDuration(ICropTile crop) {
            return ConfigValues.debug ? 1 : super.growthDuration(crop) * 3;
        }

        public ItemStack getGain(ICropTile crop) {
            XSTR rand = new XSTR();
            int roll = rand.nextInt(this.maxChance);
            for (int i = this.chances.length - 1; i >= 0; --i) {
                if (this.chances[i] < roll) continue;
                ItemStack ret = this.gain[i].func_77946_l();
                ret.field_77994_a += rand.nextInt(7) - 3;
                return ret.field_77994_a <= 0 ? null : ret;
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerSprites(IIconRegister iconRegister) {
            this.textures = new IIcon[this.maxSize()];
            if (this.pathToSprites == null || this.textures.length != this.pathToSprites.length) {
                for (int i = 1; i <= this.textures.length; ++i) {
                    this.textures[i - 1] = iconRegister.func_94245_a("bpp:crop/blockCrop." + this.name + "." + i);
                }
            } else {
                for (int i = 0; i < this.pathToSprites.length; ++i) {
                    this.textures[i] = iconRegister.func_94245_a(this.pathToSprites[i]);
                }
            }
        }

        @Override
        public List<String> getCropInformation() {
            return this.additionalDescription != null ? Arrays.asList(this.additionalDescription) : null;
        }

        @Override
        public ItemStack getDisplayItem() {
            return new ItemStack(Blocks.field_150345_g);
        }
    }
}

