/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.ManagerBase;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.ValidatorIcon;
import forestry.api.core.INBTTagable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ManagerMachine
extends ManagerBase {
    private Map<Class<?>, Class<?>[]> componentInterfaceMap = new HashMap();
    private Map<String, MachineGroup> machineGroups = new HashMap<String, MachineGroup>();
    private Map<Integer, Class<?>> networkIDToComponent = new HashMap();
    private Map<Class<?>, Integer> componentToNetworkID = new HashMap();
    private int nextNetworkID = 0;
    private int machineRenderID;

    public void registerMachineGroup(MachineGroup group) {
        this.machineGroups.put(group.getUID(), group);
    }

    public MachineGroup getGroup(String name) {
        return this.machineGroups.get(name);
    }

    public MachinePackage getPackage(String group, String name) {
        MachineGroup machineGroup = this.getGroup(group);
        return machineGroup == null ? null : machineGroup.getPackage(name);
    }

    private void registerComponentClass(Class<? extends MachineComponent> component) {
        if (this.componentInterfaceMap.containsKey(component)) {
            return;
        }
        HashSet interfaces = new HashSet();
        for (Class<? extends MachineComponent> currentClass = component; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Collections.addAll(interfaces, currentClass.getInterfaces());
        }
        interfaces.remove(INBTTagable.class);
        this.componentInterfaceMap.put(component, interfaces.toArray(new Class[0]));
        int networkID = this.nextNetworkID++;
        this.networkIDToComponent.put(networkID, component);
        this.componentToNetworkID.put(component, networkID);
    }

    public int getNetworkID(Class<?> component) {
        return this.componentToNetworkID.get(component);
    }

    public Class<?> getComponentClass(int networkID) {
        return this.networkIDToComponent.get(networkID);
    }

    public int getMachineRenderID() {
        return this.machineRenderID;
    }

    @Override
    public void init() {
        this.machineRenderID = BinnieCore.proxy.getUniqueRenderID();
        SlotValidator.IconBee = new ValidatorIcon(BinnieCore.instance, "validator/bee.0", "validator/bee.1");
        SlotValidator.IconFrame = new ValidatorIcon(BinnieCore.instance, "validator/frame.0", "validator/frame.1");
        SlotValidator.IconCircuit = new ValidatorIcon(BinnieCore.instance, "validator/circuit.0", "validator/circuit.1");
        SlotValidator.IconBlock = new ValidatorIcon(BinnieCore.instance, "validator/block.0", "validator/block.1");
    }

    @Override
    public void postInit() {
        BinnieCore.proxy.registerBlockRenderer(BinnieCore.proxy.createObject("binnie.core.machines.RendererMachine"));
        BinnieCore.proxy.registerTileEntity(TileEntityMachine.class, "binnie.tile.machine", BinnieCore.proxy.createObject("binnie.core.machines.RendererMachine"));
    }

    public Class<?>[] getComponentInterfaces(Class<? extends MachineComponent> clss) {
        if (!this.componentInterfaceMap.containsKey(clss)) {
            this.registerComponentClass(clss);
        }
        return this.componentInterfaceMap.get(clss);
    }
}

