/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSequence;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class AnalyserRecipeHandler
extends RecipeHandlerBase {
    private static final List<AnalyserRecipe> recipes = new ArrayList<AnalyserRecipe>();

    @Override
    public void prepare() {
        recipes.add(new AnalyserRecipe(new ItemStack(Genetics.itemSequencer, 1, Short.MAX_VALUE)));
        if (BinnieCore.isApicultureActive()) {
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("beeDroneGE", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("beePrincessGE", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("beeQueenGE", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isArboricultureActive()) {
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("sapling", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("pollenFertile", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isLepidopteryActive()) {
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("butterflyGE", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("caterpillarGE", 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isBotanyActive()) {
            recipes.add(new AnalyserRecipe(new ItemStack((Item)Botany.flowerItem, 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(new ItemStack(Botany.seed, 1, Short.MAX_VALUE)));
            recipes.add(new AnalyserRecipe(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE)));
        }
    }

    public String getOverlayIdentifier() {
        return "genetics.analyser";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/analyser.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.labMachine.analyser");
    }

    public void loadTransferRects() {
        this.addTransferRect(50, 13, 66, 11);
        this.addTransferRect(50, 42, 66, 11);
        this.addTransferRect(50, 24, 24, 18);
        this.addTransferRect(92, 24, 24, 18);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(50, 13, 176, 0, 66, 40, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (AnalyserRecipe recipe : recipes) {
            this.arecipes.add(new CachedAnalyser(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.DNADye.get(0), (ItemStack)ingredient)) {
            this.loadAllRecipes();
        } else {
            for (AnalyserRecipe recipe : recipes) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getAnalysable(), (ItemStack)ingredient)) continue;
                this.arecipes.add(new CachedAnalyser(recipe));
            }
        }
    }

    public class CachedAnalyser
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack analysable;
        public PositionedStack dnaDye;
        public List<PositionedStack> ingredients;

        public CachedAnalyser(AnalyserRecipe recipe) {
            super(AnalyserRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            if (recipe.getAnalysable() != null) {
                ArrayList<ItemStack> analysableList = new ArrayList<ItemStack>();
                if (recipe.getAnalysable().func_77973_b() instanceof ItemSequence) {
                    for (ItemStack seq : ItemList.itemMap.get((Object)Genetics.itemSequencer)) {
                        for (int i = Genetics.itemSequencer.func_77612_l(); i >= 0; --i) {
                            ItemStack temp = seq.func_77946_l();
                            temp.func_77964_b(i);
                            analysableList.add(temp);
                        }
                    }
                } else {
                    for (ItemStack analysable : ItemList.itemMap.get((Object)recipe.getAnalysable().func_77973_b())) {
                        if (analysable.func_77978_p() == null) continue;
                        analysableList.add(analysable.func_77946_l());
                    }
                }
                this.analysable = new PositionedStack(analysableList, 75, 25);
                this.dnaDye = new PositionedStack((Object)recipe.getDNADye(), 75, 56);
                this.ingredients.add(this.analysable);
                this.ingredients.add(this.dnaDye);
            }
        }

        public List<PositionedStack> getIngredients() {
            this.analysable.setPermutationToRender(AnalyserRecipeHandler.this.cycleticks / 40 % this.analysable.items.length);
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return null;
        }
    }

    private static class AnalyserRecipe {
        private final ItemStack analysable;

        public AnalyserRecipe(ItemStack analysable) {
            this.analysable = analysable;
        }

        public ItemStack getDNADye() {
            return GeneticsItems.DNADye.get(1);
        }

        public ItemStack getAnalysable() {
            return this.analysable;
        }
    }
}

