/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.ICallable;
import openmods.utils.Stack;

public abstract class NullaryFunction<E>
extends FixedCallable<E> {
    private NullaryFunction() {
        super(0, 1);
    }

    public static <E> ICallable<E> createConst(final E value) {
        return new Direct<E>(){

            @Override
            protected E call() {
                return value;
            }
        };
    }

    public static abstract class WithFrame<E>
    extends NullaryFunction<E> {
        protected abstract E callImpl(Frame<E> var1);

        @Override
        public final void call(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 1);
            Stack<E> stack = executionFrame.stack();
            E result = this.callImpl(executionFrame);
            stack.checkIsEmpty().push(result);
        }
    }

    public static abstract class Direct<E>
    extends NullaryFunction<E> {
        protected abstract E call();

        @Override
        public final void call(Frame<E> frame) {
            frame.stack().push(this.call());
        }
    }
}

