/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import team.chisel.client.gui.GuiChisel;
import team.chisel.inventory.ContainerChisel;
import team.chisel.network.PacketHandler;
import team.chisel.network.message.MessageScrollUpdate;

public class GuiScrollbar {
    public static final ResourceLocation TEXTURE_RESOURCE_LOCATION = new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png");
    private int displayX = 0;
    private int displayY = 0;
    private int width = 12;
    private int height = 15;
    private int rowSize = 10;
    private int rowsOnPage = 6;
    private int scrollHeight = this.height;
    private ContainerChisel container;

    public void draw(GuiChisel g) {
        g.field_146297_k.func_110434_K().func_110577_a(TEXTURE_RESOURCE_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getMaxScroll() == 0) {
            g.func_73729_b(this.displayX, this.displayY, 232 + this.width, 0, this.width, this.height);
        } else {
            int offset = this.getCurrentScroll() * (this.scrollHeight - this.height) / this.getMaxScroll();
            g.func_73729_b(this.displayX, offset + this.displayY, 232, 0, this.width, this.height);
        }
    }

    public GuiScrollbar setScrollHeight(int scrollHeight) {
        this.scrollHeight = scrollHeight;
        return this;
    }

    public GuiScrollbar setLeft(int displayX) {
        this.displayX = displayX;
        return this;
    }

    public GuiScrollbar setTop(int displayY) {
        this.displayY = displayY;
        return this;
    }

    private int getMaxScroll() {
        int maxScroll = (this.container.inventory.getMaxScroll() + this.rowSize - 1) / this.rowSize - this.rowsOnPage;
        if (maxScroll <= 0) {
            maxScroll = 0;
        }
        return maxScroll;
    }

    public int getCurrentScroll() {
        return this.container.inventory.getCurrentScroll() / this.rowSize;
    }

    private void setCurrentScroll(int scroll) {
        this.container.inventory.setCurrentScroll(scroll * this.rowSize);
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageScrollUpdate(scroll * this.rowSize));
    }

    private int applyRange(int scroll) {
        return Math.max(Math.min(scroll, this.getMaxScroll()), 0);
    }

    void click(int x, int y) {
        if (this.getMaxScroll() == 0) {
            return;
        }
        if (x > this.displayX && x <= this.displayX + this.width && y > this.displayY && y <= this.displayY + this.scrollHeight) {
            int currentScroll = y - this.displayY - this.height / 2;
            currentScroll = Math.round(1.0f * (float)currentScroll * (float)this.getMaxScroll() / (float)(this.scrollHeight - this.height));
            this.setCurrentScroll(this.applyRange(currentScroll));
        }
    }

    void wheel(int delta) {
        this.setCurrentScroll(this.applyRange(this.getCurrentScroll() + Math.max(Math.min(-delta, 1), -1)));
    }

    public void setContainerChisel(ContainerChisel container) {
        this.container = container;
    }
}

