/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileBellows;
import tuhljin.automagy.api.essentia.IEssentiaDistillery;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.network.MessageBoilerVenting;
import tuhljin.automagy.tiles.ITileWithTank;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityBoiler
extends ModTileEntityWithInventory
implements ITileWithTank,
IEssentiaDistillery {
    public static final int CAPACITY_IN_BUCKETS = 16;
    public static int MAX_VIS = 50;
    public int vis;
    public int furnaceBurnTime;
    public int venting;
    public int smeltTime = 100;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    public AspectList aspects = new AspectList();
    protected int bellows = -1;
    protected boolean speedBoost = false;
    public FluidTank tank = new FluidTank(16000);
    private int tickCount;

    public TileEntityBoiler() {
        super("blockBoiler", 1);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        boolean hasBurnTime = this.furnaceBurnTime > 0;
        boolean needMarKDirty = false;
        ++this.tickCount;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.bellows < 0) {
                this.getBellows();
            }
            if (this.tickCount % (this.speedBoost ? 20 : 40) == 0 && this.aspects.size() > 0) {
                TileAlembic alembic;
                AspectList exclude = new AspectList();
                int alembicOffset = 0;
                TileEntity tile = null;
                while (alembicOffset < 5 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + ++alembicOffset, this.field_145849_e)) instanceof TileAlembic) {
                    alembic = (TileAlembic)tile;
                    if (alembic.aspect != null && alembic.amount < alembic.maxAmount && this.aspects.getAmount(alembic.aspect) > 0) {
                        this.removeVis(alembic.aspect, 1);
                        alembic.addToContainer(alembic.aspect, 1);
                        exclude.merge(alembic.aspect, 1);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + alembicOffset, this.field_145849_e);
                    }
                    tile = null;
                }
                alembicOffset = 0;
                while (alembicOffset < 5 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + ++alembicOffset, this.field_145849_e)) instanceof TileAlembic) {
                    alembic = (TileAlembic)tile;
                    if (alembic.aspect != null && alembic.amount != 0) continue;
                    Aspect as = null;
                    if (alembic.aspectFilter == null) {
                        as = this.removeRandomVis(exclude);
                    } else if (this.removeVis(alembic.aspectFilter, 1)) {
                        as = alembic.aspectFilter;
                    }
                    if (as == null) continue;
                    alembic.addToContainer(as, 1);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + alembicOffset, this.field_145849_e);
                    break;
                }
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventorySlots[0]);
                if (this.furnaceBurnTime > 0) {
                    needMarKDirty = true;
                    this.speedBoost = false;
                    if (this.inventorySlots[0] != null) {
                        if (this.inventorySlots[0].func_77969_a(new ItemStack(ConfigItems.itemResource, 1, 0))) {
                            this.speedBoost = true;
                        }
                        --this.inventorySlots[0].field_77994_a;
                        if (this.inventorySlots[0].field_77994_a == 0) {
                            this.inventorySlots[0] = this.inventorySlots[0].func_77973_b().getContainerItem(this.inventorySlots[0]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime >= this.smeltTime) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    needMarKDirty = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (hasBurnTime != this.furnaceBurnTime > 0) {
                needMarKDirty = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (needMarKDirty) {
                this.func_70296_d();
            }
        } else if (this.venting > 0) {
            --this.venting;
            this.vent();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public boolean hasVis() {
        return this.vis > 0;
    }

    public void startVenting() {
        this.venting = 10;
        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 0.1f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
    }

    public void vent() {
        float fx = 0.35f;
        float fz = 0.1f;
        float fy = 0.05f;
        float fx2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
        float fz2 = 0.1f - this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
        float fy2 = 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 5.0f;
        int color = 0xFFFFFF;
        Thaumcraft.proxy.drawVentParticles(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f + fx), (double)((float)this.field_145848_d + 0.8f + fy), (double)((float)this.field_145849_e + fz), (double)(2.0f + fx2), (double)fy2, (double)(-2.0f + fz2), color);
        Thaumcraft.proxy.drawVentParticles(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f - fx), (double)((float)this.field_145848_d + 0.8f + fy), (double)((float)this.field_145849_e + fz), (double)(-2.0f + fx2), (double)fy2, (double)(-2.0f + fz2), color);
        float compensate = 2.0f;
        Thaumcraft.proxy.drawVentParticles(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f + fx), (double)((float)this.field_145848_d + 0.8f + fy), (double)((float)this.field_145849_e - fz + 1.0f), (double)(2.0f + fx2 + compensate), (double)fy2, (double)(2.0f + fz2 + compensate), color);
        Thaumcraft.proxy.drawVentParticles(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f - fx), (double)((float)this.field_145848_d + 0.8f + fy), (double)((float)this.field_145849_e - fz + 1.0f), (double)(-2.0f + fx2), (double)fy2, (double)(2.0f + fz2), color);
    }

    public ItemStack getStackToBoil() {
        Block block;
        FluidStack fluid;
        if (this.tank.getFluidAmount() > 0 && (fluid = this.tank.getFluid()) != null && (block = fluid.getFluid().getBlock()) != null) {
            return new ItemStack(block);
        }
        return null;
    }

    public boolean hasContentsCannotBoil() {
        if (this.tank.getFluidAmount() < 1) {
            return false;
        }
        ItemStack stack = this.getStackToBoil();
        if (stack == null) {
            return true;
        }
        AspectList tags = ThaumcraftExtension.getObjectTotalAspects(stack);
        return tags == null || tags.size() == 0;
    }

    protected void getBellows() {
        this.bellows = TileBellows.getBellows((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection[])ForgeDirection.VALID_DIRECTIONS);
    }

    private boolean canSmelt() {
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        ItemStack stack = this.getStackToBoil();
        if (stack == null) {
            return false;
        }
        AspectList al = ThaumcraftExtension.getObjectTotalAspects(stack);
        if (al == null || al.size() == 0) {
            return false;
        }
        int vs = al.visSize();
        if (vs > MAX_VIS - this.vis) {
            return false;
        }
        this.smeltTime = (int)((float)(vs * 10) * (1.0f - 0.125f * (float)this.bellows));
        return true;
    }

    public void smeltItem() {
        if (this.canSmelt() && this.drainExactAmount(1000, false)) {
            ItemStack stack = this.getStackToBoil();
            AspectList al = ThaumcraftExtension.getObjectTotalAspects(stack);
            for (Aspect a : al.getAspects()) {
                this.aspects.add(a, al.getAmount(a));
            }
            this.vis = this.aspects.visSize();
            this.drain(ForgeDirection.UNKNOWN, 1000, true);
            MessageBoilerVenting.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean removeVis(Aspect tag, int amount) {
        if (this.aspects != null && this.aspects.getAmount(tag) >= amount) {
            this.aspects.remove(tag, amount);
            this.vis -= amount;
            return true;
        }
        return false;
    }

    public Aspect removeRandomVis(AspectList exclude) {
        if (this.aspects.size() > 0) {
            AspectList temp = this.aspects.copy();
            if (exclude.size() > 0) {
                for (Aspect a : exclude.getAspects()) {
                    temp.remove(a);
                }
            }
            if (temp.size() > 0) {
                Aspect tag = temp.getAspects()[this.field_145850_b.field_73012_v.nextInt(temp.getAspects().length)];
                this.aspects.remove(tag, 1);
                --this.vis;
                return tag;
            }
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.speedBoost = nbttagcompound.func_74767_n("speedBoost");
        this.furnaceCookTime = nbttagcompound.func_74765_d("furnaceCookTime");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventorySlots[0]);
        this.aspects.readFromNBT(nbttagcompound);
        this.vis = this.aspects.visSize();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("speedBoost", this.speedBoost);
        nbttagcompound.func_74777_a("furnaceCookTime", (short)this.furnaceCookTime);
        this.aspects.writeToNBT(nbttagcompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.vis = nbttagcompound.func_74765_d("vis");
        this.furnaceBurnTime = nbttagcompound.func_74765_d("furnaceBurnTime");
        if (nbttagcompound.func_74764_b("Empty")) {
            this.tank.setFluid(null);
        } else {
            this.tank.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74777_a("vis", (short)this.vis);
        nbttagcompound.func_74777_a("furnaceBurnTime", (short)this.furnaceBurnTime);
        this.tank.writeToNBT(nbttagcompound);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int i = this.tank.fill(resource, doFill);
        if (doFill && i != 0) {
            this.func_70296_d();
        }
        return i;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack fluid = this.tank.drain(resource.amount, doDrain);
        if (doDrain && fluid != null) {
            this.func_70296_d();
        }
        return fluid;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fluid = this.tank.drain(maxDrain, doDrain);
        if (doDrain && fluid != null) {
            this.func_70296_d();
        }
        return fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public boolean drainExactAmount(int amount, boolean doDrain) {
        FluidStack drained = this.drain(ForgeDirection.UNKNOWN, amount, false);
        if (drained.amount == amount) {
            if (doDrain) {
                this.drain(ForgeDirection.UNKNOWN, amount, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fillExactAmount(FluidStack resource) {
        int amount = this.fill(ForgeDirection.UNKNOWN, resource, false);
        if (amount == resource.amount) {
            this.fill(ForgeDirection.UNKNOWN, resource, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean fillExactAmount(BlockFluidBase fluidBlock) {
        return this.fillExactAmount(new FluidStack(fluidBlock.getFluid(), 1000));
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * i / this.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        if (this.smeltTime <= 0) {
            this.smeltTime = 1;
        }
        return this.furnaceCookTime * i / this.smeltTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getContentsScaled(int i) {
        return this.vis * i / MAX_VIS;
    }

    @Override
    public int getFurnaceBurnTime() {
        return this.furnaceBurnTime;
    }

    @Override
    public void setFurnaceBurnTime(int i) {
        this.furnaceBurnTime = i;
        this.markDirty(false);
    }

    @Override
    public boolean isSpeedBoosted() {
        return this.speedBoost;
    }

    @Override
    public void setSpeedBoosted(boolean b) {
        this.speedBoost = b;
        this.markDirty(false);
    }

    @Override
    public int getStoredVis() {
        return this.vis;
    }

    @Override
    public int getStoredVisMax() {
        return MAX_VIS;
    }
}

