/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import codechicken.lib.gui.GuiDraw;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Text;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.draw.BoundedDrawable;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class Text
implements BoundedDrawable {
    private static final Splitter SPLITTER = Splitter.on((char)'\n');

    public abstract String text();

    @Override
    public abstract Point position();

    public abstract int colour();

    public abstract boolean small();

    public abstract boolean shadow();

    @Override
    public abstract Dimension dimension();

    @Override
    public void draw(DiagramState diagramState) {
        Point topLeft = this.position().translate(-this.dimension().width() / 2, -this.dimension().height() / 2);
        Draw.drawText(this.text(), topLeft, this.colour(), this.small(), this.shadow());
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Builder builder(String text, Point pos, Grid.Direction dir) {
        return new Builder(text, pos, dir);
    }

    public static MultiLineBuilder multiLineBuilder(Point pos, Grid.Direction dir) {
        Preconditions.checkArgument((dir.yFactor != 0 ? 1 : 0) != 0, (String)"Direction must have a vertical component: %s", (Object[])new Object[]{dir});
        return new MultiLineBuilder(pos, dir);
    }

    public static final class MultiLineBuilder {
        public static final int LINE_HEIGHT = 10;
        private final Point position;
        private final Grid.Direction direction;
        private int lineHeight;
        private int colour;
        private boolean small;
        private boolean shadow;
        private List<String> textLines;

        private MultiLineBuilder(Point position, Grid.Direction direction) {
            this.position = position;
            this.direction = direction;
            this.colour = -16777216;
            this.small = false;
            this.shadow = false;
            this.lineHeight = 10;
            this.textLines = new ArrayList<String>();
        }

        public MultiLineBuilder setColour(int colour) {
            this.colour = colour;
            return this;
        }

        public MultiLineBuilder setSmall(boolean small) {
            this.small = small;
            return this;
        }

        public MultiLineBuilder setShadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public MultiLineBuilder setLineHeight(int lineHeight) {
            this.lineHeight = lineHeight;
            return this;
        }

        public MultiLineBuilder adjustLineHeight(int delta) {
            this.lineHeight += delta;
            return this;
        }

        public MultiLineBuilder addLine(String line) {
            return this.addAllLines(SPLITTER.split((CharSequence)line));
        }

        public MultiLineBuilder addAllLines(Iterable<String> lines) {
            lines.forEach(this.textLines::add);
            return this;
        }

        public List<Text> build() {
            ArrayList<Text> list = new ArrayList<Text>(this.textLines.size());
            if (this.small) {
                this.lineHeight /= 2;
            }
            int y = this.position.y();
            switch (this.direction.yFactor) {
                case -1: {
                    y -= this.textLines.size() * this.lineHeight;
                    break;
                }
                case 0: {
                    y -= this.textLines.size() * this.lineHeight / 2;
                    break;
                }
            }
            for (String line : this.textLines) {
                list.add(Text.builder(line, Point.create(this.position.x(), y), this.direction).setColour(this.colour).setSmall(this.small).setShadow(this.shadow).build());
                y += this.lineHeight;
            }
            return list;
        }
    }

    public static final class Builder {
        private final String text;
        private final Point position;
        private final Grid.Direction direction;
        private int colour;
        private boolean small;
        private boolean shadow;

        private Builder(String text, Point pos, Grid.Direction dir) {
            this.text = text;
            this.position = pos;
            this.direction = dir;
            this.colour = -16777216;
            this.small = false;
            this.shadow = false;
        }

        public Builder setColour(int colour) {
            this.colour = colour;
            return this;
        }

        public Builder setSmall(boolean small) {
            this.small = small;
            return this;
        }

        public Builder setShadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public Text build() {
            int width = GuiDraw.getStringWidth((String)this.text);
            int height = 8;
            if (this.small) {
                width /= 2;
                height /= 2;
            }
            Dimension dimension = Dimension.create(width, height);
            Point center = this.position.translate(this.direction.xFactor * width / 2, this.direction.yFactor * height / 2);
            return new AutoValue_Text(this.text, center, this.colour, this.small, this.shadow, dimension);
        }
    }
}

