/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.AutoValue_RecipeHandler_ChemicalBathFluidRecipe;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechRecipeUtil;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import gregtech.api.enums.Materials;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;

class RecipeHandler {
    private final EnumMap<RecipeMap, SetMultimap<ItemComponent, ImmutableList<DisplayComponent>>> recipeData = new EnumMap(RecipeMap.class);
    private final EnumMap<ChemicalBathFluid, SetMultimap<ItemComponent, ChemicalBathFluidRecipe>> chemicalBathFluidData = new EnumMap(ChemicalBathFluid.class);
    private final Map<ItemComponent, ItemComponent> furnaceData = new HashMap<ItemComponent, ItemComponent>();

    RecipeHandler() {
    }

    void initialize() {
        Arrays.stream(ChemicalBathFluid.values()).forEach(chemicalBathFluid -> this.chemicalBathFluidData.put((ChemicalBathFluid)((Object)chemicalBathFluid), (SetMultimap<ItemComponent, ChemicalBathFluidRecipe>)MultimapBuilder.hashKeys().hashSetValues().build()));
        for (RecipeMap recipeMap : RecipeMap.values()) {
            SetMultimap multimap = MultimapBuilder.hashKeys().hashSetValues().build();
            this.recipeData.put(recipeMap, (SetMultimap<ItemComponent, ImmutableList<DisplayComponent>>)multimap);
            for (GT_Recipe recipe : recipeMap.recipeMap.getAllRecipes()) {
                ImmutableList outputs = ImmutableList.copyOf(GregTechRecipeUtil.buildComponentsFromOutputs(recipe));
                Optional<Object> chemicalBathFluidOptional = Optional.empty();
                int inputFluidAmount = 0;
                if (recipeMap == RecipeMap.CHEMICAL_BATH) {
                    List<DisplayComponent> fluidInputs = GregTechRecipeUtil.buildComponents(recipe.mFluidInputs);
                    if (fluidInputs.size() != 1) {
                        Logger.GREGTECH_5_ORE_PROCESSING.warn("Found chemical bath recipe with {} fluids:\n[{}]\n ->\n[{}]", new Object[]{fluidInputs.size(), GregTechRecipeUtil.buildComponentsFromInputs(recipe), GregTechRecipeUtil.buildComponentsFromOutputs(recipe)});
                    } else {
                        DisplayComponent inputFluid = (DisplayComponent)Iterables.getOnlyElement(fluidInputs);
                        if (inputFluid.stackSize().isPresent()) {
                            chemicalBathFluidOptional = Optional.ofNullable(ChemicalBathFluid.VALUES_MAP.get((Object)inputFluid.component()));
                            inputFluidAmount = inputFluid.stackSize().get();
                        } else {
                            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found chemical bath recipe missing input fluid stack size:\n[{}]\n ->\n[{}]", new Object[]{GregTechRecipeUtil.buildComponentsFromInputs(recipe), GregTechRecipeUtil.buildComponentsFromOutputs(recipe)});
                        }
                    }
                }
                for (ItemStack itemStack : recipe.mInputs) {
                    if (itemStack == null) continue;
                    ItemComponent itemComponent = ItemComponent.create(GT_OreDictUnificator.get_nocopy((ItemStack)itemStack));
                    multimap.put((Object)itemComponent, (Object)outputs);
                    int finalInputFluidAmount = inputFluidAmount;
                    chemicalBathFluidOptional.ifPresent(chemicalBathFluid -> this.chemicalBathFluidData.get(chemicalBathFluid).put((Object)itemComponent, (Object)ChemicalBathFluidRecipe.create(finalInputFluidAmount, (ImmutableList<DisplayComponent>)outputs)));
                }
            }
        }
        FurnaceRecipes.func_77602_a().func_77599_b().forEach((key, value) -> this.furnaceData.put(ItemComponent.create(key), ItemComponent.create(value)));
    }

    Set<ImmutableList<DisplayComponent>> getRecipeOutputs(RecipeMap recipeMap, ItemComponent input) {
        return Multimaps.unmodifiableSetMultimap(this.recipeData.get((Object)recipeMap)).get((Object)((ItemComponent)GregTechOreDictUtil.unify(input)));
    }

    Optional<ImmutableList<DisplayComponent>> getUniqueRecipeOutput(RecipeMap recipeMap, ItemComponent input) {
        Set outputs = this.recipeData.get((Object)recipeMap).get((Object)((ItemComponent)GregTechOreDictUtil.unify(input)));
        if (outputs.size() > 1) {
            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found {} recipes: [{}] [{}]", new Object[]{outputs.size(), recipeMap, input});
            return Optional.empty();
        }
        if (outputs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Iterables.getOnlyElement((Iterable)outputs));
    }

    Optional<ChemicalBathFluidRecipe> getUniqueChemicalBathOutput(ChemicalBathFluid chemicalBathFluid, ItemComponent input) {
        Set outputs = this.chemicalBathFluidData.get((Object)chemicalBathFluid).get((Object)input);
        if (outputs.size() > 1) {
            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found {} chemical bath recipes: [{}] [{}]", new Object[]{outputs.size(), chemicalBathFluid, input});
            return Optional.empty();
        }
        if (outputs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Iterables.getOnlyElement((Iterable)outputs));
    }

    Optional<ItemComponent> getFurnaceRecipeOutput(ItemComponent input) {
        return Optional.ofNullable(this.furnaceData.get(input));
    }

    @AutoValue
    public static abstract class ChemicalBathFluidRecipe {
        public static ChemicalBathFluidRecipe create(int inputFluidAmount, ImmutableList<DisplayComponent> outputs) {
            return new AutoValue_RecipeHandler_ChemicalBathFluidRecipe(inputFluidAmount, outputs);
        }

        public abstract int inputFluidAmount();

        public abstract ImmutableList<DisplayComponent> outputs();
    }

    static enum ChemicalBathFluid {
        MERCURY(ItemComponent.create(GT_Utility.getFluidDisplayStack((Fluid)Materials.Mercury.mFluid))),
        SODIUM_PERSULFATE(ItemComponent.create(GT_Utility.getFluidDisplayStack((Fluid)Materials.SodiumPersulfate.mFluid)));

        final ItemComponent fluid;
        static final ImmutableMap<ItemComponent, ChemicalBathFluid> VALUES_MAP;

        private ChemicalBathFluid(ItemComponent fluid) {
            this.fluid = fluid;
        }

        static {
            VALUES_MAP = ImmutableMap.copyOf(Arrays.stream(ChemicalBathFluid.values()).collect(Collectors.toMap(c -> c.fluid, Function.identity())));
        }
    }

    static enum RecipeMap {
        MACERATOR(RecipeMaps.maceratorRecipes),
        ORE_WASHING_PLANT(RecipeMaps.oreWasherRecipes),
        THERMAL_CENTRIFUGE(RecipeMaps.thermalCentrifugeRecipes),
        SIFTER(RecipeMaps.sifterRecipes),
        CENTRIFUGE(RecipeMaps.centrifugeRecipes),
        BLAST_FURNACE(RecipeMaps.blastFurnaceRecipes),
        CHEMICAL_BATH(RecipeMaps.chemicalBathRecipes),
        CHEMICAL_REACTOR(RecipeMaps.chemicalReactorRecipes),
        ELECTROMAGNETIC_SEPARATOR(RecipeMaps.electroMagneticSeparatorRecipes),
        AUTOCLAVE(RecipeMaps.autoclaveRecipes);

        final gregtech.api.recipe.RecipeMap<?> recipeMap;

        private RecipeMap(gregtech.api.recipe.RecipeMap<?> recipeMap) {
            this.recipeMap = recipeMap;
        }
    }
}

