/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.parts.automation.UpgradeInventory;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelStatic;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.AEFluidInventory;
import com.glodblock.github.inventory.IAEFluidTank;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.DualityFluidInterface;
import com.glodblock.github.util.Util;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class PartFluidP2PInterface
extends PartP2PTunnelStatic<PartFluidP2PInterface>
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IDualHost,
ISidedInventory,
IAEAppEngInventory,
ITileStorageMonitorable,
IPriorityHost,
IInterfaceHost {
    private final DualityInterface duality = new DualityInterface(this.getProxy(), this){

        public void updateCraftingList() {
            if (!PartFluidP2PInterface.this.isOutput()) {
                super.updateCraftingList();
                try {
                    for (PartFluidP2PInterface p2p : PartFluidP2PInterface.this.getOutputs()) {
                        p2p.duality.updateCraftingList();
                    }
                }
                catch (GridAccessException gridAccessException) {}
            } else {
                PartFluidP2PInterface p2p = (PartFluidP2PInterface)PartFluidP2PInterface.this.getInput();
                if (p2p != null) {
                    this.craftingList = ((PartFluidP2PInterface)p2p).duality.craftingList;
                    try {
                        this.gridProxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.gridProxy.getNode()));
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        public int getInstalledUpgrades(Upgrades u) {
            if (PartFluidP2PInterface.this.isOutput() && u == Upgrades.PATTERN_CAPACITY) {
                return -1;
            }
            return super.getInstalledUpgrades(u);
        }
    };
    private final DualityFluidInterface dualityFluid = new DualityFluidInterface(this.getProxy(), this);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 6);

    public PartFluidP2PInterface(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.dualityFluid.onChannelStateChange(c);
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.dualityFluid.onPowerStateChange(c);
        this.duality.notifyNeighbors();
    }

    public void gridChanged() {
        super.gridChanged();
        this.dualityFluid.gridChanged();
    }

    public void onNeighborChanged() {
        this.duality.updateRedstoneState();
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        AppEngInternalInventory patterns = (AppEngInternalInventory)this.duality.getPatterns();
        if (super.onPartActivate(player, pos)) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int i = 0; i < patterns.func_70302_i_(); ++i) {
                if (patterns.func_70301_a(i) == null) continue;
                drops.add(patterns.func_70301_a(i));
            }
            IPart tile = this.getHost().getPart(this.getSide());
            if (tile instanceof PartFluidP2PInterface) {
                PartFluidP2PInterface dualTile = (PartFluidP2PInterface)tile;
                DualityInterface newDuality = dualTile.duality;
                UpgradeInventory upgrades = (UpgradeInventory)this.duality.getInventoryByName("upgrades");
                dualTile.duality.getStorage();
                UpgradeInventory newUpgrade = (UpgradeInventory)newDuality.getInventoryByName("upgrades");
                for (int i = 0; i < upgrades.func_70302_i_(); ++i) {
                    newUpgrade.func_70299_a(i, upgrades.func_70301_a(i));
                }
                IInventory storage = this.duality.getStorage();
                IInventory newStorage = newDuality.getStorage();
                for (int i = 0; i < storage.func_70302_i_(); ++i) {
                    newStorage.func_70299_a(i, storage.func_70301_a(i));
                }
                IConfigManager config = this.duality.getConfigManager();
                config.getSettings().forEach(setting -> newDuality.getConfigManager().putSetting(setting, config.getSetting(setting)));
            }
            TileEntity te = this.getTileEntity();
            Platform.spawnDrops((World)te.func_145831_w(), (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e, drops);
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer()) {
            InventoryHandler.openGui(player, this.getHost().getTile().func_145831_w(), new BlockPos(this.getHost().getTile()), Objects.requireNonNull(this.getSide()), GuiType.DUAL_INTERFACE);
        }
        return true;
    }

    public IIcon getTypeTexture() {
        return ItemAndBlockHolder.INTERFACE.func_149733_h(0);
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this.duality.getMonitorable(side, src, (IStorageMonitorable)this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        TickingRequest item = this.duality.getTickingRequest(node);
        TickingRequest fluid = this.dualityFluid.getTickingRequest(node);
        return new TickingRequest(Math.min(item.minTickRate, fluid.minTickRate), Math.max(item.maxTickRate, fluid.maxTickRate), item.isSleeping && fluid.isSleeping, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation item = this.duality.tickingRequest(node, ticksSinceLastCall);
        TickRateModulation fluid = this.dualityFluid.tickingRequest(node, ticksSinceLastCall);
        if (item.ordinal() >= fluid.ordinal()) {
            return item;
        }
        return fluid;
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.duality.getItemInventory();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.duality.getFluidInventory();
    }

    public int getPriority() {
        return this.duality.getPriority();
    }

    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public void onTunnelNetworkChange() {
        this.duality.updateCraftingList();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation op, ItemStack removedStack, ItemStack newStack) {
        this.duality.onChangeInventory(inv, slot, op, removedStack, newStack);
    }

    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsert(stack);
    }

    public int func_70302_i_() {
        return this.duality.getStorage().func_70302_i_();
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.duality.getStorage().func_70301_a(slotIn);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.duality.getStorage().func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.duality.getStorage().func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.duality.getStorage().func_70299_a(index, stack);
    }

    public IInventory getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    public IIcon getBreakingTexture() {
        return this.getItemStack().func_77954_c();
    }

    public String func_145825_b() {
        return this.duality.getStorage().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.duality.getStorage().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.duality.getStorage().func_70297_j_();
    }

    public void func_70296_d() {
        this.duality.markDirty();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.duality.getStorage().func_70300_a(player);
    }

    public void func_70295_k_() {
        this.duality.getStorage().func_70295_k_();
    }

    public void func_70305_f() {
        this.duality.getStorage().func_70305_f();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.duality.getStorage().func_94041_b(index, stack);
    }

    public int[] func_94128_d(int side) {
        return this.duality.getAccessibleSlotsFromSide(side);
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack itemStack, int p_102007_3_) {
        return true;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.dualityFluid.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.dualityFluid.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.dualityFluid.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.dualityFluid.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.dualityFluid.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.dualityFluid.getTankInfo(from);
    }

    @Override
    public void onFluidInventoryChanged(IAEFluidTank inv, int slot) {
        this.saveChanges();
        this.getTileEntity().func_70296_d();
        this.dualityFluid.onFluidInventoryChanged(inv, slot);
    }

    @Override
    public AEFluidInventory getInternalFluid() {
        return this.dualityFluid.getInternalFluid();
    }

    @Override
    public DualityFluidInterface getDualityFluid() {
        return this.dualityFluid;
    }

    @Override
    public AppEngInternalAEInventory getConfig() {
        Util.mirrorFluidToPacket((IInventory)this.config, this.dualityFluid.getConfig());
        return this.config;
    }

    @Override
    public void setConfig(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.config.func_70299_a(id, ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack()));
            this.dualityFluid.getConfig().setFluidInSlot(id, this.dualityFluid.getStandardFluid(fluid));
        }
    }

    @Override
    public void setFluidInv(int id, IAEFluidStack fluid) {
        if (id >= 0 && id < 6) {
            this.dualityFluid.getInternalFluid().setFluidInSlot(id, fluid);
        }
    }

    public DualityInterface getInterfaceDuality() {
        return this.duality;
    }

    public EnumSet<ForgeDirection> getTargets() {
        return EnumSet.of(this.getSide());
    }

    public TileEntity getTileEntity() {
        return super.getHost().getTile();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    public boolean isBusy() {
        return this.duality.isBusy();
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.duality.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.duality.writeToNBT(data);
    }

    public NBTTagCompound getMemoryCardData() {
        NBTTagCompound output = super.getMemoryCardData();
        this.duality.getConfigManager().writeToNBT(output);
        return output;
    }

    public void pasteMemoryCardData(PartP2PTunnel newTunnel, NBTTagCompound data) throws GridAccessException {
        this.duality.getConfigManager().readFromNBT(data);
        super.pasteMemoryCardData(newTunnel, data);
    }

    public void addToWorld() {
        super.addToWorld();
        this.duality.initialize();
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        this.duality.addDrops(drops);
    }

    public boolean shouldDisplay() {
        return super.shouldDisplay();
    }

    public IInventory getPatterns() {
        if (this.isOutput()) {
            PartFluidP2PInterface input = (PartFluidP2PInterface)this.getInput();
            if (input != null) {
                return input.getPatterns();
            }
            return super.getPatterns();
        }
        return super.getPatterns();
    }

    public int rows() {
        if (this.isOutput()) {
            PartFluidP2PInterface input = (PartFluidP2PInterface)this.getInput();
            if (input != null) {
                return input.rows();
            }
            return super.rows();
        }
        return super.rows();
    }

    public int rowSize() {
        if (this.isOutput()) {
            PartFluidP2PInterface input = (PartFluidP2PInterface)this.getInput();
            if (input != null) {
                return input.rowSize();
            }
            return super.rowSize();
        }
        return super.rowSize();
    }

    public String getName() {
        if (this.isOutput()) {
            PartFluidP2PInterface input = (PartFluidP2PInterface)this.getInput();
            if (input != null) {
                return input.getName();
            }
            return super.getName();
        }
        return super.getName();
    }
}

