/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.helpers.NonNullArrayIterator;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.common.Config;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.AeStackInventory;
import com.glodblock.github.inventory.AeStackInventoryImpl;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.function.UnaryOperator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;

public class TileLevelMaintainer
extends AENetworkTile
implements IAEAppEngInventory,
IGridTickable,
ICraftingRequester,
IPowerChannelState,
ILevelViewable {
    public static final int REQ_COUNT = 5;
    public final InventoryRequest requests = new InventoryRequest(this);
    private int firstRequest = 0;
    private final BaseActionSource source;
    private final IInventory inv = new AeItemStackHandler(InventoryRequest.access$000(this.requests));
    private boolean isPowered = false;

    public TileLevelMaintainer() {
        this.getProxy().setIdlePowerUsage(1.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.source = new MachineSource((IActionHost)this);
    }

    public AeStackInventory<IAEItemStack> getRequestSlots() {
        return this.requests.requestStacks;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.copyOf((Iterator)new NonNullArrayIterator((Object[])this.requests.links));
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        int idx = this.requests.getIdxByLink(link);
        try {
            double power;
            IEnergyGrid energy;
            if (this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = Math.ceil(ItemFluidDrop.isFluidStack(items) ? (double)items.getStackSize() / 1000.0 : (double)items.getStackSize()), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (ItemFluidDrop.isFluidStack(items)) {
                    IAEFluidStack notInjectedItems = (IAEFluidStack)this.getProxy().getStorage().getFluidInventory().injectItems((IAEStack)ItemFluidDrop.getAeFluidStack(items), mode, this.source);
                    if (notInjectedItems != null) {
                        items.setStackSize(notInjectedItems.getStackSize());
                        this.requests.updateState(idx, State.Export);
                        return items;
                    }
                    return null;
                }
                return (IAEItemStack)this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)items, mode, this.source);
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
        for (int x = 0; x < 5; ++x) {
            if (this.requests.getLink(x) != link) continue;
            this.requests.updateLink(x, link);
            return;
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(Config.levelMaintainerMinTicks, Config.levelMaintainerMaxTicks, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.canDoBusWork() ? this.doWork() : TickRateModulation.IDLE;
    }

    private TickRateModulation doWork() {
        block15: {
            if (!this.getProxy().isActive() || !this.canDoBusWork()) {
                return TickRateModulation.IDLE;
            }
            try {
                ICraftingGrid craftingGrid = this.getProxy().getCrafting();
                IGrid grid = this.getProxy().getGrid();
                IItemList inv = this.getProxy().getStorage().getItemInventory().getStorageList();
                ICraftingJob jobToSubmit = null;
                int jobToSubmitIdx = -1;
                IAEItemStack itemToBegin = null;
                int itemToBeginIdx = -1;
                for (int j = 0; j < 5; ++j) {
                    boolean shouldCraft;
                    int i = (this.firstRequest + j) % 5;
                    long quantity = this.requests.getQuantity(i);
                    long batchSize = this.requests.getBatchSize(i);
                    boolean isEnable = this.requests.isEnable(i);
                    if (!isEnable || batchSize == 0L) {
                        this.requests.updateState(i, State.None);
                    }
                    if (batchSize <= 0L) continue;
                    IAEItemStack craftItem = this.requests.getCraftItem(i);
                    IAEItemStack aeItem = (IAEItemStack)inv.findPrecise((IAEStack)craftItem);
                    boolean isDone = this.requests.isDone(i);
                    boolean isCraftable = aeItem != null && aeItem.isCraftable();
                    boolean bl = shouldCraft = isCraftable && aeItem.getStackSize() < quantity;
                    if (isDone) {
                        this.requests.updateState(i, State.Idle);
                    }
                    if (!isCraftable) {
                        this.requests.updateState(i, State.Error);
                    }
                    if (craftingGrid.canEmitFor(craftItem) || craftingGrid.isRequesting(craftItem) || !isDone || !shouldCraft) continue;
                    Future<ICraftingJob> jobTask = this.requests.getJob(i);
                    if (jobTask == null) {
                        if (itemToBegin != null) continue;
                        itemToBegin = craftItem;
                        itemToBeginIdx = i;
                        continue;
                    }
                    if (!jobTask.isDone()) continue;
                    this.requests.updateState(i, State.Craft);
                    try {
                        ICraftingJob job = jobTask.get();
                        if (job != null) {
                            if (jobToSubmit != null) continue;
                            jobToSubmit = job;
                            jobToSubmitIdx = i;
                            continue;
                        }
                        this.requests.updateState(i, State.Error);
                        continue;
                    }
                    catch (Exception ignored) {
                        this.requests.updateState(i, State.Error);
                    }
                }
                if (jobToSubmit != null) {
                    ICraftingLink link = craftingGrid.submitJob(jobToSubmit, (ICraftingRequester)this, null, false, this.source);
                    this.requests.updateJob(jobToSubmitIdx, null);
                    if (link != null) {
                        this.requests.updateState(jobToSubmitIdx, State.Craft);
                        this.requests.updateLink(jobToSubmitIdx, link);
                    } else {
                        this.requests.updateState(jobToSubmitIdx, State.Error);
                    }
                    break block15;
                }
                if (itemToBegin != null) {
                    this.requests.updateJob(itemToBeginIdx, craftingGrid.beginCraftingJob(this.func_145831_w(), grid, this.source, itemToBegin, null));
                    this.requests.updateState(itemToBeginIdx, State.Craft);
                    this.firstRequest = (this.firstRequest + 1) % 5;
                    break block15;
                }
                return TickRateModulation.IDLE;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SAME;
    }

    public void saveChanges() {
        super.saveChanges();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    public void gridChanged() {
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public InventoryRequest getRequestInventory() {
        return this.requests;
    }

    public IInventory getInventory() {
        return this.inv;
    }

    public IInventory getInventoryByName(String name) {
        if (name == "config") {
            return new AeItemStackHandler(this.requests.requestStacks);
        }
        return null;
    }

    public void updateQuantity(int idx, long size) {
        this.requests.updateQuantity(idx, size);
    }

    public void updateBatchSize(int idx, long size) {
        this.requests.updateBatchSize(idx, size);
    }

    public void updateStatus(int idx, boolean enable) {
        this.requests.updateStatus(idx, enable);
    }

    private void readLinkFromNBT(NBTTagCompound data) {
        for (int i = 0; i < 5; ++i) {
            NBTTagCompound stackData = this.requests.getItemStack(i).func_77978_p();
            if (stackData != null && stackData.func_82582_d() && !stackData.func_74764_b(TLMTags.Link.tagName) && stackData.func_74775_l(TLMTags.Link.tagName).func_82582_d()) {
                this.requests.updateLink(i, null);
                this.requests.updateState(i, State.Idle);
                continue;
            }
            NBTTagCompound linkData = stackData.func_74775_l(TLMTags.Link.tagName);
            this.requests.updateLink(i, AEApi.instance().storage().loadCraftingLink(linkData, (ICraftingRequester)this));
            if (this.requests.isDone(i)) continue;
            this.requests.updateState(i, State.Craft);
        }
    }

    @Deprecated
    private void readLinkFromNBT__old(NBTTagCompound data) {
        try {
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound link = data.func_74775_l("links-" + i);
                if (link != null && link.func_82582_d()) {
                    this.requests.updateLink(i, null);
                    continue;
                }
                this.requests.updateLink(i, AEApi.instance().storage().loadCraftingLink(link, (ICraftingRequester)this));
                if (this.requests.isDone(i)) continue;
                this.requests.updateState(i, State.Craft);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBTEvent(NBTTagCompound data) {
        this.requests.requestStacks.writeToNbt(data, TLMTags.RequestStacks.tagName);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        if (data.func_74764_b(TLMTags.RequestStacks.tagName)) {
            this.requests.requestStacks.readFromNbt(data, TLMTags.RequestStacks.tagName);
            if (Platform.isServer()) {
                for (int i = 0; i < 5; ++i) {
                    ItemStack craftStack;
                    ItemStack storageStack;
                    ItemStack itemStack;
                    if (this.requests.requestStacks.getStack(i) == null || ItemStack.func_77989_b((ItemStack)(itemStack = TileLevelMaintainer.loadItemStackFromTag(storageStack = ((IAEItemStack)this.requests.requestStacks.getStack(i)).getItemStack())), (ItemStack)(craftStack = this.removeRecursion(storageStack)))) continue;
                    this.requests.updateStack(i, craftStack);
                    AELog.info((String)("[TileLevelMaintainer] Replace craft stack from: " + itemStack.toString() + ":" + (itemStack.func_77942_o() ? itemStack.func_77978_p() : "{no tags}") + "; with: " + craftStack + ":" + (craftStack.func_77942_o() ? craftStack.func_77978_p() : "{no tags}")), (Object[])new Object[0]);
                }
            }
        } else {
            int i;
            long[] batches = new long[5];
            long[] quantyties = new long[5];
            this.requests.requestStacks.readFromNbt(data, "Batch");
            for (i = 0; i < 5; ++i) {
                IAEItemStack batchStack = (IAEItemStack)this.requests.requestStacks.getStack(i);
                batches[i] = batchStack != null ? batchStack.getStackSize() : 0L;
            }
            this.requests.requestStacks.readFromNbt(data, "Count");
            for (i = 0; i < 5; ++i) {
                IAEItemStack quantityStack = (IAEItemStack)this.requests.requestStacks.getStack(i);
                quantyties[i] = quantityStack != null ? quantityStack.getStackSize() : 0L;
            }
            this.requests.requestStacks.readFromNbt(data, "Inventory");
            for (i = 0; i < 5; ++i) {
                IAEItemStack requestsStack = (IAEItemStack)this.requests.requestStacks.getStack(i);
                if (requestsStack == null) continue;
                this.requests.updateStack(i, requestsStack.getItemStack());
                this.requests.updateBatchSize(i, batches[i]);
                this.requests.updateQuantity(i, quantyties[i]);
            }
            this.readLinkFromNBT__old(data);
        }
    }

    private ItemStack removeRecursion(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b(TLMTags.Stack.tagName)) {
            return this.removeRecursion(TileLevelMaintainer.loadItemStackFromTag(itemStack));
        }
        return itemStack;
    }

    @Nullable
    private static ItemStack loadItemStackFromTag(ItemStack itemStack) {
        return ItemStack.func_77949_a((NBTTagCompound)itemStack.func_77978_p().func_74775_l(TLMTags.Stack.tagName));
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public ForgeDirection getSide() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public int rowSize() {
        return 5;
    }

    @Override
    public ItemStack getSelfItemStack() {
        return this.getItemFromTile(this);
    }

    public static final class InventoryRequest {
        private final AeStackInventoryImpl<IAEItemStack> requestStacks;
        private final Future<ICraftingJob>[] jobs;
        private final ICraftingLink[] links;
        private final State[] state = new State[5];

        public InventoryRequest(TileLevelMaintainer tile) {
            this.requestStacks = new AeStackInventoryImpl(StorageChannel.ITEMS, 5, tile);
            this.jobs = new Future[5];
            this.links = new ICraftingLink[5];
        }

        public State getState(int idx) {
            IAEItemStack ias = this.requestStacks.getStack(idx);
            if (ias == null) {
                return State.None;
            }
            return this.state[idx] == null ? State.Idle : this.state[idx];
        }

        public int getIdxByLink(ICraftingLink link) {
            for (int i = 0; i < 5; ++i) {
                if (this.links[i] != link) continue;
                return i;
            }
            return 0;
        }

        public boolean isEnable(int idx) {
            IAEItemStack ias = this.requestStacks.getStack(idx);
            if (ias == null) {
                return true;
            }
            ItemStack is = ias.getItemStack();
            return is.func_77942_o() ? is.func_77978_p().func_74767_n(TLMTags.Enable.tagName) : true;
        }

        public boolean isDone(int index) {
            if (this.links[index] == null) {
                return true;
            }
            return this.links[index].isDone() || this.links[index].isCanceled();
        }

        public Future<ICraftingJob> getJob(int idx) {
            return this.jobs[idx];
        }

        public ICraftingLink getLink(int idx) {
            return this.links[idx];
        }

        public void updateJob(int idx, Future<ICraftingJob> job) {
            this.jobs[idx] = job;
        }

        private void updateField(int idx, UnaryOperator<NBTTagCompound> updater) {
            IAEItemStack ias = this.requestStacks.getStack(idx);
            if (ias == null) {
                return;
            }
            ItemStack itemStack = ias.getItemStack();
            NBTTagCompound data = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
            data.func_74768_a(TLMTags.Index.tagName, idx);
            itemStack.func_77982_d((NBTTagCompound)updater.apply(data));
            AEItemStack newRequestStack = AEItemStack.create((ItemStack)itemStack);
            newRequestStack.setStackSize(ias.getStackSize());
            this.requestStacks.setStack(idx, (IAEItemStack)newRequestStack);
        }

        public void updateLink(int idx, ICraftingLink link) {
            this.links[idx] = link;
            this.updateField(idx, data -> {
                NBTTagCompound linkData = new NBTTagCompound();
                if (link != null) {
                    link.writeToNBT(linkData);
                }
                data.func_74782_a(TLMTags.Link.tagName, (NBTBase)linkData);
                return data;
            });
        }

        public void updateState(int idx, State nextState) {
            this.state[idx] = nextState;
            this.updateField(idx, data -> {
                data.func_74768_a(TLMTags.State.tagName, nextState.ordinal());
                return data;
            });
        }

        public void updateStatus(int idx, boolean enable) {
            this.updateField(idx, data -> {
                State nextState = enable ? State.Idle : State.None;
                data.func_74757_a(TLMTags.Enable.tagName, enable);
                data.func_74768_a(TLMTags.State.tagName, nextState.ordinal());
                return data;
            });
        }

        public void updateQuantity(int idx, long quantity) {
            this.updateField(idx, data -> {
                data.func_74772_a(TLMTags.Quantity.tagName, quantity);
                return data;
            });
        }

        public void updateBatchSize(int idx, long batch) {
            this.updateField(idx, data -> {
                data.func_74772_a(TLMTags.Batch.tagName, batch);
                data.func_74757_a(TLMTags.Enable.tagName, true);
                return data;
            });
        }

        public void updateStack(int idx, ItemStack itemStack) {
            this.updateField(idx, data -> {
                NBTTagCompound stackData = new NBTTagCompound();
                if (itemStack != null) {
                    itemStack.func_77955_b(stackData);
                }
                data.func_74782_a(TLMTags.Stack.tagName, (NBTBase)stackData);
                return data;
            });
        }

        public IAEItemStack getAEItemStack(int idx) {
            return this.requestStacks.getStack(idx);
        }

        public ItemStack getItemStack(int idx) {
            return this.requestStacks.getStack(idx).getItemStack();
        }

        public long getQuantity(int idx) {
            if (!this.isEnable(idx)) {
                return 0L;
            }
            IAEItemStack ias = this.requestStacks.getStack(idx);
            if (ias == null) {
                return 0L;
            }
            ItemStack itemStack = ias.getItemStack();
            if (!itemStack.func_77942_o()) {
                return 0L;
            }
            return itemStack.func_77978_p().func_74763_f(TLMTags.Quantity.tagName);
        }

        public long getBatchSize(int idx) {
            if (!this.isEnable(idx)) {
                return 0L;
            }
            IAEItemStack ias = this.requestStacks.getStack(idx);
            if (ias == null) {
                return 0L;
            }
            ItemStack itemStack = ias.getItemStack();
            if (!itemStack.func_77942_o()) {
                return 0L;
            }
            return itemStack.func_77978_p().func_74763_f(TLMTags.Batch.tagName);
        }

        public IAEItemStack getCraftItem(int idx) {
            IAEItemStack is = this.requestStacks.getStack(idx);
            if (is == null) {
                return null;
            }
            if (is.getItemStack() == null) {
                return null;
            }
            ItemStack qis = TileLevelMaintainer.loadItemStackFromTag(is.getItemStack());
            if (qis == null) {
                return null;
            }
            AEItemStack qais = AEItemStack.create((ItemStack)qis);
            qais.setStackSize(this.getBatchSize(idx));
            return qais;
        }
    }

    public static enum State {
        None,
        Idle,
        Craft,
        Export,
        Error;

    }

    public static enum TLMTags {
        RequestStacks("RequestStacks"),
        Enable("Enable"),
        Quantity("Quantity"),
        Batch("Batch"),
        Link("Link"),
        State("State"),
        Index("Index"),
        Stack("Stack");

        public final String tagName;

        private TLMTags(String tagName) {
            this.tagName = tagName;
        }
    }
}

