/*
 * Decompiled with CFR 0.152.
 */
package emt.tile.solar;

import emt.init.EMTBlocks;
import emt.tile.solar.TileEntitySolarBase;
import emt.util.EMTConfigHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;

public enum Solars {
    Compressed(EMTConfigHandler.compressedSolarOutput, null, 0, 0, "solar.compressed"),
    Double_Compressed(EMTConfigHandler.doubleCompressedSolarOutput, null, 0, 1, "solar.doublecompressed"),
    Triple_Compressed(EMTConfigHandler.tripleCompressedSolarOutput, null, 0, 2, "solar.triplecompressed"),
    Compressed_Aqua(EMTConfigHandler.compressedSolarOutput, Aspect.WATER, 0, 3, "solar.water"),
    Double_Compressed_Aqua(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.WATER, 0, 4, "solar.doublewater"),
    Triple_Compressed_Aqua(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.WATER, 0, 5, "solar.triplewater"),
    Compressed_Perditio(EMTConfigHandler.compressedSolarOutput, Aspect.ENTROPY, 0, 6, "solar.dark"),
    Double_Compressed_Perditio(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.ENTROPY, 0, 7, "solar.doubledark"),
    Triple_Compressed_Perditio(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.ENTROPY, 0, 8, "solar.tripledark"),
    Compressed_Ordo(EMTConfigHandler.compressedSolarOutput, Aspect.ORDER, 0, 9, "solar.order"),
    Double_Compressed_Ordo(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.ORDER, 0, 10, "solar.doubleorder"),
    Triple_Compressed_Ordo(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.ORDER, 0, 11, "solar.tripleorder"),
    Compressed_Ignis(EMTConfigHandler.compressedSolarOutput, Aspect.FIRE, 0, 12, "solar.fire"),
    Double_Compressed_Ignis(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.FIRE, 0, 13, "solar.doublefire"),
    Triple_Compressed_Ignis(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.FIRE, 0, 14, "solar.triplefire"),
    Compressed_Aer(EMTConfigHandler.compressedSolarOutput, Aspect.AIR, 0, 15, "solar.air"),
    Double_Compressed_Aer(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.AIR, 1, 0, "solar.doubleair"),
    Triple_Compressed_Aer(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.AIR, 1, 1, "solar.tripleair"),
    Compressed_Terra(EMTConfigHandler.compressedSolarOutput, Aspect.EARTH, 1, 2, "solar.earth"),
    Double_Compressed_Terra(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.EARTH, 1, 3, "solar.doubleearth"),
    Triple_Compressed_Terra(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.EARTH, 1, 4, "solar.tripleearth"),
    Quadruple_Compressed(EMTConfigHandler.quadrupleCompressedSolarOutput, null, 2, 0, "Quadruple_Compressed_Solar"),
    Quadruple_Compressed_Ordo(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.ORDER, 2, 1, "Quadruple_Compressed_Ordo_Solar"),
    Quadruple_Compressed_Perditio(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.ENTROPY, 2, 2, "Quadruple_Compressed_Perditio_Solar"),
    Quadruple_Compressed_Aer(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.AIR, 2, 3, "Quadruple_Compressed_Aer_Solar"),
    Quadruple_Compressed_Terra(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.EARTH, 2, 4, "Quadruple_Compressed_Terra_Solar"),
    Quadruple_Compressed_Aqua(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.WATER, 2, 5, "Quadruple_Compressed_Aqua_Solar"),
    Quadruple_Compressed_Ignis(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.FIRE, 2, 6, "Quadruple_Compressed_Ignis_Solar"),
    Quintuple_Compressed(EMTConfigHandler.quintupleCompressedSolarOutput, null, 2, 7, "Quintuple_Compressed_Solar"),
    Quintuple_Compressed_Ordo(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.ORDER, 2, 8, "Quintuple_Compressed_Ordo_Solar"),
    Quintuple_Compressed_Perditio(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.ENTROPY, 2, 9, "Quintuple_Compressed_Perditio_Solar"),
    Quintuple_Compressed_Aer(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.AIR, 2, 10, "Quintuple_Compressed_Aer_Solar"),
    Quintuple_Compressed_Terra(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.EARTH, 2, 11, "Quintuple_Compressed_Terra_Solar"),
    Quintuple_Compressed_Aqua(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.WATER, 2, 12, "Quintuple_Compressed_Aqua_Solar"),
    Quintuple_Compressed_Ignis(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.FIRE, 2, 13, "Quintuple_Compressed_Ignis_Solar"),
    Sextuple_Compressed(EMTConfigHandler.sextupleCompressedSolarOutput, null, 2, 14, "Sextuple_Compressed_Solar"),
    Sextuple_Compressed_Ordo(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.ORDER, 2, 15, "Sextuple_Compressed_Ordo_Solar"),
    Sextuple_Compressed_Perditio(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.ENTROPY, 3, 0, "Sextuple_Compressed_Perditio_Solar"),
    Sextuple_Compressed_Aer(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.AIR, 3, 1, "Sextuple_Compressed_Aer_Solar"),
    Sextuple_Compressed_Terra(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.EARTH, 3, 2, "Sextuple_Compressed_Terra_Solar"),
    Sextuple_Compressed_Aqua(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.WATER, 3, 3, "Sextuple_Compressed_Aqua_Solar"),
    Sextuple_Compressed_Ignis(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.FIRE, 3, 4, "Sextuple_Compressed_Ignis_Solar"),
    Septuple_Compressed(EMTConfigHandler.septupleCompressedSolarOutput, null, 3, 5, "Septuple_Compressed_Solar"),
    Septuple_Compressed_Ordo(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.ORDER, 3, 6, "Septuple_Compressed_Ordo_Solar"),
    Septuple_Compressed_Perditio(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.ENTROPY, 3, 7, "Septuple_Compressed_Perditio_Solar"),
    Septuple_Compressed_Aer(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.AIR, 3, 8, "Septuple_Compressed_Aer_Solar"),
    Septuple_Compressed_Terra(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.EARTH, 3, 9, "Septuple_Compressed_Terra_Solar"),
    Septuple_Compressed_Aqua(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.WATER, 3, 10, "Septuple_Compressed_Aqua_Solar"),
    Septuple_Compressed_Ignis(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.FIRE, 3, 11, "Septuple_Compressed_Ignis_Solar"),
    Octuple_Compressed(EMTConfigHandler.octupleCompressedSolarOutput, null, 3, 12, "Octuple_Compressed_Solar"),
    Octuple_Compressed_Ordo(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.ORDER, 3, 13, "Octuple_Compressed_Ordo_Solar"),
    Octuple_Compressed_Perditio(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.ENTROPY, 3, 14, "Octuple_Compressed_Perditio_Solar"),
    Octuple_Compressed_Aer(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.AIR, 3, 15, "Octuple_Compressed_Aer_Solar"),
    Octuple_Compressed_Terra(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.EARTH, 4, 0, "Octuple_Compressed_Terra_Solar"),
    Octuple_Compressed_Aqua(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.WATER, 4, 1, "Octuple_Compressed_Aqua_Solar"),
    Octuple_Compressed_Ignis(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.FIRE, 4, 2, "Octuple_Compressed_Ignis_Solar");

    private static final LinkedHashMap<Long, Solars> cachemap;
    final int instance;
    final int meta;
    final Aspect aspect;
    final String guiname;
    private final double output;
    private final String unlocalizedName;
    public final long id;

    private Solars(double output, Aspect aspect, int instance, int meta, String unlocalizedName) {
        this.aspect = aspect;
        this.output = output;
        this.guiname = this.name().replaceAll("_", " ") + " Solar";
        this.instance = instance;
        this.meta = meta;
        this.unlocalizedName = unlocalizedName;
        this.id = (long)instance << 4 | (long)meta;
    }

    @Nullable
    private static Solars getBaseSolar(double output) {
        for (Solars s : Solars.values()) {
            if (s.output != output || s.aspect != null) continue;
            return s;
        }
        return null;
    }

    public static void registerReverseRecipes() {
        for (Solars s : Solars.values()) {
            if (s.aspect == null) continue;
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{new ItemStack(EMTBlocks.solars[s.instance], 1, s.meta)}).fluidInputs(new FluidStack[]{Materials.Chlorine.getGas(1000L)}).itemOutputs(new ItemStack[]{new ItemStack(EMTBlocks.solars[Solars.getBaseSolar((double)s.output).instance], 1, Solars.getBaseSolar((double)s.output).meta)}).duration(40).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.chemicalBathRecipes);
        }
    }

    public static void populateCache() {
        for (Solars s : Solars.values()) {
            cachemap.put(s.id, s);
        }
    }

    public static int getCountOfInstances() {
        int ret = 0;
        for (Solars s : Solars.values()) {
            ret = Math.max(s.instance, ret);
        }
        return ret + 1;
    }

    public static int getCountOfMetas(int instance) {
        int ret = 0;
        for (Solars s : Solars.values()) {
            if (s.instance != instance) continue;
            ret = Math.max(s.meta, ret);
        }
        return ret + 1;
    }

    @Nullable
    public static TileEntitySolarBase getTileEntitySolarBase(int instance, int meta) {
        Solars solar = Solars.getSolar(instance, meta);
        if (solar == null) {
            return null;
        }
        return new TileEntitySolarBase(solar.output, solar.aspect, solar.guiname, instance, meta);
    }

    public static String getNameFromSolar(int instance, int meta) {
        Solars solar = Solars.getSolar(instance, meta);
        if (solar == null) {
            return "";
        }
        return solar.guiname;
    }

    public static String getUnlocalizedName(int instance, int meta) {
        Solars solar = Solars.getSolar(instance, meta);
        if (solar == null) {
            return "nothing";
        }
        return solar.unlocalizedName;
    }

    @Nullable
    public static Solars getSolar(int instance, int meta) {
        long id = (long)instance << 4 | (long)meta;
        Solars cached = cachemap.get(id);
        if (cached != null) {
            return cached;
        }
        for (Solars s : Solars.values()) {
            cachemap.put(s.id, s);
            if (s.id != id) continue;
            return s;
        }
        return null;
    }

    static {
        cachemap = new LinkedHashMap();
    }
}

