/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static boolean matchTag(@Nullable NBTBase template, @Nullable NBTBase target) {
        if (template instanceof NBTTagCompound && target instanceof NBTTagCompound) {
            return NBTHelper.matchTagCompound((NBTTagCompound)template, (NBTTagCompound)target);
        }
        if (template instanceof NBTTagList && target instanceof NBTTagList) {
            return NBTHelper.matchTagList((NBTTagList)template, (NBTTagList)target);
        }
        return template == null || target != null && target.equals((Object)template);
    }

    private static boolean matchTagCompound(NBTTagCompound template, NBTTagCompound target) {
        if (template.field_74784_a.size() > target.field_74784_a.size()) {
            return false;
        }
        for (String key : template.func_150296_c()) {
            if (NBTHelper.matchTag(template.func_74781_a(key), target.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTagList(NBTTagList template, NBTTagList target) {
        if (template.func_74745_c() > target.func_74745_c()) {
            return false;
        }
        for (int i = 0; i < template.func_74745_c(); ++i) {
            if (NBTHelper.matchTag(NBTHelper.get(template, i), NBTHelper.get(target, i))) continue;
            return false;
        }
        return true;
    }

    private static NBTBase get(NBTTagList tag, int idx) {
        return idx >= 0 && idx < tag.field_74747_a.size() ? (NBTBase)tag.field_74747_a.get(idx) : null;
    }
}

