/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech.machines;

import gregtech.api.enums.GT_Values;
import gttweaker.mods.AddMultipleRecipeAction;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.DistillationTower")
@ModOnly(value={"gregtech"})
public class DistillationTower {
    @ZenMethod
    public static void addRecipe(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        if (fluidOutput.length < 1) {
            MineTweakerAPI.logError((String)"Distillation Tower must have at least 1 Fluid output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding Distillation Tower recipe for " + fluidInput.getDisplayName(), new Object[]{fluidInput, fluidOutput, itemOutput, durationTicks, euPerTick}){

                @Override
                protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                    GT_Values.RA.addDistillationTowerRecipe(i.nextFluid(), i.nextFluidArr(), i.nextItem(), i.nextInt(), i.nextInt());
                }
            });
        }
    }

    @ZenMethod
    public static void addUniversalRecipe(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddMultipleRecipeAction("Adding universal distillation recipe for " + fluidInput.getDisplayName(), new Object[]{fluidInput, fluidOutput, itemOutput, durationTicks, euPerTick}){

            @Override
            protected void applySingleRecipe(AddMultipleRecipeAction.ArgIterator i) {
                GT_Values.RA.addUniversalDistillationRecipe(i.nextFluid(), i.nextFluidArr(), i.nextItem(), i.nextInt(), i.nextInt());
            }
        });
    }
}

