/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.helpers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ReflectionHelper {
    private static final HashMap<String, _FieldsMethods> classes = new HashMap();

    public static <T> T getField(Object obj, String fieldName, T defaultvalue) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Field> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getField$0(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).fields;
        try {
            boolean exceptionDetected;
            if (classmap.containsKey(fieldName)) {
                Field f = classmap.get(fieldName);
                if (f == null) {
                    return defaultvalue;
                }
                return (T)f.get(obj);
            }
            Field f = null;
            do {
                exceptionDetected = false;
                try {
                    f = cl.getDeclaredField(fieldName);
                    f.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(fieldName, f);
            if (f == null) {
                return defaultvalue;
            }
            return (T)f.get(obj);
        }
        catch (Exception ex) {
            return defaultvalue;
        }
    }

    public static <T> boolean setField(Object obj, String fieldName, T value) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Field> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setField$1(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).fields;
        try {
            boolean exceptionDetected;
            if (classmap.containsKey(fieldName)) {
                Field f = classmap.get(fieldName);
                if (f == null) {
                    return false;
                }
                f.set(obj, value);
                return true;
            }
            Field f = null;
            do {
                exceptionDetected = false;
                try {
                    f = cl.getDeclaredField(fieldName);
                    f.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(fieldName, f);
            if (f == null) {
                return false;
            }
            f.set(obj, value);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> T getField(Object obj, String fieldName) {
        return ReflectionHelper.getField(obj, fieldName, null);
    }

    public static <T> T callMethod(Object obj, String methodName, T defaultValue, Object ... args) {
        Class<?> cl = obj.getClass();
        String clName = cl.getName();
        HashMap<String, Method> classmap = ReflectionHelper.classes.computeIfAbsent((String)clName, (Function<String, _FieldsMethods>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$callMethod$2(java.lang.String ), (Ljava/lang/String;)Lkubatech/api/helpers/ReflectionHelper$_FieldsMethods;)()).methods;
        StringBuilder builder = new StringBuilder(methodName);
        Class[] argsTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> arg = args[i].getClass();
            builder.append(";").append(arg.getSimpleName());
            argsTypes[i] = arg;
        }
        String methodNameUnique = builder.toString();
        try {
            boolean exceptionDetected;
            if (classmap.containsKey(methodNameUnique)) {
                Method m = classmap.get(methodNameUnique);
                if (m == null) {
                    return defaultValue;
                }
                return (T)m.invoke(obj, args);
            }
            Method m = null;
            do {
                exceptionDetected = false;
                try {
                    m = cl.getDeclaredMethod(methodName, argsTypes);
                    m.setAccessible(true);
                }
                catch (Exception ex) {
                    exceptionDetected = true;
                    cl = cl.getSuperclass();
                }
            } while (exceptionDetected && !cl.equals(Object.class));
            classmap.put(methodNameUnique, m);
            if (m == null) {
                return defaultValue;
            }
            return (T)m.invoke(obj, args);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Collection<ClassNode> getClasses(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String packagePath = packageName.replace('.', '/');
        URL resource = classLoader.getResource(packagePath);
        if (resource == null) {
            throw new FileNotFoundException();
        }
        if (!resource.getProtocol().equals("jar")) {
            return Collections.emptySet();
        }
        try (JarFile jar = ((JarURLConnection)resource.openConnection()).getJarFile();){
            Collection collection = jar.stream().filter(j -> !j.isDirectory() && j.getName().startsWith(packagePath) && j.getName().endsWith(".class")).map(j -> {
                try {
                    byte[] bytes;
                    String name = j.getName();
                    URL jarResource = Launch.classLoader.getResource(name);
                    if (jarResource == null) {
                        return null;
                    }
                    try (InputStream is = jarResource.openStream();){
                        bytes = new byte[(int)j.getSize()];
                        if (is.read(bytes) != bytes.length) {
                            ClassNode classNode = null;
                            return classNode;
                        }
                        if (is.available() > 0) {
                            ClassNode classNode = null;
                            return classNode;
                        }
                    }
                    ClassNode cn = new ClassNode();
                    ClassReader cr = new ClassReader(bytes);
                    cr.accept((ClassVisitor)cn, 0);
                    return cn;
                }
                catch (IOException iOException) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            return collection;
        }
    }

    private static /* synthetic */ _FieldsMethods lambda$callMethod$2(String s) {
        return new _FieldsMethods();
    }

    private static /* synthetic */ _FieldsMethods lambda$setField$1(String s) {
        return new _FieldsMethods();
    }

    private static /* synthetic */ _FieldsMethods lambda$getField$0(String s) {
        return new _FieldsMethods();
    }

    private static class _FieldsMethods {
        final HashMap<String, Field> fields = new HashMap();
        final HashMap<String, Method> methods = new HashMap();

        private _FieldsMethods() {
        }
    }
}

