/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.dreammaster.main.MainRegistry;
import com.dreammaster.modcustomdrops.CustomDrops;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobOverride;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.api.event.MobNEIRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PostMobRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PostMobsOverridesLoadEvent;
import com.kuba6000.mobsinfo.api.event.PreMobsRegistrationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kubatech.api.LoaderReference;
import kubatech.api.helpers.ReflectionHelper;
import kubatech.config.Config;
import kubatech.tileentity.gregtech.multiblock.GT_MetaTileEntity_ExtremeEntityCrusher;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobHandlerLoader {
    private static final Logger LOG = LogManager.getLogger((String)"kubatech[Mob Handler Loader]");
    private static MobHandlerLoader instance = null;
    public static Map<String, MobEECRecipe> recipeMap = new HashMap<String, MobEECRecipe>();

    public static void init() {
        instance = new MobHandlerLoader();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    public void onPreMobsRegistration(PreMobsRegistrationEvent event) {
        recipeMap.clear();
    }

    @SubscribeEvent
    public void onPostMobRegistration(PostMobRegistrationEvent event) {
        ArrayList drops;
        if (!event.drops.isEmpty() && event.recipe.isUsableInVial && !(drops = (ArrayList)event.drops.clone()).isEmpty()) {
            recipeMap.put(event.currentMob, new MobEECRecipe(drops, event.recipe));
        }
    }

    @SubscribeEvent
    public void onPostOverridesConfigLoad(PostMobsOverridesLoadEvent event) {
        if (LoaderReference.GTNHCoreMod) {
            LOG.info("Detected GTNH Core Mod, parsing custom drops from there.");
            CustomDrops coredrops = ReflectionHelper.getField(MainRegistry.Module_CustomDrops, "_mCustomDrops", null);
            if (coredrops != null) {
                ArrayList customdrops = (ArrayList)((ArrayList)coredrops.getCustomDrops()).clone();
                for (CustomDrops.CustomDrop customdrop : customdrops) {
                    try {
                        String ename;
                        Class<?> eclass = Class.forName(customdrop.getEntityName());
                        if (!EntityLiving.class.isAssignableFrom(eclass) || (ename = (String)EntityList.field_75626_c.get(eclass)) == null) continue;
                        MobOverride override = event.overrides.computeIfAbsent(ename, k -> new MobOverride());
                        for (CustomDrops.CustomDrop.Drop drop : customdrop.getDrops()) {
                            String pNBT;
                            String[] parts = drop.getItemName().split(":");
                            ItemStack stack = GameRegistry.findItemStack((String)parts[0], (String)parts[1], (int)1);
                            if (stack == null) continue;
                            if (parts.length > 2) {
                                stack.func_77964_b(Integer.parseInt(parts[2]));
                            }
                            if ((pNBT = (String)ReflectionHelper.getField(drop, "mTag", null)) != null && !pNBT.isEmpty()) {
                                try {
                                    stack.field_77990_d = (NBTTagCompound)JsonToNBT.func_150315_a((String)pNBT);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            int chance = drop.getChance() * 100;
                            int amount = drop.getAmount();
                            if (drop.getIsRandomAmount()) {
                                chance = (int)((double)chance * ((2.0 + (double)(amount * amount) + (double)amount) / (2.0 * ((double)amount + 1.0))));
                                amount = 1;
                                if (chance > 10000) {
                                    int div = (int)Math.ceil((double)chance / 10000.0);
                                    amount *= div;
                                    chance /= div;
                                }
                            }
                            stack.field_77994_a = amount;
                            MobDrop mobDrop = new MobDrop(stack, MobDrop.DropType.Normal, chance, null, null, false, true);
                            mobDrop.additionalInfo.add(StatCollector.func_74837_a((String)"kubatech.mobhandler.eec_chance", (Object[])new Object[]{(double)chance / 100.0 * Config.MobHandler.playerOnlyDropsModifier}));
                            override.additions.add(mobDrop);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobNEIRegistration(MobNEIRegistrationEvent event) {
        MobEECRecipe recipe = recipeMap.get(event.mobName);
        if (recipe != null) {
            List list = event.additionalInformation;
            String[] stringArray = new String[2];
            StringBuilder stringBuilder = new StringBuilder().append(GT_Utility.trans((String)"153", (String)"Usage: "));
            recipe.getClass();
            stringArray[0] = stringBuilder.append(GT_Utility.formatNumbers((long)2000L)).append(" EU/t").toString();
            stringArray[1] = GT_Utility.trans((String)"158", (String)"Time: ") + GT_Utility.formatNumbers((double)((double)recipe.mDuration / 20.0)) + " secs";
            list.addAll(Arrays.asList(stringArray));
        }
    }

    public static class MobEECRecipe {
        public final List<MobDrop> mOutputs;
        public final MobRecipe recipe;
        public final int mEUt = 2000;
        public final int mDuration;
        public final EntityLiving entityCopy;

        public MobEECRecipe(List<MobDrop> transformedDrops, MobRecipe recipe) {
            this.mOutputs = transformedDrops;
            this.recipe = recipe;
            try {
                this.entityCopy = this.recipe.createEntityCopy();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            this.mDuration = Math.max(55, (int)((double)recipe.maxEntityHealth / 9.0 * 10.0));
        }

        public ItemStack[] generateOutputs(Random rnd, GT_MetaTileEntity_ExtremeEntityCrusher MTE, double attackDamage, int lootinglevel, boolean preferInfernalDrops, boolean voidAllDamagedAndEnchantedItems) {
            MTE.lEUt = 2000L;
            MTE.mMaxProgresstime = Math.max(55, (int)((double)this.recipe.maxEntityHealth / attackDamage * 10.0));
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.mOutputs.size());
            this.entityCopy.func_70107_b((double)MTE.getBaseMetaTileEntity().getXCoord(), (double)MTE.getBaseMetaTileEntity().getYCoord(), (double)MTE.getBaseMetaTileEntity().getZCoord());
            for (MobDrop o : this.mOutputs) {
                if (voidAllDamagedAndEnchantedItems && (o.damages != null || o.enchantable != null)) continue;
                int chance = o.chance;
                double dChance = (double)chance / 100.0;
                for (IChanceModifier chanceModifier : o.chanceModifiers) {
                    dChance = chanceModifier.apply(dChance, MTE.getBaseMetaTileEntity().getWorld(), stacks, (Entity)MTE.EECPlayer, this.entityCopy);
                }
                chance = (int)(dChance * 100.0);
                if (chance == 0) continue;
                if (o.playerOnly && (chance = (int)((double)chance * Config.MobHandler.playerOnlyDropsModifier)) < 1) {
                    chance = 1;
                }
                int amount = o.stack.field_77994_a;
                if (o.lootable && lootinglevel > 0 && (chance += lootinglevel * 5000) > 10000) {
                    int div = (int)Math.ceil((double)chance / 10000.0);
                    amount *= div;
                    chance /= div;
                }
                if (chance != 10000 && rnd.nextInt(10000) >= chance) continue;
                ItemStack s = o.stack.func_77946_l();
                s.field_77994_a = amount;
                if (o.enchantable != null) {
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)s, (int)o.enchantable);
                }
                if (o.damages != null) {
                    int rChance = rnd.nextInt(this.recipe.mMaxDamageChance);
                    int cChance = 0;
                    for (Map.Entry damage : o.damages.entrySet()) {
                        if (rChance > (cChance += ((Integer)damage.getValue()).intValue())) continue;
                        s.func_77964_b(((Integer)damage.getKey()).intValue());
                        break;
                    }
                }
                stacks.add(s);
            }
            if (LoaderReference.InfernalMobs) {
                InfernalMobsCore infernalMobsCore = InfernalMobsCore.instance();
                if (this.recipe.infernalityAllowed && 16000L <= MTE.getMaxInputEu() && !infernalMobsCore.getDimensionBlackList().contains(MTE.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
                    int p = 0;
                    int mods = 0;
                    if (this.recipe.alwaysinfernal || preferInfernalDrops && rnd.nextInt(infernalMobsCore.getEliteRarity()) == 0) {
                        p = 1;
                        if (rnd.nextInt(infernalMobsCore.getUltraRarity()) == 0) {
                            p = 2;
                            if (rnd.nextInt(infernalMobsCore.getInfernoRarity()) == 0) {
                                p = 3;
                            }
                        }
                    }
                    ArrayList infernalstacks = null;
                    if (p > 0) {
                        if (p == 1) {
                            infernalstacks = infernalMobsCore.getDropIdListElite();
                            mods = infernalMobsCore.getMinEliteModifiers();
                        } else if (p == 2) {
                            infernalstacks = infernalMobsCore.getDropIdListUltra();
                            mods = infernalMobsCore.getMinUltraModifiers();
                        } else {
                            infernalstacks = infernalMobsCore.getDropIdListInfernal();
                            mods = infernalMobsCore.getMinInfernoModifiers();
                        }
                    }
                    if (infernalstacks != null) {
                        ItemStack infernalstack = ((ItemStack)infernalstacks.get(rnd.nextInt(infernalstacks.size()))).func_77946_l();
                        EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)infernalstack, (int)infernalstack.func_77973_b().func_77619_b());
                        stacks.add(infernalstack);
                        MTE.lEUt *= 8L;
                        MTE.mMaxProgresstime = (int)((double)MTE.mMaxProgresstime * ((double)mods * InfernalMobsCore.instance().getMobModHealthFactor()));
                    }
                }
            }
            return stacks.toArray(new ItemStack[0]);
        }
    }
}

