/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_MultiInput;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_DummyWorld;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_Item_Ores;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import kubatech.api.DynamicInventory;
import kubatech.api.LoaderReference;
import kubatech.api.Variables;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.utils.ItemUtils;
import kubatech.client.effect.CropRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_ExtremeIndustrialGreenhouse
extends KubaTechGTMultiBlockBase<GT_MetaTileEntity_ExtremeIndustrialGreenhouse> {
    private static final boolean debug = false;
    private static final int EIG_MATH_VERSION = 0;
    private static final int CONFIGURATION_WINDOW_ID = 999;
    public final List<GreenHouseSlot> mStorage = new ArrayList<GreenHouseSlot>();
    private int oldVersion = 0;
    private int mCasing = 0;
    public int mMaxSlots = 0;
    private int setupphase = 1;
    private boolean isIC2Mode = false;
    private byte glasTier = 0;
    private int waterusage = 0;
    private int weedexusage = 0;
    private boolean isNoHumidity = false;
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final Item forestryfertilizer = GameRegistry.findItem((String)"Forestry", (String)"fertilizerCompound");
    private static final Fluid weedex = Materials.WeedEX9000.mFluid;
    private static final IStructureDefinition<GT_MetaTileEntity_ExtremeIndustrialGreenhouse> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ccccc", "clllc", "clllc", "clllc", "ccccc"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ccccc", "cdddc", "cdwdc", "cdddc", "ccccc"}, {"cc~cc", "cCCCc", "cCCCc", "cCCCc", "ccccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)49, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)49, (int)1)})).addElement('C', StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))).addElement('l', (IStructureElement)(LoaderReference.ProjRedIllumination ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ProjRed|Illumination:projectred.illumination.lamp"), (int)10) : StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Blocks.field_150379_bu, (int)0), StructureUtility.ofBlock((Block)Blocks.field_150374_bv, (int)0)}))).addElement('g', LoaderReference.Bartworks ? BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier) : StructureUtility.onElementPass(t -> {
        t.glasTier = (byte)100;
    }, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150359_w, (int)0))).addElement('d', StructureUtility.ofBlock((Block)(LoaderReference.RandomThings ? Block.func_149684_b((String)"RandomThings:fertilizedDirt_tilled") : Blocks.field_150458_ak), (int)0)).addElement('w', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Blocks.field_150355_j, (int)0), StructureUtility.ofBlock((Block)BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater), (int)0)})).build();
    private static final UIInfo<?, ?> GreenhouseUI = GT_MetaTileEntity_ExtremeIndustrialGreenhouse.createKTMetaTileEntityUI(KT_ModulaUIContainer_ExtremeIndustrialGreenhouse::new);
    DynamicInventory<GreenHouseSlot> dynamicInventory = new DynamicInventory<GreenHouseSlot>(128, 60, () -> this.mMaxSlots, this.mStorage, s -> s.input).allowInventoryInjection(this::addCrop).allowInventoryExtraction(this.mStorage::remove).allowInventoryReplace((i, stack) -> {
        if (!this.isIC2Mode) {
            GreenHouseSlot slot = this.mStorage.get(i);
            if (GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)slot.input)) {
                if (slot.input.field_77994_a < 64) {
                    slot.addAll(this.getBaseMetaTileEntity().getWorld(), stack);
                    return stack;
                }
                return null;
            }
            if (!this.addCrop(stack, i, true)) {
                return null;
            }
            slot = this.mStorage.remove(i);
            this.addCrop(stack, i, false);
            return slot.input;
        }
        if (stack.field_77994_a != 1) {
            return null;
        }
        if (!this.addCrop(stack, i, true)) {
            return null;
        }
        GreenHouseSlot slot = this.mStorage.remove(i);
        this.addCrop(stack, i, false);
        return slot.input;
    }).setEnabled(() -> this.mMaxProgresstime == 0);
    private boolean isInInventory = true;
    private HashMap<ItemStack, Double> GUIDropProgress = new HashMap();
    final Map<String, Double> dropprogress = new HashMap<String, Double>();

    public GT_MetaTileEntity_ExtremeIndustrialGreenhouse(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ExtremeIndustrialGreenhouse(String aName) {
        super(aName);
    }

    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.tryOutputAll(this.mStorage, s -> {
                ArrayList<ItemStack> l = new ArrayList<ItemStack>(2);
                l.add(((GreenHouseSlot)((Object)((Object)s))).input.func_77946_l());
                if (((GreenHouseSlot)((Object)((Object)s))).undercrop != null) {
                    l.add(((GreenHouseSlot)((Object)((Object)s))).undercrop.func_77946_l());
                }
                return l;
            });
        }
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You can't change IC2 mode if the machine is working!");
                return;
            }
            if (!this.mStorage.isEmpty()) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You can't change IC2 mode if there are seeds inside!");
                return;
            }
            this.isIC2Mode = !this.isIC2Mode;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("IC2 mode is now " + (this.isIC2Mode ? "enabled" : "disabled.")));
        } else {
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"You can't enable/disable setup if the machine is working!");
                return;
            }
            ++this.setupphase;
            if (this.setupphase == 3) {
                this.setupphase = 0;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("EIG is now running in " + (this.setupphase == 1 ? "setup mode (input)." : (this.setupphase == 2 ? "setup mode (output)." : "normal operation."))));
        }
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.isNoHumidity = !this.isNoHumidity;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Give incoming crops no humidity " + this.isNoHumidity));
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_ExtremeIndustrialGreenhouse(this.mName);
    }

    public IStructureDefinition<GT_MetaTileEntity_ExtremeIndustrialGreenhouse> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Crop Farm").addInfo("Controller block for the Extreme Industrial Greenhouse").addInfo(Variables.Author).addInfo("Grow your crops like a chad !").addInfo("Use screwdriver to enable/change/disable setup mode").addInfo("Use screwdriver while sneaking to enable/disable IC2 mode").addInfo("Use wire cutters to give incoming IC2 crops 0 humidity").addInfo("Uses 1000L of water per crop per operation").addInfo("If there are >= 1000 crops -> Uses 1L of Weed-EX 9000 per crop per second").addInfo("Otherwise, around 1% of crops will die each operation").addInfo("You can insert fertilizer each operation to get more drops (max +400%)").addInfo("-------------------- SETUP   MODE --------------------").addInfo("Does not take power").addInfo("There are two modes: input / output").addInfo("Input mode: machine will take seeds from input bus and plant them").addInfo("[IC2] You need to also input block that is required under the crop").addInfo("Output mode: machine will take planted seeds and output them").addInfo("-------------------- NORMAL CROPS --------------------").addInfo("Minimal tier: " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(4)).addInfo("Starting with 1 slot").addInfo("Every slot gives 64 crops").addInfo("Every tier past " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(4) + ", slots are multiplied by 2").addInfo("Base process time: 5 sec").addInfo("Process time is divided by number of tiers past " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(3) + " (Minimum 1 sec)").addInfo("All crops are grown at the end of the operation").addInfo("Will automatically craft seeds if they are not dropped").addInfo("1 Fertilizer per 1 crop +200%").addInfo("-------------------- IC2    CROPS --------------------").addInfo("Minimal tier: " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(6)).addInfo("Need " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(6) + " glass tier").addInfo("Starting with 4 slots").addInfo("Every slot gives 1 crop").addInfo("Every tier past " + GT_MetaTileEntity_ExtremeIndustrialGreenhouse.voltageTooltipFormatted(6) + ", slots are multiplied by 4").addInfo("Process time: 5 sec").addInfo("All crops are accelerated by x32 times").addInfo("1 Fertilizer per 1 crop +10%").addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(5, 6, 5, false).addController("Front bottom center").addCasingInfoMin("Clean Stainless Steel Casings", 70, false).addOtherStructurePart("Borosilicate Glass", "Hollow two middle layers").addStructureInfo("The glass tier limits the Energy Input tier").addStructureInfo("The dirt is from RandomThings, must be tilled").addStructureInfo("Regular water and IC2 Distilled Water are accepted").addStructureInfo("Purple lamps are from ProjectRedIllumination. They can be powered and/or inverted").addMaintenanceHatch("Any casing (Except inner bottom ones)", new int[]{1}).addInputBus("Any casing (Except inner bottom ones)", new int[]{1}).addOutputBus("Any casing (Except inner bottom ones)", new int[]{1}).addInputHatch("Any casing (Except inner bottom ones)", new int[]{1}).addEnergyHatch("Any casing (Except inner bottom ones)", new int[]{1}).toolTipFinisher("KubaTech");
        return tt;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getStructureDescription(stackSize)));
        info.add("The dirt is from RandomThings, must be tilled");
        info.add("Purple lamps are from ProjectRedIllumination. They can be powered and/or inverted");
        return info.toArray(new String[0]);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("EIG_MATH_VERSION", 0);
        aNBT.func_74774_a("glasTier", this.glasTier);
        aNBT.func_74768_a("setupphase", this.setupphase);
        aNBT.func_74757_a("isIC2Mode", this.isIC2Mode);
        aNBT.func_74757_a("isNoHumidity", this.isNoHumidity);
        aNBT.func_74768_a("mStorageSize", this.mStorage.size());
        for (int i = 0; i < this.mStorage.size(); ++i) {
            aNBT.func_74782_a("mStorage." + i, (NBTBase)this.mStorage.get(i).toNBTTagCompound());
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.oldVersion = aNBT.func_74764_b("EIG_MATH_VERSION") ? aNBT.func_74762_e("EIG_MATH_VERSION") : -1;
        this.glasTier = aNBT.func_74771_c("glasTier");
        this.setupphase = aNBT.func_74762_e("setupphase");
        this.isIC2Mode = aNBT.func_74767_n("isIC2Mode");
        this.isNoHumidity = aNBT.func_74767_n("isNoHumidity");
        for (int i = 0; i < aNBT.func_74762_e("mStorageSize"); ++i) {
            this.mStorage.add(new GreenHouseSlot(aNBT.func_74775_l("mStorage." + i)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnVisualCrops(World world, int x, int y, int z, int age) {
        CropRenderer crop = new CropRenderer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)crop);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            int[] abc = new int[]{0, -2, 2};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + aBaseMetaTileEntity.getXCoord();
            xyz[1] = xyz[1] + aBaseMetaTileEntity.getYCoord();
            xyz[2] = xyz[2] + aBaseMetaTileEntity.getZCoord();
            this.spawnVisualCrops(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], 40);
        }
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 5, 0);
    }

    private void updateMaxSlots() {
        int tier = this.getVoltageTier();
        this.mMaxSlots = tier < (this.isIC2Mode ? 6 : 4) ? 0 : (this.isIC2Mode ? 4 << 2 * (tier - 6) : 1 << tier - 4);
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        int tier = this.getVoltageTier();
        this.updateMaxSlots();
        if (this.oldVersion != 0) {
            for (GreenHouseSlot greenHouseSlot : this.mStorage) {
                greenHouseSlot.recalculate(this, this.getBaseMetaTileEntity().getWorld());
            }
            this.oldVersion = 0;
        }
        if (this.setupphase > 0) {
            if (this.mStorage.size() >= this.mMaxSlots && this.setupphase == 1 || this.mStorage.size() == 0 && this.setupphase == 2) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            if (this.setupphase == 1) {
                ArrayList inputs = this.getStoredInputs();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    ItemStack input = (ItemStack)iterator.next();
                    this.addCrop(input);
                    if (this.mStorage.size() < this.mMaxSlots) continue;
                    break;
                }
            } else if (this.setupphase == 2) {
                this.tryOutputAll(this.mStorage, s -> {
                    ArrayList<ItemStack> l = new ArrayList<ItemStack>(2);
                    l.add(((GreenHouseSlot)((Object)((Object)((Object)s)))).input.func_77946_l());
                    if (((GreenHouseSlot)((Object)((Object)((Object)s)))).undercrop != null) {
                        l.add(((GreenHouseSlot)((Object)((Object)((Object)s)))).undercrop.func_77946_l());
                    }
                    return l;
                });
            }
            this.updateSlots();
            this.mMaxProgresstime = 5;
            this.lEUt = 0L;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        if (this.mStorage.size() > this.mMaxSlots) {
            return SimpleCheckRecipeResult.ofFailure((String)"EIG_slotoverflow");
        }
        if (this.mStorage.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.waterusage = 0;
        this.weedexusage = 0;
        for (GreenHouseSlot greenHouseSlot : this.mStorage) {
            this.waterusage += greenHouseSlot.input.field_77994_a;
        }
        if (this.waterusage >= 1000) {
            this.weedexusage = this.waterusage;
        }
        this.waterusage *= 1000;
        ArrayList fluids = this.mInputHatches;
        ArrayList<GT_MetaTileEntity_Hatch_Input> arrayList = new ArrayList<GT_MetaTileEntity_Hatch_Input>(fluids.size());
        int watercheck = this.waterusage;
        FluidStack waterStack = new FluidStack(FluidRegistry.WATER, 1);
        for (GT_MetaTileEntity_Hatch_Input i : fluids) {
            if (!i.isValid()) continue;
            if (i instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                int amount = ((GT_MetaTileEntity_Hatch_MultiInput)i).getFluidAmount(waterStack);
                if (amount == 0) continue;
                watercheck -= amount;
            } else {
                FluidStack stack = i.getDrainableStack();
                if (stack == null || !stack.isFluidEqual(waterStack) || stack.amount <= 0) continue;
                watercheck -= stack.amount;
            }
            arrayList.add(i);
            if (watercheck > 0) continue;
            break;
        }
        if (watercheck > 0) {
            return SimpleCheckRecipeResult.ofFailure((String)"EIG_missingwater");
        }
        watercheck = this.waterusage;
        for (GT_MetaTileEntity_Hatch_Input i : arrayList) {
            int used = i.drain((int)watercheck, (boolean)true).amount;
            watercheck -= used;
        }
        if (this.weedexusage > 0 && !this.depleteInput(new FluidStack(weedex, this.isIC2Mode ? this.weedexusage * 5 : this.weedexusage))) {
            GreenHouseSlot removed;
            IGregTechTileEntity baseMTE = this.getBaseMetaTileEntity();
            for (int toKill = baseMTE.getRandomNumber((int)((double)this.weedexusage * 0.02) + 1); toKill > 0; toKill -= removed.input.field_77994_a) {
                removed = this.mStorage.remove(baseMTE.getRandomNumber(this.mStorage.size()));
            }
        }
        int boost = 0;
        int maxboost = 0;
        for (GreenHouseSlot greenHouseSlot : this.mStorage) {
            maxboost += greenHouseSlot.input.field_77994_a * (this.isIC2Mode ? 40 : 2);
        }
        ArrayList inputs = this.getStoredInputs();
        for (ItemStack i : inputs) {
            if (i.func_77973_b() == Items.field_151100_aR && i.func_77960_j() == 15 || forestryfertilizer != null && i.func_77973_b() == forestryfertilizer || GT_Utility.areStacksEqual((ItemStack)i, (ItemStack)Ic2Items.fertilizer)) {
                int used = Math.min(i.field_77994_a, maxboost - boost);
                i.field_77994_a -= used;
                boost += used;
            }
            if (boost != maxboost) continue;
            break;
        }
        double d = 1.0 + (double)boost / (double)maxboost * 4.0;
        if (this.isIC2Mode) {
            if (this.glasTier < 6) {
                return SimpleCheckRecipeResult.ofFailure((String)"EIG_ic2glass");
            }
            this.mMaxProgresstime = 100;
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < Math.min(this.mMaxSlots, this.mStorage.size()); ++i) {
                outputs.addAll(this.mStorage.get(i).getIC2Drops(this, (double)this.mMaxProgresstime * 32.0 * d));
            }
            this.mOutputItems = outputs.toArray(new ItemStack[0]);
        } else {
            this.mMaxProgresstime = Math.max(20, 100 / (tier - 3));
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (int i = 0; i < Math.min(this.mMaxSlots, this.mStorage.size()); ++i) {
                for (ItemStack drop : this.mStorage.get(i).getDrops()) {
                    ItemStack s4 = drop.func_77946_l();
                    s4.field_77994_a = (int)((double)s4.field_77994_a * d);
                    outputs.add(s4);
                }
            }
            this.mOutputItems = outputs.toArray(new ItemStack[0]);
        }
        this.lEUt = -((int)((double)GT_Values.V[tier] * 0.99));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        boolean valid;
        this.mCasing = 0;
        this.glasTier = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 5, 0)) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        boolean bl = valid = this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() >= 1 && this.mCasing >= 70;
        if (valid) {
            this.updateMaxSlots();
        }
        return valid;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        GreenhouseUI.open(aPlayer, aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
        return true;
    }

    @Override
    protected void addConfigurationWidgets(DynamicPositionedRow configurationElements, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(999, this::createConfigurationWindow);
        configurationElements.setSynced(false);
        configurationElements.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(999);
            }
        }).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_CYCLIC}).addTooltip("Configuration").setSize(16, 16));
    }

    @Override
    public void createInventorySlots() {
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.isInInventory = !this.getBaseMetaTileEntity().isActive();
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(190, 85).setEnabled(w -> !this.isInInventory));
        builder.widget(this.dynamicInventory.asWidget(builder, buildContext).setPos(10, 16).setBackground(new IDrawable[]{new Rectangle().setColor(Color.rgb((int)163, (int)163, (int)198))}).setEnabled(w -> this.isInInventory));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.isInInventory, i -> {
            this.isInInventory = i;
        }).setTextureGetter(i -> i == 0 ? new Text("Inventory") : new Text("Status")).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(140, 4).setSize(55, 16));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, null);
        builder.widget(screenElements.setEnabled(w -> !this.isInInventory));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)this.createPowerSwitchButton((IWidgetBuilder)builder))).widget((Widget)this.createVoidExcessButton((IWidgetBuilder)builder))).widget((Widget)this.createInputSeparationButton((IWidgetBuilder)builder))).widget((Widget)this.createBatchModeButton((IWidgetBuilder)builder))).widget((Widget)this.createLockToSingleRecipeButton((IWidgetBuilder)builder));
        DynamicPositionedRow configurationElements = new DynamicPositionedRow();
        this.addConfigurationWidgets(configurationElements, buildContext);
        builder.widget(configurationElements.setSpace(2).setAlignment(MainAxisAlignment.SPACE_BETWEEN).setPos(this.getRecipeLockingButtonPos().add(18, 0)));
    }

    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)100);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setPos(5, 5).setSize(16, 16))).widget(new TextWidget("Configuration").setPos(25, 9))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(((Column)((Column)((Column)new Column().widget(new CycleButtonWidget().setLength(3).setGetter(() -> this.setupphase).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"You can't enable/disable setup if the machine is working!");
                return;
            }
            this.setupphase = val;
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)("EIG is now running in " + (this.setupphase == 1 ? "setup mode (input)." : (this.setupphase == 2 ? "setup mode (output)." : "normal operation."))));
        }).addTooltip(0, new Text("Operating").color(Color.GREEN.dark(3))).addTooltip(1, new Text("Input").color(Color.YELLOW.dark(3))).addTooltip(2, new Text("Output").color(Color.YELLOW.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Operating").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : (i == 1 ? new Text("Input").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Output").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f))).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GT_UITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("Setup mode"))).widget(new CycleButtonWidget().setLength(2).setGetter(() -> this.isIC2Mode ? 1 : 0).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (this.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"You can't change IC2 mode if the machine is working!");
                return;
            }
            if (!this.mStorage.isEmpty()) {
                GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)"You can't change IC2 mode if there are seeds inside!");
                return;
            }
            this.isIC2Mode = val == 1;
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)("IC2 mode is now " + (this.isIC2Mode ? "enabled" : "disabled.")));
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Disabled").color(Color.RED.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Enabled").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GT_UITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("IC2 mode"))).widget(new CycleButtonWidget().setLength(2).setGetter(() -> this.isNoHumidity ? 1 : 0).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            this.isNoHumidity = val == 1;
            GT_Utility.sendChatToPlayer((EntityPlayer)player, (String)("Give incoming crops no humidity " + this.isNoHumidity));
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Disabled").color(Color.RED.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Enabled").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GT_UITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("No Humidity mode"))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(10, 30))).widget(((Column)((Column)((Column)new Column().widget(new TextWidget("Setup mode").setSize(100, 18))).widget(new TextWidget("IC2 mode").setSize(100, 18))).widget(new TextWidget("No Humidity mode").setSize(100, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(80, 30))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).setPos(10, 30).addTooltip(new Text("Can't change configuration when running !").color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()));
        return builder.build();
    }

    protected String generateCurrentRecipeInfoString() {
        if (!this.isIC2Mode) {
            return super.generateCurrentRecipeInfoString();
        }
        StringBuilder ret = new StringBuilder(EnumChatFormatting.WHITE + "Progress: ").append(String.format("%,.2f", (double)this.mProgresstime / 20.0)).append("s / ").append(String.format("%,.2f", (double)this.mMaxProgresstime / 20.0)).append("s (").append(String.format("%,.1f", (double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0)).append("%)\n");
        for (Map.Entry<ItemStack, Double> drop : this.GUIDropProgress.entrySet()) {
            ret.append(drop.getKey().func_82833_r()).append(": ").append(String.format("%.2f (+%d)\n", drop.getValue(), Arrays.stream(this.mOutputItems).filter(s -> s.func_77969_a((ItemStack)drop.getKey())).mapToInt(i -> i.field_77994_a).sum()));
        }
        return ret.toString();
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.isIC2Mode, b -> {
            this.isIC2Mode = b;
        }));
        screenElements.widget((Widget)new FakeSyncWidget(() -> {
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>();
            HashMap<String, Double> dropProgress = new HashMap<String, Double>();
            for (Map.Entry<String, Double> entry : this.dropprogress.entrySet()) {
                dropProgress.merge(entry.getKey(), entry.getValue(), Double::sum);
            }
            for (Map.Entry<String, Double> entry : dropProgress.entrySet()) {
                ret.put(GreenHouseSlot.dropstacks.get(entry.getKey()), entry.getValue());
            }
            return ret;
        }, h -> {
            this.GUIDropProgress = h;
        }, (buffer, h) -> {
            buffer.func_150787_b(h.size());
            for (Map.Entry itemStackDoubleEntry : h.entrySet()) {
                try {
                    buffer.func_150788_a((ItemStack)itemStackDoubleEntry.getKey());
                    buffer.writeDouble(((Double)itemStackDoubleEntry.getValue()).doubleValue());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, buffer -> {
            int len = buffer.func_150792_a();
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>(len);
            for (int i = 0; i < len; ++i) {
                try {
                    ret.put(buffer.func_150791_c(), buffer.readDouble());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }));
        super.drawTexts(screenElements, inventorySlot);
    }

    public String[] getInfoData() {
        String[] stringArray = new String[5];
        stringArray[0] = "Running in mode: " + EnumChatFormatting.GREEN + (this.setupphase == 0 ? (this.isIC2Mode ? "IC2 crops" : "Normal crops") : "Setup mode " + (this.setupphase == 1 ? "(input)" : "(output)")) + EnumChatFormatting.RESET;
        stringArray[1] = "Uses " + this.waterusage + "L/operation of water";
        stringArray[2] = "Uses " + this.weedexusage + "L/second of Weed-EX 9000";
        stringArray[3] = "Max slots: " + EnumChatFormatting.GREEN + this.mMaxSlots + EnumChatFormatting.RESET;
        stringArray[4] = "Used slots: " + (this.mStorage.size() > this.mMaxSlots ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + this.mStorage.size() + EnumChatFormatting.RESET;
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(stringArray));
        HashMap<String, Integer> storageList = new HashMap<String, Integer>();
        for (GreenHouseSlot greenHouseSlot : this.mStorage) {
            if (!greenHouseSlot.isValid) continue;
            StringBuilder a = new StringBuilder(EnumChatFormatting.GREEN + "x" + greenHouseSlot.input.field_77994_a + " " + greenHouseSlot.input.func_82833_r());
            if (this.isIC2Mode) {
                a.append(" | Humidity: ").append(greenHouseSlot.noHumidity ? 0 : 12);
            }
            a.append(EnumChatFormatting.RESET);
            storageList.merge(a.toString(), 1, Integer::sum);
        }
        storageList.forEach((k, v) -> info.add("x" + v + " " + k));
        if (this.mStorage.size() > this.mMaxSlots) {
            info.add(EnumChatFormatting.DARK_RED + "There are too many crops inside to run !" + EnumChatFormatting.RESET);
        }
        info.addAll(Arrays.asList(super.getInfoData()));
        return info.toArray(new String[0]);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    private boolean addCrop(ItemStack input, int slot, boolean simulate) {
        if (!this.isIC2Mode && !simulate) {
            for (GreenHouseSlot g : this.mStorage) {
                if (g.input.field_77994_a >= 64 || !GT_Utility.areStacksEqual((ItemStack)g.input, (ItemStack)input)) continue;
                g.addAll(this.getBaseMetaTileEntity().getWorld(), input);
                if (input.field_77994_a != 0) continue;
                return true;
            }
        }
        GreenHouseSlot h = new GreenHouseSlot(this, simulate ? input.func_77946_l() : input, this.isIC2Mode, this.isNoHumidity);
        if (h.isValid) {
            if (!simulate) {
                if (slot == -1) {
                    this.mStorage.add(h);
                } else {
                    this.mStorage.add(slot, h);
                }
            }
            return true;
        }
        return false;
    }

    private ItemStack addCrop(ItemStack input) {
        if (this.addCrop(input, -1, false)) {
            return input;
        }
        return null;
    }

    private static class GreenHouseRandom
    extends Random {
        private static final long serialVersionUID = -387271808935248890L;

        private GreenHouseRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }

    private static class GreenHouseWorld
    extends GT_DummyWorld {
        public int x;
        public int y;
        public int z;
        public int meta = 0;
        public Block block;

        GreenHouseWorld(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.field_73012_v = new GreenHouseRandom();
        }

        public int func_72805_g(int aX, int aY, int aZ) {
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return 7;
            }
            return 0;
        }

        public Block func_147439_a(int aX, int aY, int aZ) {
            if (aY == this.y - 1) {
                return Blocks.field_150458_ak;
            }
            return Blocks.field_150350_a;
        }

        public int func_72957_l(int p_72957_1_, int p_72957_2_, int p_72957_3_) {
            return 10;
        }

        public boolean func_147465_d(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
            if (aBlock == Blocks.field_150350_a) {
                return false;
            }
            if (aX == this.x && aY == this.y && aZ == this.z) {
                return false;
            }
            this.block = aBlock;
            this.meta = aMeta;
            return true;
        }
    }

    private static class GreenHouseSlot
    extends InventoryCrafting {
        final ItemStack input;
        Block crop;
        ArrayList<ItemStack> customDrops = null;
        ItemStack undercrop = null;
        List<ItemStack> drops;
        boolean isValid;
        boolean isIC2Crop;
        boolean noHumidity;
        int growthticks;
        List<List<ItemStack>> generations;
        Random rn;
        IRecipe recipe;
        ItemStack recipeInput;
        int optimalgrowth = 7;
        boolean needsreplanting = true;
        static final GreenHouseWorld fakeworld = new GreenHouseWorld(5, 5, 5);
        static final Map<String, ItemStack> dropstacks = new HashMap<String, ItemStack>();

        public NBTTagCompound toNBTTagCompound() {
            NBTTagCompound aNBT = new NBTTagCompound();
            aNBT.func_74782_a("input", (NBTBase)ItemUtils.writeItemStackToNBT(this.input));
            aNBT.func_74757_a("isValid", this.isValid);
            aNBT.func_74757_a("isIC2Crop", this.isIC2Crop);
            if (!this.isIC2Crop) {
                int i;
                aNBT.func_74768_a("crop", Block.func_149682_b((Block)this.crop));
                if (this.customDrops != null && this.customDrops.size() > 0) {
                    aNBT.func_74768_a("customDropsCount", this.customDrops.size());
                    for (i = 0; i < this.customDrops.size(); ++i) {
                        aNBT.func_74782_a("customDrop." + i, (NBTBase)ItemUtils.writeItemStackToNBT(this.customDrops.get(i)));
                    }
                }
                aNBT.func_74768_a("dropscount", this.drops.size());
                for (i = 0; i < this.drops.size(); ++i) {
                    aNBT.func_74782_a("drop." + i, (NBTBase)ItemUtils.writeItemStackToNBT(this.drops.get(i)));
                }
                aNBT.func_74768_a("optimalgrowth", this.optimalgrowth);
                aNBT.func_74757_a("needsreplanting", this.needsreplanting);
            } else {
                if (this.undercrop != null) {
                    aNBT.func_74782_a("undercrop", (NBTBase)ItemUtils.writeItemStackToNBT(this.undercrop));
                }
                aNBT.func_74768_a("generationscount", this.generations.size());
                for (int i = 0; i < this.generations.size(); ++i) {
                    aNBT.func_74768_a("generation." + i + ".count", this.generations.get(i).size());
                    for (int j = 0; j < this.generations.get(i).size(); ++j) {
                        aNBT.func_74782_a("generation." + i + "." + j, (NBTBase)ItemUtils.writeItemStackToNBT(this.generations.get(i).get(j)));
                    }
                }
                aNBT.func_74768_a("growthticks", this.growthticks);
                aNBT.func_74757_a("noHumidity", this.noHumidity);
            }
            return aNBT;
        }

        public GreenHouseSlot(NBTTagCompound aNBT) {
            super(null, 3, 3);
            this.isIC2Crop = aNBT.func_74767_n("isIC2Crop");
            this.isValid = aNBT.func_74767_n("isValid");
            this.input = ItemUtils.readItemStackFromNBT(aNBT.func_74775_l("input"));
            if (!this.isIC2Crop) {
                this.crop = Block.func_149729_e((int)aNBT.func_74762_e("crop"));
                if (aNBT.func_74764_b("customDropsCount")) {
                    int imax = aNBT.func_74762_e("customDropsCount");
                    this.customDrops = new ArrayList(imax);
                    for (int i = 0; i < imax; ++i) {
                        this.customDrops.add(ItemUtils.readItemStackFromNBT(aNBT.func_74775_l("customDrop." + i)));
                    }
                }
                this.drops = new ArrayList<ItemStack>();
                for (int i = 0; i < aNBT.func_74762_e("dropscount"); ++i) {
                    this.drops.add(ItemUtils.readItemStackFromNBT(aNBT.func_74775_l("drop." + i)));
                }
                this.optimalgrowth = aNBT.func_74762_e("optimalgrowth");
                if (this.optimalgrowth == 0) {
                    this.optimalgrowth = 7;
                }
                if (aNBT.func_74764_b("needsreplanting")) {
                    this.needsreplanting = aNBT.func_74767_n("needsreplanting");
                }
            } else {
                if (aNBT.func_74764_b("undercrop")) {
                    this.undercrop = ItemUtils.readItemStackFromNBT(aNBT.func_74775_l("undercrop"));
                }
                this.generations = new ArrayList<List<ItemStack>>();
                for (int i = 0; i < aNBT.func_74762_e("generationscount"); ++i) {
                    this.generations.add(new ArrayList());
                    for (int j = 0; j < aNBT.func_74762_e("generation." + i + ".count"); ++j) {
                        this.generations.get(i).add(ItemUtils.readItemStackFromNBT(aNBT.func_74775_l("generation." + i + "." + j)));
                    }
                }
                this.growthticks = aNBT.func_74762_e("growthticks");
                this.noHumidity = aNBT.func_74767_n("noHumidity");
                this.rn = new Random();
            }
        }

        public boolean addAll(World world, ItemStack input) {
            if (!GT_Utility.areStacksEqual((ItemStack)this.input, (ItemStack)input)) {
                return false;
            }
            if (this.input.field_77994_a == 64) {
                return false;
            }
            int toconsume = Math.min(64 - this.input.field_77994_a, input.field_77994_a);
            int left = this.addDrops(world, toconsume);
            input.field_77994_a -= toconsume - left;
            this.input.field_77994_a += toconsume - left;
            return left == 0;
        }

        public boolean findCropRecipe(World world) {
            if (this.recipe != null) {
                return true;
            }
            Iterator<ItemStack> iterator = this.drops.iterator();
            block0: while (iterator.hasNext()) {
                ItemStack drop;
                this.recipeInput = drop = iterator.next();
                for (int j = 0; j < CraftingManager.func_77594_a().func_77592_b().size(); ++j) {
                    this.recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(j);
                    if (this.recipe.func_77569_a((InventoryCrafting)this, world) && GT_Utility.areStacksEqual((ItemStack)this.recipe.func_77572_b((InventoryCrafting)this), (ItemStack)this.input)) break block0;
                    this.recipe = null;
                }
            }
            return this.recipe != null;
        }

        public ItemStack func_70301_a(int p_70301_1_) {
            if (p_70301_1_ == 0) {
                return this.recipeInput.func_77946_l();
            }
            return null;
        }

        public ItemStack func_70304_b(int par1) {
            return null;
        }

        public ItemStack func_70298_a(int par1, int par2) {
            return null;
        }

        public void func_70299_a(int par1, ItemStack par2ItemStack) {
        }

        public GreenHouseSlot(GT_MetaTileEntity_ExtremeIndustrialGreenhouse tileEntity, ItemStack input, boolean IC2, boolean noHumidity) {
            super(null, 3, 3);
            World world = tileEntity.getBaseMetaTileEntity().getWorld();
            this.input = input.func_77946_l();
            this.isValid = false;
            if (IC2) {
                this.GreenHouseSlotIC2(tileEntity, world, input, noHumidity);
                return;
            }
            Item i = input.func_77973_b();
            Block b = null;
            boolean detectedCustomHandler = false;
            Block bb = Block.func_149634_a((Item)i);
            if (bb == Blocks.field_150350_a) {
                bb = null;
            }
            if (bb instanceof BlockFlower) {
                detectedCustomHandler = true;
                this.needsreplanting = false;
                this.customDrops = new ArrayList<ItemStack>(Collections.singletonList(input.func_77946_l()));
                this.customDrops.get((int)0).field_77994_a = 1;
            }
            if (!detectedCustomHandler) {
                if (i instanceof IPlantable) {
                    if (i instanceof ItemSeeds) {
                        b = ((ItemSeeds)i).getPlant((IBlockAccess)world, 0, 0, 0);
                    } else if (i instanceof ItemSeedFood) {
                        b = ((ItemSeedFood)i).getPlant((IBlockAccess)world, 0, 0, 0);
                    }
                } else {
                    if (i == Items.field_151120_aE) {
                        b = Blocks.field_150436_aH;
                    } else {
                        b = Block.func_149634_a((Item)i);
                        if (b != Blocks.field_150434_aF) {
                            return;
                        }
                    }
                    this.needsreplanting = false;
                }
                if (!(b instanceof IPlantable)) {
                    return;
                }
                GameRegistry.UniqueIdentifier u = GameRegistry.findUniqueIdentifierFor((Item)i);
                if (u != null && Objects.equals(u.modId, "Natura")) {
                    this.optimalgrowth = 8;
                }
                if (b instanceof BlockStem) {
                    GreenHouseSlot.fakeworld.block = null;
                    try {
                        b.func_149674_a((World)fakeworld, 5, 5, 5, GreenHouseSlot.fakeworld.field_73012_v);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    if (GreenHouseSlot.fakeworld.block == null) {
                        return;
                    }
                    b = GreenHouseSlot.fakeworld.block;
                    this.needsreplanting = false;
                }
            }
            this.crop = b;
            this.isIC2Crop = false;
            int toUse = Math.min(64, input.field_77994_a);
            if (this.addDrops(world, toUse) == 0 && !this.drops.isEmpty()) {
                input.field_77994_a -= toUse;
                this.input.field_77994_a = toUse;
                this.isValid = true;
            }
        }

        public void GreenHouseSlotIC2(GT_MetaTileEntity_ExtremeIndustrialGreenhouse tileEntity, World world, ItemStack input, boolean noHumidity) {
            if (!ItemList.IC2_Crop_Seeds.isStackEqual((Object)input, true, true)) {
                return;
            }
            this.isIC2Crop = true;
            this.noHumidity = noHumidity;
            this.recalculate(tileEntity, world);
            if (this.isValid) {
                --input.field_77994_a;
            }
        }

        private boolean setBlock(ItemStack a, int x, int y, int z, World world) {
            Item item = a.func_77973_b();
            Block b = Block.func_149634_a((Item)item);
            if (b == Blocks.field_150350_a || !(item instanceof ItemBlock)) {
                return false;
            }
            short tDamage = (short)item.getDamage(a);
            if (item instanceof GT_Item_Ores && tDamage > 0) {
                if (!world.func_147465_d(x, y, z, b, (int)GT_TileEntity_Ores.getHarvestData((short)tDamage, (int)((GT_Block_Ores_Abstract)b).getBaseBlockHarvestLevel(tDamage % 16000 / 1000)), 0)) {
                    return false;
                }
                GT_TileEntity_Ores tTileEntity = (GT_TileEntity_Ores)world.func_147438_o(x, y, z);
                tTileEntity.mMetaData = tDamage;
                tTileEntity.mNatural = false;
            } else {
                world.func_147465_d(x, y, z, b, (int)tDamage, 0);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recalculate(GT_MetaTileEntity_ExtremeIndustrialGreenhouse tileEntity, World world) {
            if (this.isIC2Crop) {
                CropCard cc = Crops.instance.getCropCard(this.input);
                this.input.field_77994_a = 1;
                NBTTagCompound nbt = this.input.func_77978_p();
                byte gr = nbt.func_74771_c("growth");
                byte ga = nbt.func_74771_c("gain");
                byte re = nbt.func_74771_c("resistance");
                int[] abc = new int[]{0, -2, 3};
                int[] xyz = new int[]{0, 0, 0};
                tileEntity.getExtendedFacing().getWorldOffset(abc, xyz);
                xyz[0] = xyz[0] + tileEntity.getBaseMetaTileEntity().getXCoord();
                xyz[1] = xyz[1] + tileEntity.getBaseMetaTileEntity().getYCoord();
                xyz[2] = xyz[2] + tileEntity.getBaseMetaTileEntity().getZCoord();
                boolean cheating = false;
                try {
                    if (world.func_147439_a(xyz[0], xyz[1] - 2, xyz[2]) != GregTech_API.sBlockCasings4 || world.func_72805_g(xyz[0], xyz[1] - 2, xyz[2]) != 1) {
                        cheating = true;
                        return;
                    }
                    world.func_147465_d(xyz[0], xyz[1], xyz[2], Block.func_149634_a((Item)Ic2Items.crop.func_77973_b()), 0, 0);
                    TileEntity wte = world.func_147438_o(xyz[0], xyz[1], xyz[2]);
                    if (!(wte instanceof TileEntityCrop)) {
                        return;
                    }
                    TileEntityCrop te = (TileEntityCrop)wte;
                    te.ticker = '\u0001';
                    te.setCrop(cc);
                    te.setGrowth(gr);
                    te.setGain(ga);
                    te.setResistance(re);
                    ItemStack tobeused = null;
                    if (this.undercrop != null) {
                        this.setBlock(this.undercrop, xyz[0], xyz[1] - 2, xyz[2], world);
                    } else {
                        te.setSize((byte)(cc.maxSize() - 1));
                        if (!cc.canGrow((ICropTile)te)) {
                            boolean cangrow = false;
                            ArrayList inputs = tileEntity.getStoredInputs();
                            for (ItemStack a : inputs) {
                                if (a.field_77994_a <= 0 || !this.setBlock(a, xyz[0], xyz[1] - 2, xyz[2], world) || !cc.canGrow((ICropTile)te)) continue;
                                cangrow = true;
                                this.undercrop = a.func_77946_l();
                                this.undercrop.field_77994_a = 1;
                                tobeused = a;
                                break;
                            }
                            if (!cangrow) {
                                return;
                            }
                        }
                    }
                    te.setSize((byte)cc.maxSize());
                    if (!cc.canBeHarvested((ICropTile)te)) {
                        return;
                    }
                    this.generations = new ArrayList<List<ItemStack>>();
                    block12: for (int i = 0; i < 10; ++i) {
                        ItemStack[] st = te.harvest_automated(false);
                        te.setSize((byte)cc.maxSize());
                        if (st == null || st.length == 0) continue;
                        for (ItemStack s : st) {
                            if (s == null) continue block12;
                        }
                        this.generations.add(new ArrayList<ItemStack>(Arrays.asList(st)));
                    }
                    if (this.generations.isEmpty()) {
                        return;
                    }
                    this.rn = new Random();
                    te.humidity = (byte)(this.noHumidity ? 0 : 12);
                    te.airQuality = (byte)6;
                    te.nutrients = (byte)8;
                    int dur = cc.growthDuration((ICropTile)te);
                    int rate = te.calcGrowthRate();
                    if (rate == 0) {
                        return;
                    }
                    this.growthticks = (int)Math.ceil((double)dur / (double)rate * (double)cc.maxSize() * (double)TileEntityCrop.tickRate);
                    if (this.growthticks < 1) {
                        this.growthticks = 1;
                    }
                    if (tobeused != null) {
                        --tobeused.field_77994_a;
                    }
                    this.isValid = true;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                finally {
                    if (!cheating) {
                        world.func_147465_d(xyz[0], xyz[1] - 2, xyz[2], GregTech_API.sBlockCasings4, 1, 0);
                    }
                    world.func_147468_f(xyz[0], xyz[1], xyz[2]);
                }
            } else {
                this.drops = new ArrayList<ItemStack>();
                this.addDrops(world, this.input.field_77994_a);
            }
        }

        public List<ItemStack> getDrops() {
            return this.drops;
        }

        public List<ItemStack> getIC2Drops(GT_MetaTileEntity_ExtremeIndustrialGreenhouse tileEntity, double timeelapsed) {
            int r = this.rn.nextInt(10);
            if (this.generations.size() <= r) {
                return new ArrayList<ItemStack>();
            }
            double growthPercent = timeelapsed / (double)this.growthticks;
            List<ItemStack> generation = this.generations.get(r);
            ArrayList<ItemStack> copied = new ArrayList<ItemStack>();
            for (ItemStack itemStack : generation) {
                copied.add(itemStack.func_77946_l());
            }
            for (ItemStack itemStack : copied) {
                double pro = (double)itemStack.field_77994_a * growthPercent;
                itemStack.field_77994_a = 1;
                tileEntity.dropprogress.merge(itemStack.toString(), pro, Double::sum);
                if (dropstacks.containsKey(itemStack.toString())) continue;
                dropstacks.put(itemStack.toString(), itemStack.func_77946_l());
            }
            copied.clear();
            for (Map.Entry entry : tileEntity.dropprogress.entrySet()) {
                if (!((Double)entry.getValue() >= 1.0)) continue;
                copied.add(dropstacks.get(entry.getKey()).func_77946_l());
                ((ItemStack)copied.get((int)(copied.size() - 1))).field_77994_a = ((Double)entry.getValue()).intValue();
                entry.setValue((Double)entry.getValue() - (double)((Double)entry.getValue()).intValue());
            }
            return copied;
        }

        public int addDrops(World world, int count) {
            int i;
            if (this.drops == null) {
                this.drops = new ArrayList<ItemStack>();
            }
            if (this.customDrops != null && this.customDrops.size() > 0) {
                ArrayList d = (ArrayList)this.customDrops.clone();
                for (ItemStack x : this.drops) {
                    Iterator iterator = d.iterator();
                    while (iterator.hasNext()) {
                        ItemStack y = (ItemStack)iterator.next();
                        if (!GT_Utility.areStacksEqual((ItemStack)x, (ItemStack)y)) continue;
                        x.field_77994_a += y.field_77994_a * count;
                        iterator.remove();
                    }
                }
                int finalCount = count;
                d.forEach(stack -> {
                    ItemStack i = stack.func_77946_l();
                    i.field_77994_a *= finalCount;
                    this.drops.add(i);
                });
                return 0;
            }
            if (this.crop == null) {
                return count;
            }
            for (i = 0; i < count; ++i) {
                ArrayList d = this.crop.getDrops(world, 0, 0, 0, this.optimalgrowth, 0);
                for (ItemStack x : this.drops) {
                    for (ItemStack y : d) {
                        if (!GT_Utility.areStacksEqual((ItemStack)x, (ItemStack)y)) continue;
                        x.field_77994_a += y.field_77994_a;
                        y.field_77994_a = 0;
                    }
                }
                for (ItemStack x : d) {
                    if (x.field_77994_a <= 0) continue;
                    this.drops.add(x.func_77946_l());
                }
            }
            if (!this.needsreplanting) {
                return 0;
            }
            for (i = 0; i < this.drops.size(); ++i) {
                if (!GT_Utility.areStacksEqual((ItemStack)this.drops.get(i), (ItemStack)this.input)) continue;
                int took = Math.min(this.drops.get((int)i).field_77994_a, count);
                this.drops.get((int)i).field_77994_a -= took;
                count -= took;
                if (this.drops.get((int)i).field_77994_a == 0) {
                    this.drops.remove(i);
                    --i;
                }
                if (count != 0) continue;
                return 0;
            }
            if (!this.findCropRecipe(world)) {
                return count;
            }
            int totake = count / this.recipe.func_77572_b((InventoryCrafting)this).field_77994_a + 1;
            for (int i2 = 0; i2 < this.drops.size(); ++i2) {
                if (!GT_Utility.areStacksEqual((ItemStack)this.drops.get(i2), (ItemStack)this.recipeInput)) continue;
                int took = Math.min(this.drops.get((int)i2).field_77994_a, totake);
                this.drops.get((int)i2).field_77994_a -= took;
                totake -= took;
                if (this.drops.get((int)i2).field_77994_a == 0) {
                    this.drops.remove(i2);
                    --i2;
                }
                if (totake != 0) continue;
                return 0;
            }
            return count;
        }
    }

    private static class KT_ModulaUIContainer_ExtremeIndustrialGreenhouse
    extends ModularUIContainer {
        final WeakReference<GT_MetaTileEntity_ExtremeIndustrialGreenhouse> parent;

        public KT_ModulaUIContainer_ExtremeIndustrialGreenhouse(ModularUIContext context, ModularWindow mainWindow, GT_MetaTileEntity_ExtremeIndustrialGreenhouse mte) {
            super(context, mainWindow);
            this.parent = new WeakReference<GT_MetaTileEntity_ExtremeIndustrialGreenhouse>(mte);
        }

        public ItemStack func_82846_b(EntityPlayer aPlayer, int aSlotIndex) {
            if (!(aPlayer instanceof EntityPlayerMP)) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            Slot s = this.func_75139_a(aSlotIndex);
            if (s == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (aSlotIndex >= 36) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            ItemStack aStack = s.func_75211_c();
            if (aStack == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            GT_MetaTileEntity_ExtremeIndustrialGreenhouse mte = (GT_MetaTileEntity_ExtremeIndustrialGreenhouse)((Object)this.parent.get());
            if (mte == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.mStorage.size() >= mte.mMaxSlots) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.mMaxProgresstime > 0) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(EnumChatFormatting.RED + "Can't insert while running !"));
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.addCrop(aStack) != null) {
                if (aStack.field_77994_a == 0) {
                    s.func_75215_d(null);
                } else {
                    s.func_75215_d(aStack);
                }
                this.func_75142_b();
                return null;
            }
            return super.func_82846_b(aPlayer, aSlotIndex);
        }
    }
}

