/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;

@ZenClass(value="mods.thaumcraft.Arcane")
public class Arcane {
    public static final String name = "Thaumcraft Arcane Worktable";

    @ZenMethod
    public static void addShaped(String key, IItemStack output, String aspects, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IArcaneRecipe)new ShapedArcaneRecipe(key, InputHelper.toStack(output), ThaumcraftHelper.parseAspects(aspects), InputHelper.toShapedObjects(ingredients))));
    }

    @ZenMethod
    public static void addShapeless(String key, IItemStack output, String aspects, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IArcaneRecipe)new ShapelessArcaneRecipe(key, InputHelper.toStack(output), ThaumcraftHelper.parseAspects(aspects), InputHelper.toObjects(ingredients))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<IArcaneRecipe> recipes = new LinkedList<IArcaneRecipe>();
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            IArcaneRecipe recipe;
            if (o == null || !(o instanceof IArcaneRecipe) || (recipe = (IArcaneRecipe)o).getRecipeOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.getRecipeOutput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command Ignored", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<IArcaneRecipe> {
        public Remove(List<IArcaneRecipe> recipes) {
            super(Arcane.name, ThaumcraftApi.getCraftingRecipes(), recipes);
        }

        @Override
        protected String getRecipeInfo(IArcaneRecipe recipe) {
            ItemStack stack = recipe.getRecipeOutput();
            if (stack instanceof ItemStack) {
                return LogHelper.getStackDescription(stack);
            }
            return "Unknown output";
        }
    }

    private static class Add
    extends BaseListAddition<IArcaneRecipe> {
        public Add(IArcaneRecipe recipe) {
            super(Arcane.name, ThaumcraftApi.getCraftingRecipes());
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(IArcaneRecipe recipe) {
            ItemStack stack = recipe.getRecipeOutput();
            if (stack instanceof ItemStack) {
                return LogHelper.getStackDescription(stack);
            }
            return "Unknown output";
        }
    }
}

