/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.packets.client;

import chylex.hee.entity.fx.FXEvents;
import chylex.hee.mechanics.compendium.events.CompendiumEventsClient;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.packets.AbstractClientPacket;
import chylex.hee.system.update.UpdateNotificationManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityClientPlayerMP;

public class C09SimpleEvent
extends AbstractClientPacket {
    private EventType type;

    public C09SimpleEvent() {
    }

    public C09SimpleEvent(EventType type) {
        this.type = type;
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
    }

    @Override
    public void read(ByteBuf buffer) {
        byte typeId = buffer.readByte();
        if (typeId >= 0 && typeId < EventType.values().length) {
            this.type = EventType.values()[typeId];
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityClientPlayerMP player) {
        if (this.type == null) {
            return;
        }
        switch (this.type) {
            case BEGIN_TEMPLE_SMOKE: {
                FXEvents.beginTempleSmoke();
                break;
            }
            case ENDER_DEMON_SCREECH: {
                player.field_70170_p.func_72980_b(player.field_70165_t, player.field_70163_u + 16.0, player.field_70161_v, "hardcoreenderexpansion:enderdemon.scream", 1.8f, 1.0f, false);
                break;
            }
            case BACON_COMMAND: {
                Baconizer.runBaconCommand();
                break;
            }
            case SHOW_VOID_CHEST: {
                CompendiumEventsClient.showVoidChestAchievement();
                break;
            }
            case CHECK_UPDATES: {
                UpdateNotificationManager.tryRunUpdateCheck();
            }
        }
    }

    public static enum EventType {
        BEGIN_TEMPLE_SMOKE,
        ENDER_DEMON_SCREECH,
        BACON_COMMAND,
        SHOW_VOID_CHEST,
        CHECK_UPDATES;

    }
}

