/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import java.util.LinkedList;
import java.util.List;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.ICraftingResultHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.SolderingStationGui;
import logisticspipes.network.packets.block.SolderingStationHeat;
import logisticspipes.network.packets.block.SolderingStationInventory;
import logisticspipes.network.packets.block.SolderingStationProgress;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.recipes.SolderingStationRecipes;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsSolderingTileEntity
extends LogisticsSolidTileEntity
implements IGuiTileEntity,
ISidedInventory,
IGuiOpenControler {
    private final ItemIdentifierInventory inv = new ItemIdentifierInventory(12, "Soldering Inventory", 64);
    public int heat = 0;
    public int progress = 0;
    public boolean hasWork = false;
    private final PlayerCollectionList listener = new PlayerCollectionList();

    public boolean checkSlot(ItemStack stack, int slotNumber) {
        if (this.getRecipeForTaget() == null || this.getRecipeForTaget().length <= slotNumber) {
            return true;
        }
        ItemStack allowed = this.getRecipeForTaget()[slotNumber];
        if (allowed == null) {
            return stack == null;
        }
        return stack.func_77973_b() == allowed.func_77973_b() && stack.func_77960_j() == allowed.func_77960_j();
    }

    public boolean areStacksEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.inv.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getRecipeForTaget() {
        return this.getRecipeForTaget(this.inv.func_70301_a(11));
    }

    public ItemStack[] getRecipeForTaget(ItemStack target) {
        if (target == null) {
            return null;
        }
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            if (target.func_77973_b() != recipe.result.func_77973_b() || target.func_77960_j() != recipe.result.func_77960_j()) continue;
            return recipe.source;
        }
        return null;
    }

    public ItemStack getTargetForTaget() {
        return this.getTargetForTaget(this.inv.func_70301_a(11));
    }

    public ItemStack getTargetForTaget(ItemStack target) {
        if (target == null) {
            return null;
        }
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            if (target.func_77973_b() != recipe.result.func_77973_b() || target.func_77960_j() != recipe.result.func_77960_j()) continue;
            return recipe.result;
        }
        return null;
    }

    public List<ItemIdentifierStack> getRecipeForTagetAsItemIdentifierStackList() {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        ItemStack[] array = this.getRecipeForTaget();
        if (array != null) {
            for (ItemStack stack : array) {
                if (stack != null) {
                    list.addLast(ItemIdentifier.get(stack).makeStack(1));
                    continue;
                }
                list.addLast(null);
            }
        }
        return list;
    }

    private boolean itemEquals(ItemStack var1, ItemStack var2) {
        return var1.func_77973_b() == var2.func_77973_b() && var1.func_77960_j() == var2.func_77960_j();
    }

    public ItemStack getTagetForRecipe(boolean remove) {
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            boolean match = true;
            boolean removeThis = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack recipestack = recipe.source[i];
                ItemStack inputStack = this.inv.func_70301_a(i);
                if (recipestack == null) {
                    if (inputStack == null) continue;
                    match = false;
                    continue;
                }
                if (inputStack == null) {
                    match = false;
                    continue;
                }
                if (!this.itemEquals(recipestack, inputStack)) {
                    match = false;
                    continue;
                }
                if (!remove || (this.getTagetForRecipe(false) == null || !this.itemEquals(this.getTagetForRecipe(false), recipe.result)) && !removeThis) continue;
                --inputStack.field_77994_a;
                if (inputStack.field_77994_a <= 0) {
                    inputStack = null;
                }
                this.inv.func_70299_a(i, inputStack);
                removeThis = true;
            }
            if (!match) continue;
            return recipe.result.func_77946_l();
        }
        return null;
    }

    public ICraftingResultHandler getHandlerForRecipe() {
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            boolean match = true;
            for (int i = 0; i < 9; ++i) {
                ItemStack recipestack = recipe.source[i];
                ItemStack inputStack = this.inv.func_70301_a(i);
                if (recipestack == null) {
                    if (inputStack == null) continue;
                    match = false;
                    continue;
                }
                if (inputStack == null) {
                    match = false;
                    continue;
                }
                if (this.itemEquals(recipestack, inputStack)) continue;
                match = false;
            }
            if (!match) continue;
            return recipe.handler;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "");
    }

    private boolean hasWork() {
        return this.getTagetForRecipe(false) != null && this.inv.func_70301_a(9) != null;
    }

    private void updateHeat() {
        MainProxy.sendPacketToAllWatchingChunk(this.field_145851_c, this.field_145849_e, MainProxy.getDimensionForWorld(this.func_145831_w()), PacketHandler.getPacket(SolderingStationHeat.class).setInteger(this.heat).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e));
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SolderingStationHeat.class).setInteger(this.heat).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.listener);
    }

    private void updateProgress() {
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SolderingStationProgress.class).setInteger(this.progress).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.listener);
    }

    private void updateInventory() {
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SolderingStationInventory.class).setInventory((IInventory)this).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.listener);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (MainProxy.isClient(this.func_145831_w())) {
            return;
        }
        this.hasWork = this.hasWork();
        if (this.hasWork && this.heat < 100) {
            boolean usedEnergy = false;
            if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
                if (this.heat < 100) {
                    this.heat += 5;
                }
                if (this.heat > 100) {
                    this.heat = 100;
                }
                usedEnergy = true;
            } else {
                ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
                int n = forgeDirectionArray.length;
                for (int i = 0; i < n; ++i) {
                    CoreRoutedPipe pipe;
                    ForgeDirection dir = forgeDirectionArray[i];
                    LPPosition pos = new LPPosition(this);
                    pos.moveForward(dir);
                    TileEntity tile = pos.getTileEntity(this.func_145831_w());
                    if (!(tile instanceof LogisticsTileGenericPipe)) continue;
                    LogisticsTileGenericPipe tPipe = (LogisticsTileGenericPipe)tile;
                    if (!(tPipe.pipe instanceof CoreRoutedPipe) || !(pipe = (CoreRoutedPipe)tPipe.pipe).useEnergy(50)) continue;
                    this.heat += 5;
                    if (this.heat > 100) {
                        this.heat = 100;
                    }
                    this.updateHeat();
                    usedEnergy = true;
                    break;
                }
            }
            if (!usedEnergy && this.func_145831_w().func_82737_E() % 5L == 0L) {
                --this.heat;
                if (this.heat < 0) {
                    this.heat = 0;
                }
                this.updateHeat();
            }
        } else if (!this.hasWork && this.heat > 0) {
            --this.heat;
            this.updateHeat();
        }
        if (this.hasWork && this.heat >= 100) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                LPPosition pos = new LPPosition(this);
                pos.moveForward(dir);
                TileEntity tile = pos.getTileEntity(this.func_145831_w());
                if (!(tile instanceof LogisticsTileGenericPipe)) continue;
                LogisticsTileGenericPipe tPipe = (LogisticsTileGenericPipe)tile;
                if (!(tPipe.pipe instanceof CoreRoutedPipe)) continue;
                CoreRoutedPipe pipe = (CoreRoutedPipe)tPipe.pipe;
                if (pipe.useEnergy(30)) {
                    this.progress += 3;
                } else if (pipe.useEnergy(20)) {
                    this.progress += 2;
                } else if (pipe.useEnergy(10)) {
                    ++this.progress;
                }
                if (this.progress >= 100) {
                    this.progress = this.tryCraft() ? 0 : (this.progress -= 50);
                }
                this.updateProgress();
            }
        } else if (!this.hasWork && this.progress != 0) {
            this.progress = 0;
            this.updateProgress();
        }
    }

    private boolean tryCraft() {
        ItemIdentifierStack content = this.inv.getIDStackInSlot(10);
        ICraftingResultHandler handler = this.getHandlerForRecipe();
        ItemStack toAdd = this.getTagetForRecipe(false);
        if (handler != null) {
            handler.handleCrafting(toAdd);
        }
        if (content != null) {
            if (!content.getItem().equals(toAdd)) {
                return false;
            }
            if (content.getStackSize() + toAdd.field_77994_a > content.getItem().getMaxStackSize()) {
                return false;
            }
            toAdd.field_77994_a += content.getStackSize();
        }
        this.getTagetForRecipe(true);
        this.inv.func_70299_a(10, toAdd);
        this.inv.func_70298_a(9, 1);
        this.inv.func_70296_d();
        super.func_70296_d();
        this.updateInventory();
        return true;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inv.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inv.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inv.func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return this.inv.func_145825_b();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.inv.func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.listener.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.listener.remove(player);
    }

    public void onBlockBreak() {
        this.inv.dropContents(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getFrontTexture() {
        if (this.heat > 0) {
            return 3;
        }
        return 8;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        super.func_145828_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"1.1.3-GTNH");
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(SolderingStationGui.class);
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return var1 < 10;
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return var1 == 10;
    }
}

