/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.tileentity;

import cofh.api.energy.IEnergyReceiver;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConnected
extends IColoredTileEntity {
    public long injectEnergyUnits(ForgeDirection var1, long var2, long var4);

    public boolean inputEnergyFrom(ForgeDirection var1);

    default public boolean inputEnergyFrom(ForgeDirection side, boolean waitForActive) {
        return this.inputEnergyFrom(side);
    }

    public boolean outputsEnergyTo(ForgeDirection var1);

    default public boolean outputsEnergyTo(ForgeDirection side, boolean waitForActive) {
        return this.outputsEnergyTo(side);
    }

    public static final class Util {
        public static long emitEnergyToNetwork(long voltage, long amperage, IEnergyConnected emitter) {
            long usedAmperes = 0L;
            if (!(emitter instanceof IHasWorldObjectAndCoords)) {
                return 0L;
            }
            IHasWorldObjectAndCoords emitterTile = (IHasWorldObjectAndCoords)((Object)emitter);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int rfOut;
                IEnergyReceiver receiver;
                if (usedAmperes > amperage) break;
                if (!emitter.outputsEnergyTo(side)) continue;
                ForgeDirection oppositeSide = Objects.requireNonNull(side.getOpposite());
                TileEntity tTileEntity = emitterTile.getTileEntityAtSide(side);
                if (tTileEntity instanceof PowerLogicHost) {
                    PowerLogicHost host = (PowerLogicHost)tTileEntity;
                    PowerLogic logic = host.getPowerLogic(oppositeSide);
                    if (logic == null || logic.isEnergyReceiver()) continue;
                    usedAmperes += logic.injectEnergy(voltage, amperage - usedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergyConnected) {
                    byte tColor;
                    IEnergyConnected energyConnected = (IEnergyConnected)tTileEntity;
                    if (emitter.getColorization() >= 0 && (tColor = energyConnected.getColorization()) >= 0 && tColor != emitter.getColorization()) continue;
                    usedAmperes += energyConnected.injectEnergyUnits(oppositeSide, voltage, amperage - usedAmperes);
                    continue;
                }
                if (tTileEntity instanceof IEnergySink) {
                    IEnergySink sink = (IEnergySink)tTileEntity;
                    if (!sink.acceptsEnergyFrom((TileEntity)emitter, oppositeSide)) continue;
                    while (amperage > usedAmperes && sink.getDemandedEnergy() > 0.0 && sink.injectEnergy(oppositeSide, (double)voltage, (double)voltage) < (double)voltage) {
                        ++usedAmperes;
                    }
                    continue;
                }
                if (!GregTech_API.mOutputRF || !(tTileEntity instanceof IEnergyReceiver) || (receiver = (IEnergyReceiver)tTileEntity).receiveEnergy(oppositeSide, rfOut = GT_Utility.safeInt(voltage * (long)GregTech_API.mEUtoRF / 100L), true) != rfOut) continue;
                receiver.receiveEnergy(oppositeSide, rfOut, false);
                ++usedAmperes;
            }
            return usedAmperes;
        }

        public static void emitEnergyToNetwork(@Nonnull PowerLogicHost emitter, @Nonnull ForgeDirection outputSide) {
            int rfOut;
            IEnergyReceiver receiver;
            IEnergySink sink;
            long usedAmperes;
            if (outputSide == ForgeDirection.UNKNOWN) {
                return;
            }
            PowerLogic emitterLogic = emitter.getPowerLogic();
            long voltage = emitterLogic.getVoltage();
            long amperage = emitterLogic.getMaxAmperage();
            if (!(emitter instanceof IHasWorldObjectAndCoords)) {
                return;
            }
            IHasWorldObjectAndCoords emitterTile = (IHasWorldObjectAndCoords)((Object)emitter);
            if (emitter.getPowerLogic(outputSide) == null) {
                return;
            }
            ForgeDirection oppositeSide = Objects.requireNonNull(outputSide.getOpposite());
            TileEntity tileEntity = emitterTile.getTileEntityAtSide(outputSide);
            if (tileEntity instanceof PowerLogicHost) {
                PowerLogicHost host = (PowerLogicHost)tileEntity;
                PowerLogic logic = host.getPowerLogic(oppositeSide);
                if (logic == null || logic.isEnergyReceiver()) {
                    return;
                }
                emitterLogic.removeEnergyUnsafe((usedAmperes += logic.injectEnergy(voltage, amperage)) * voltage);
                return;
            }
            if (tileEntity instanceof IEnergyConnected) {
                byte tColor;
                IColoredTileEntity coloredEmitter;
                IEnergyConnected energyConnected = (IEnergyConnected)tileEntity;
                if (emitter instanceof IColoredTileEntity && (coloredEmitter = (IColoredTileEntity)((Object)emitter)).getColorization() >= 0 && (tColor = energyConnected.getColorization()) >= 0 && tColor != coloredEmitter.getColorization()) {
                    return;
                }
                usedAmperes += energyConnected.injectEnergyUnits(oppositeSide, voltage, amperage - usedAmperes);
                emitterLogic.removeEnergyUnsafe(usedAmperes * voltage);
                return;
            }
            if (tileEntity instanceof IEnergySink && (sink = (IEnergySink)tileEntity).acceptsEnergyFrom((TileEntity)emitter, oppositeSide)) {
                for (usedAmperes = 0L; amperage > usedAmperes && sink.getDemandedEnergy() > 0.0 && sink.injectEnergy(oppositeSide, (double)voltage, (double)voltage) < (double)voltage; ++usedAmperes) {
                }
                emitterLogic.removeEnergyUnsafe(usedAmperes * voltage);
                return;
            }
            if (GregTech_API.mOutputRF && tileEntity instanceof IEnergyReceiver && (receiver = (IEnergyReceiver)tileEntity).receiveEnergy(oppositeSide, rfOut = GT_Utility.safeInt(voltage * (long)GregTech_API.mEUtoRF / 100L), true) == rfOut) {
                receiver.receiveEnergy(oppositeSide, rfOut, false);
                emitterLogic.removeEnergyUnsafe(++usedAmperes * voltage);
                return;
            }
        }
    }
}

