/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.logic.MuTEProcessingLogic;
import java.util.stream.LongStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ComplexParallelProcessingLogic<P extends ComplexParallelProcessingLogic<P>>
extends MuTEProcessingLogic<P> {
    protected int maxComplexParallels;
    protected ItemStack[][] outputItems;
    protected FluidStack[][] outputFluids;
    protected long[] calculatedEutValues;
    protected int[] durations;
    protected int[] progresses;

    public P setMaxComplexParallel(int maxComplexParallels) {
        this.maxComplexParallels = maxComplexParallels;
        this.reinitializeProcessingArrays();
        return (P)((ComplexParallelProcessingLogic)this.getThis());
    }

    public ItemStack[] getOutputItems(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            return this.outputItems[index];
        }
        return null;
    }

    public FluidStack[] getOutputFluids(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            return this.outputFluids[index];
        }
        return null;
    }

    @Override
    public boolean canWork() {
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            if (this.progresses[i] < this.durations[i]) continue;
            return this.machineHost.isAllowedToWork();
        }
        return false;
    }

    @Override
    public long getCalculatedEut() {
        return LongStream.of(this.calculatedEutValues).sum();
    }

    public int getDuration(int index) {
        return this.durations[index];
    }

    public int getProgress(int index) {
        return this.progresses[index];
    }

    @Override
    public void progress() {
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            if (this.progresses[i] == this.durations[i]) {
                this.progresses[i] = 0;
                this.durations[i] = 0;
                this.output(i);
                continue;
            }
            this.progresses[i] = this.progresses[i] + 1;
        }
    }

    @Override
    public void startCheck() {
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            if (this.durations[i] > 0) continue;
            this.recipeResult = this.process();
            this.calculatedEutValues[i] = this.calculatedEut;
            this.durations[i] = this.duration;
            this.progresses[i] = 0;
            this.outputItems[i] = this.getOutputItems();
            this.outputFluids[i] = this.getOutputFluids();
        }
    }

    protected void output(int index) {
        this.setOutputItems(this.getOutputItems(index));
        this.setOutputFluids(this.getOutputFluids(index));
        this.output();
    }

    protected void reinitializeProcessingArrays() {
        int i;
        ItemStack[][] oldOutputItems = this.outputItems;
        FluidStack[][] oldOutputFluids = this.outputFluids;
        long[] oldCalculatedEutValues = this.calculatedEutValues;
        int[] oldDurations = this.durations;
        int[] oldProgresses = this.progresses;
        this.outputItems = new ItemStack[this.maxComplexParallels][];
        this.outputFluids = new FluidStack[this.maxComplexParallels][];
        this.calculatedEutValues = new long[this.maxComplexParallels];
        this.durations = new int[this.maxComplexParallels];
        this.progresses = new int[this.maxComplexParallels];
        for (i = 0; i < oldOutputItems.length; ++i) {
            this.outputItems[i] = oldOutputItems[i];
        }
        for (i = 0; i < oldOutputFluids.length; ++i) {
            this.outputFluids[i] = oldOutputFluids[i];
        }
        for (i = 0; i < oldCalculatedEutValues.length; ++i) {
            this.calculatedEutValues[i] = oldCalculatedEutValues[i];
        }
        for (i = 0; i < oldDurations[i]; ++i) {
            this.durations[i] = oldDurations[i];
        }
        for (i = 0; i < oldProgresses.length; ++i) {
            this.progresses[i] = oldProgresses[i];
        }
    }
}

