/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic.interfaces;

import gregtech.api.enums.InventoryType;
import gregtech.api.logic.ItemInventoryLogic;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public interface ItemInventoryLogicHost
extends ISidedInventory {
    @Nullable
    public ItemInventoryLogic getItemLogic(@Nonnull ForgeDirection var1, @Nonnull InventoryType var2);

    @Nonnull
    default public ItemInventoryLogic getItemLogic(@Nonnull InventoryType type, @Nullable UUID id) {
        return Objects.requireNonNull(this.getItemLogic(ForgeDirection.UNKNOWN, type));
    }

    @Nullable
    default public InventoryType getItemInventoryType() {
        return null;
    }

    @Nonnull
    default public Set<Map.Entry<UUID, ItemInventoryLogic>> getAllItemInventoryLogics(@Nonnull InventoryType type) {
        return new HashSet<Map.Entry<UUID, ItemInventoryLogic>>();
    }

    @Nullable
    default public ItemStack func_70298_a(int slot, int count) {
        InventoryType type = this.getItemInventoryType();
        if (type == InventoryType.Both) {
            return null;
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return null;
        }
        return logic.extractItem(slot, count);
    }

    default public int func_70302_i_() {
        InventoryType type = this.getItemInventoryType();
        if (type == InventoryType.Both) {
            return 0;
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return 0;
        }
        return logic.getSlots();
    }

    @Nullable
    default public ItemStack func_70301_a(int slot) {
        InventoryType type = this.getItemInventoryType();
        if (type == InventoryType.Both) {
            return null;
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return null;
        }
        return logic.getInventory().getStackInSlot(slot);
    }

    default public boolean func_94041_b(int slot, @Nullable ItemStack stack) {
        InventoryType type = this.getItemInventoryType();
        if (type == InventoryType.Both) {
            return false;
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return false;
        }
        return logic.getInventory().isItemValid(slot, stack);
    }

    default public void func_70299_a(int slot, @Nullable ItemStack stack) {
        InventoryType type = this.getItemInventoryType();
        if (type == InventoryType.Both) {
            return;
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return;
        }
        logic.getInventory().setStackInSlot(slot, stack);
    }

    default public boolean func_102008_b(int ignoredSlot, ItemStack ignoredItem, int side) {
        InventoryType type = this.getItemInventoryType();
        if (type == null) {
            return false;
        }
        return this.getItemLogic(ForgeDirection.getOrientation((int)side), type) != null;
    }

    default public boolean func_102007_a(int ignoredSlot, ItemStack ignoredItem, int side) {
        InventoryType type = this.getItemInventoryType();
        if (type == null) {
            return false;
        }
        return this.getItemInventoryType() != InventoryType.Output && this.getItemLogic(ForgeDirection.getOrientation((int)side), type) != null;
    }

    default public int[] func_94128_d(int side) {
        InventoryType type = this.getItemInventoryType();
        if (type == null) {
            return new int[0];
        }
        ItemInventoryLogic logic = this.getItemLogic(ForgeDirection.UNKNOWN, type == null ? InventoryType.Output : type);
        if (logic == null) {
            return new int[0];
        }
        int[] indexes = new int[logic.getSlots()];
        for (int i = 0; i < logic.getSlots(); ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    default public void func_70305_f() {
    }

    default public String func_145825_b() {
        return "";
    }

    default public int func_70297_j_() {
        return 64;
    }

    default public ItemStack func_70304_b(int index) {
        return null;
    }

    default public boolean func_145818_k_() {
        return false;
    }

    default public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return false;
    }

    default public void func_70295_k_() {
    }
}

