/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.interfaces.IItemUpdatable;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MultiTileEntityItemInternal
extends ItemBlock
implements IFluidContainerItem,
IItemUpdatable {
    public final MultiTileEntityBlockInternal mBlock;

    public MultiTileEntityItemInternal(Block aBlock) {
        super(aBlock);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.mBlock = (MultiTileEntityBlockInternal)aBlock;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer == null) {
            aList.add("INVALID ITEM!");
            return;
        }
        TileEntity tileEntity = tTileEntityContainer.mTileEntity;
        if (tileEntity instanceof IMultiTileEntity.IMTE_AddToolTips) {
            IMultiTileEntity.IMTE_AddToolTips mte = (IMultiTileEntity.IMTE_AddToolTips)tileEntity;
            try {
                mte.addToolTips(aList, aStack, aF3_H);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("addInformation", e);
            }
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        CoverableTileEntity.addInstalledCoversInformation(aNBT, aList);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List<ItemStack> aList) {
        for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
            if (tClass.mHidden || !tClass.mCanonicalTileEntity.getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
            aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
        }
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float aHitX, float aHitY, float aHitZ) {
        if (aY < 0 || aY > aWorld.func_72800_K()) {
            return false;
        }
        if (aPlayer == null) {
            return false;
        }
        try {
            IMultiTileEntity.IMTE_CanPlace mteCanPlace;
            IMultiTileEntity.IMTE_IgnoreEntityCollisionWhenPlacing mteIgnoreCollision;
            IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking mteSNeaking;
            TileEntity tileEntity;
            ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
            Block tClickedBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (tClickedBlock instanceof BlockSnow && (aWorld.func_72805_g(aX, aY, aZ) & 7) < 1) {
                ordinalSide = 1;
                side = ForgeDirection.UP;
            } else if (tClickedBlock != Blocks.field_150395_bd && tClickedBlock != Blocks.field_150329_H && tClickedBlock != Blocks.field_150330_I && !tClickedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
                aX += side.offsetX;
                aY += side.offsetY;
                aZ += side.offsetZ;
            }
            Block tReplacedBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (!tReplacedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ) || !this.mBlock.func_149705_a(aWorld, aX, aY, aZ, ordinalSide, aStack)) {
                return false;
            }
            if (aStack.field_77994_a == 0 || !aPlayer.func_82247_a(aX, aY, aZ, ordinalSide, aStack)) {
                return false;
            }
            MultiTileEntityContainer aMTEContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aWorld, aX, aY, aZ, aStack);
            if (aMTEContainer == null) {
                return false;
            }
            if (!aPlayer.func_70093_af() && (tileEntity = aMTEContainer.mTileEntity) instanceof IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking && (mteSNeaking = (IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking)tileEntity).onlyPlaceableWhenSneaking()) {
                return false;
            }
            tileEntity = aMTEContainer.mTileEntity;
            if (!(tileEntity instanceof IMultiTileEntity.IMTE_IgnoreEntityCollisionWhenPlacing && (mteIgnoreCollision = (IMultiTileEntity.IMTE_IgnoreEntityCollisionWhenPlacing)tileEntity).ignoreEntityCollisionWhenPlacing(aStack, aPlayer, aWorld, aX, aY, aZ, side, aHitX, aHitY, aHitZ) || aWorld.func_72855_b(AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1))))) {
                return false;
            }
            tileEntity = aMTEContainer.mTileEntity;
            if (tileEntity instanceof IMultiTileEntity.IMTE_CanPlace && !(mteCanPlace = (IMultiTileEntity.IMTE_CanPlace)tileEntity).canPlace(aStack, aPlayer, aWorld, aX, aY, aZ, side, aHitX, aHitY, aHitZ)) {
                return false;
            }
            if (!aWorld.func_147465_d(aX, aY, aZ, (Block)aMTEContainer.mBlock, 15 - aMTEContainer.mBlockMetaData, 2)) {
                return false;
            }
            aMTEContainer.setMultiTile(aWorld, aX, aY, aZ);
            try {
                if (((IMultiTileEntity)aMTEContainer.mTileEntity).onPlaced(aStack, aPlayer, aWorld, aX, aY, aZ, side, aHitX, aHitY, aHitZ)) {
                    aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, aMTEContainer.mBlock.field_149762_H.func_150496_b(), (aMTEContainer.mBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, aMTEContainer.mBlock.field_149762_H.func_150494_d() * 0.8f);
                }
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("onPlaced", e);
            }
            try {
                IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData mteData;
                tileEntity = aMTEContainer.mTileEntity;
                if (tileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && (mteData = (IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)tileEntity).hasMultiBlockMachineRelevantData()) {
                    GregTech_API.causeMachineUpdate(aWorld, aX, aY, aZ);
                }
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("causeMachineUpdate", e);
            }
            try {
                if (!aWorld.field_72995_K) {
                    aWorld.func_147444_c(aX, aY, aZ, tReplacedBlock);
                    aWorld.func_147453_f(aX, aY, aZ, (Block)aMTEContainer.mBlock);
                }
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("notifyBlockChange", e);
            }
            try {
                ((IMultiTileEntity)aMTEContainer.mTileEntity).onTileEntityPlaced();
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("onTileEntityPlaced", e);
            }
            try {
                aWorld.func_147451_t(aX, aY, aZ);
            }
            catch (Throwable e) {
                GT_Mod.GT_FML_LOGGER.error("updateAllLightTypes", e);
            }
            --aStack.field_77994_a;
            return true;
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("onItemUse", e);
            return false;
        }
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        TileEntity tileEntity;
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IItemUpdatable) {
            IItemUpdatable itemUpdatable = (IItemUpdatable)tileEntity;
            itemUpdatable.updateItemStack(aStack);
        }
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        TileEntity tileEntity;
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IItemUpdatable) {
            IItemUpdatable itemUpdatable = (IItemUpdatable)tileEntity;
            itemUpdatable.updateItemStack(aStack, aWorld, aX, aY, aZ);
        }
    }

    public int getItemStackLimit(ItemStack aStack) {
        TileEntity tileEntity;
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        if (tContainer == null) {
            return 1;
        }
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IMultiTileEntity.IMTE_GetMaxStackSize) {
            IMultiTileEntity.IMTE_GetMaxStackSize maxStackSize = (IMultiTileEntity.IMTE_GetMaxStackSize)tileEntity;
            return maxStackSize.getMaxStackSize(aStack, tContainer.mStackSize);
        }
        return tContainer.mStackSize;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.updateItemStack(aStack);
    }

    public FluidStack getFluid(ItemStack aStack) {
        TileEntity tileEntity;
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)tileEntity;
            FluidStack rFluid = fluidContainerItem.getFluid(aStack);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return null;
    }

    public int getCapacity(ItemStack aStack) {
        TileEntity tileEntity;
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)tileEntity;
            int rCapacity = fluidContainerItem.getCapacity(aStack);
            this.updateItemStack(aStack);
            return rCapacity;
        }
        return 0;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        TileEntity tileEntity;
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)tileEntity;
            int tFilled = fluidContainerItem.fill(aStack, aFluid, aDoFill);
            this.updateItemStack(aStack);
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        TileEntity tileEntity;
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getCachedTileEntityContainer(aStack);
        if (tTileEntityContainer != null && (tileEntity = tTileEntityContainer.mTileEntity) instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)tileEntity;
            FluidStack rFluid = fluidContainerItem.drain(aStack, aMaxDrain, aDoDrain);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return null;
    }

    public boolean func_150936_a(World aWorld, int aX, int aY, int aZ, int ordinalSide, EntityPlayer aPlayer, ItemStack aStack) {
        return true;
    }

    public final String func_77658_a() {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal;
    }

    public final String func_77667_c(ItemStack aStack) {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal + "." + this.getDamage(aStack);
    }

    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int aMeta) {
        this.field_77791_bV = Items.field_151025_P.func_77617_a(0);
        return this.field_77791_bV;
    }

    public boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    public final boolean func_77651_p() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }
}

