/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.machine;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.InventoryType;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.GUIHost;
import gregtech.api.gui.GUIProvider;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.AbstractProcessingLogic;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.logic.NullPowerLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.base.TickableMultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.task.tasks.ProcessingTask;
import gregtech.api.util.GT_Utility;
import gregtech.client.GT_SoundLoop;
import gregtech.common.gui.MachineGUIProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;

public abstract class MultiTileBasicMachine<P extends MuTEProcessingLogic<P>>
extends TickableMultiTileEntity
implements IMultiTileMachine,
ProcessingLogicHost<P>,
PowerLogicHost,
GUIHost {
    protected static final int ACTIVE = GT_Values.B[0];
    protected static final int TICKS_BETWEEN_RECIPE_CHECKS = 100;
    protected static final int POLLUTION_TICK = 20;
    protected static final byte INTERRUPT_SOUND_INDEX = 8;
    protected static final byte PROCESS_START_SOUND_INDEX = 1;
    protected static final IItemHandlerModifiable EMPTY_INVENTORY = new ItemStackHandler(0);
    public ITexture activeOverlayTexture = null;
    public ITexture activeOverlayGlowTexture = null;
    public ITexture inactiveOverlayTexture = null;
    public ITexture inactiveOverlayGlowTexture = null;
    protected int maxParallel = 1;
    protected boolean active = false;
    protected int tier = 0;
    protected long burnTime = 0L;
    protected long totalBurnTime = 0L;
    protected boolean outputInventoryChanged = false;
    protected boolean powerShutDown = false;
    protected boolean wasEnabled = false;
    protected boolean canWork = true;
    protected boolean isElectric = true;
    protected boolean isSteam = false;
    protected boolean acceptsFuel = false;
    protected byte soundEvent = 0;
    protected int soundEventValue = 0;
    protected ItemInventoryLogic itemInput;
    protected ItemInventoryLogic itemOutput;
    protected FluidInventoryLogic fluidInput;
    protected FluidInventoryLogic fluidOutput;
    protected P processingLogic;
    @Nonnull
    protected VoidingMode voidingMode = VoidingMode.VOID_NONE;
    protected boolean processingUpdate = false;
    @Nonnull
    protected PowerLogic power = this.createPowerLogic();
    @Nonnull
    protected GUIProvider<?> guiProvider = this.createGUIProvider();
    @SideOnly(value=Side.CLIENT)
    protected GT_SoundLoop activitySoundLoop;

    public MultiTileBasicMachine() {
        new ProcessingTask(this);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.machine.basic";
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        if (this.maxParallel > 0) {
            nbt.func_74768_a("gt.parallel", this.maxParallel);
        }
        if (this.active) {
            nbt.func_74757_a("gt.active", this.active);
        }
        this.saveItemLogic(nbt);
        this.saveFluidLogic(nbt);
        if (this.processingLogic != null) {
            NBTTagCompound processingLogicNBT = ((MuTEProcessingLogic)this.processingLogic).saveToNBT();
            nbt.func_74782_a("processingLogic", (NBTBase)processingLogicNBT);
        }
        nbt.func_74768_a("gt.tier", this.tier);
        nbt.func_74772_a("gt.burn.time.left", this.burnTime);
        nbt.func_74772_a("gt.total.burn.time", this.totalBurnTime);
        nbt.func_74757_a("gt.allowed.work", this.canWork);
        nbt.func_74757_a("gt.active", this.active);
        this.power.saveToNBT(nbt);
    }

    protected void saveItemLogic(NBTTagCompound nbt) {
        NBTTagCompound nbtListInput = this.itemInput.saveToNBT();
        nbt.func_74782_a("gt.invlist.in", (NBTBase)nbtListInput);
        NBTTagCompound nbtListOutput = this.itemOutput.saveToNBT();
        nbt.func_74782_a("gt.invlist.out", (NBTBase)nbtListOutput);
    }

    protected void saveFluidLogic(NBTTagCompound nbt) {
        NBTTagCompound fluidInputNBT = this.fluidInput.saveToNBT();
        nbt.func_74782_a("gt.tank.in.", (NBTBase)fluidInputNBT);
        NBTTagCompound fluidOutputNBT = this.fluidOutput.saveToNBT();
        nbt.func_74782_a("gt.tank.out.", (NBTBase)fluidOutputNBT);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        if (nbt.func_74764_b("gt.parallel")) {
            this.maxParallel = Math.max(1, nbt.func_74762_e("gt.parallel"));
        }
        if (nbt.func_74764_b("gt.active")) {
            this.active = nbt.func_74767_n("gt.active");
        }
        this.loadItemLogic(nbt);
        this.loadFluidLogic(nbt);
        if (nbt.func_74764_b("processingLogic")) {
            P processingLogic = this.getProcessingLogic();
            ((MuTEProcessingLogic)processingLogic).loadFromNBT(Objects.requireNonNull(nbt.func_74775_l("processingLogic")));
        }
        this.tier = nbt.func_74762_e("gt.tier");
        this.burnTime = nbt.func_74763_f("gt.burn.time.left");
        this.totalBurnTime = nbt.func_74763_f("gt.total.burn.time");
        this.canWork = nbt.func_74767_n("gt.allowed.work");
        this.active = nbt.func_74767_n("gt.active");
        this.power.loadFromNBT(nbt);
    }

    protected void loadItemLogic(NBTTagCompound nbt) {
        this.itemInput = new ItemInventoryLogic(nbt.func_74762_e("gt.invsize.out"), this.tier);
        this.itemOutput = new ItemInventoryLogic(nbt.func_74762_e("gt.invsize.out"), this.tier);
        if (nbt.func_74764_b("gt.invlist.in")) {
            this.itemInput.loadFromNBT(nbt.func_74775_l("gt.invlist.in"));
        }
        if (nbt.func_74764_b("gt.invlist.out")) {
            this.itemOutput.loadFromNBT(nbt.func_74775_l("gt.invlist.out"));
        }
    }

    protected void loadFluidLogic(NBTTagCompound nbt) {
        this.fluidInput = new FluidInventoryLogic(16, 10000L, this.tier);
        this.fluidOutput = new FluidInventoryLogic(16, 10000L, this.tier);
        this.fluidInput.loadFromNBT(nbt.func_74775_l("gt.tank.in."));
        this.fluidOutput.loadFromNBT(nbt.func_74775_l("gt.tank.out."));
    }

    public boolean checkTexture(String modID, String resourcePath) {
        try {
            Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modID, resourcePath));
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Override
    public void loadTextures(String folder) {
        super.loadTextures(folder);
        block6: for (MultiTileEntity.StatusTextures textureName : MultiTileEntity.StatusTextures.TEXTURES) {
            ITexture texture = null;
            String texturePath = "textures/blocks/multitileentity/" + folder + "/" + textureName.getName() + ".png";
            texture = !this.checkTexture(Mods.GregTech.ID, texturePath) ? TextureFactory.of(Textures.BlockIcons.VOID) : (textureName.hasGlow() ? TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("multitileentity/" + folder + "/" + textureName.getName())).glow().build() : TextureFactory.of(new Textures.BlockIcons.CustomIcon("multitileentity/" + folder + "/" + textureName.getName())));
            switch (textureName) {
                case Active: {
                    this.activeOverlayTexture = texture;
                    continue block6;
                }
                case ActiveWithGlow: {
                    this.activeOverlayGlowTexture = texture;
                    continue block6;
                }
                case Inactive: {
                    this.inactiveOverlayTexture = texture;
                    continue block6;
                }
                case InactiveWithGlow: {
                    this.inactiveOverlayGlowTexture = texture;
                }
            }
        }
    }

    @Override
    public void copyTextures() {
        super.copyTextures();
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (!(tCanonicalTileEntity instanceof MultiTileBasicMachine)) {
            return;
        }
        MultiTileBasicMachine canonicalEntity = (MultiTileBasicMachine)tCanonicalTileEntity;
        this.activeOverlayTexture = canonicalEntity.activeOverlayTexture;
        this.activeOverlayGlowTexture = canonicalEntity.activeOverlayGlowTexture;
        this.inactiveOverlayTexture = canonicalEntity.inactiveOverlayTexture;
        this.inactiveOverlayGlowTexture = canonicalEntity.inactiveOverlayGlowTexture;
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        ITexture texture = super.getTexture(side);
        if (side == this.facing) {
            if (this.isActive()) {
                return TextureFactory.of(texture, this.activeOverlayTexture, this.activeOverlayGlowTexture);
            }
            return TextureFactory.of(texture, this.inactiveOverlayTexture, this.inactiveOverlayGlowTexture);
        }
        return TextureFactory.of(texture, this.getCoverTexture(side));
    }

    public int getFluidInputCount() {
        return 7;
    }

    public int getFluidOutputCount() {
        return 3;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.hasInventoryChanged;
    }

    public void markOutputInventoryBeenModified() {
        this.outputInventoryChanged = true;
    }

    public boolean hasOutputInventoryBeenModified() {
        return this.outputInventoryChanged;
    }

    public void markInputInventoryBeenModified() {
        this.hasInventoryChanged = true;
    }

    @Override
    public void onPostTick(long tick, boolean isServerSide) {
        if (isServerSide) {
            this.runMachine(tick);
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    protected void runMachine(long tick) {
        if (this.acceptsFuel() && this.isActive() && !this.consumeFuel()) {
            this.stopMachine(true);
            return;
        }
        if (this.hasThingsToDo()) {
            this.func_70296_d();
            this.runningTick(tick);
            return;
        }
        if (tick % 100L == 0L || this.hasWorkJustBeenEnabled() || this.hasInventoryBeenModified() && this.isAllowedToWork()) {
            this.wasEnabled = false;
            if (this.checkRecipe()) {
                this.setActive(true);
                this.setSound((byte)5, 1);
                this.updateSlots();
                this.func_70296_d();
                this.issueClientUpdate();
            }
        }
    }

    protected void runningTick(long tick) {
        this.consumeEnergy();
    }

    protected boolean checkRecipe() {
        return false;
    }

    protected void consumeEnergy() {
        P processing;
        PowerLogic logic = this.getPowerLogic();
        if (!logic.removeEnergyUnsafe(((AbstractProcessingLogic)(processing = this.getProcessingLogic())).getCalculatedEut())) {
            this.stopMachine(true);
        }
    }

    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        switch (aIndex) {
            case 1: {
                if (this.getProcessStartSound() == null) break;
                GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
                break;
            }
            case 8: {
                GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
            }
        }
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1 && this.getProcessStartSound() != null) {
            GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    protected ResourceLocation getProcessStartSound() {
        return null;
    }

    protected int getTimeBetweenProcessSounds() {
        return 100;
    }

    @SideOnly(value=Side.CLIENT)
    protected void doActivitySound(ResourceLocation activitySound) {
        if (this.isActive() && activitySound != null && this.activitySoundLoop == null) {
            this.activitySoundLoop = new GT_SoundLoop(activitySound, this, false, true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activitySoundLoop);
            return;
        }
        if (this.activitySoundLoop != null) {
            this.activitySoundLoop = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySoundLoop() {
        return null;
    }

    protected ItemStack[] getInputItems() {
        return this.itemInput.getStoredItems();
    }

    protected FluidStack[] getInputFluids() {
        return this.fluidInput.getStoredFluids();
    }

    @Override
    public int getProgress() {
        P processing = this.getProcessingLogic();
        return ((MuTEProcessingLogic)processing).getProgress();
    }

    @Override
    public int getMaxProgress() {
        P processing = this.getProcessingLogic();
        return ((AbstractProcessingLogic)processing).getDuration();
    }

    @Override
    public boolean increaseProgress(int progressAmount) {
        P processing = this.getProcessingLogic();
        ((MuTEProcessingLogic)processing).increaseProgress(progressAmount);
        return true;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.wasEnabled;
    }

    @Override
    public void enableWorking() {
        this.wasEnabled = true;
        this.canWork = true;
    }

    @Override
    public void disableWorking() {
        this.canWork = false;
    }

    @Override
    public boolean wasShutdown() {
        return this.powerShutDown;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.canWork;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    protected boolean isElectric() {
        return this.isElectric;
    }

    protected void setElectric(boolean isElectric) {
        this.isElectric = isElectric;
    }

    protected boolean isSteam() {
        return this.isSteam;
    }

    protected void setSteam(boolean isSteam) {
        this.isSteam = isSteam;
    }

    protected boolean acceptsFuel() {
        return this.acceptsFuel;
    }

    protected void setFuel(boolean acceptsFuel) {
        this.acceptsFuel = acceptsFuel;
    }

    protected boolean consumeFuel() {
        if (this.isElectric() || this.isSteam()) {
            return false;
        }
        if (this.isActive() && this.burnTime <= 0L) {
            for (int i = 0; i < this.itemInput.getSlots(); ++i) {
                int checkBurnTime;
                ItemStack item = this.itemInput.getItemInSlot(i);
                if (item == null || (checkBurnTime = TileEntityFurnace.func_145952_a((ItemStack)item) / 10) <= 0) continue;
                --item.field_77994_a;
                this.burnTime = checkBurnTime;
                this.totalBurnTime = checkBurnTime;
                break;
            }
            this.updateSlots();
        }
        if (--this.burnTime < 0L) {
            this.burnTime = 0L;
            this.totalBurnTime = 0L;
            return false;
        }
        return false;
    }

    @Override
    protected void addDebugInfo(EntityPlayer player, int logLevel, ArrayList<String> list) {
        list.add(GT_Utility.trans("186", "Owned by: ") + EnumChatFormatting.BLUE + this.getOwnerName() + EnumChatFormatting.RESET + " (" + EnumChatFormatting.AQUA + this.getOwnerUuid() + EnumChatFormatting.RESET + ")");
        if (this.acceptsFuel()) {
            list.add("Fuel: " + EnumChatFormatting.GOLD + this.burnTime + "/" + this.totalBurnTime);
        }
        PowerLogic logic = this.getPowerLogic();
        if (this.isElectric) {
            list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(logic.getStoredEnergy()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(logic.getCapacity()) + EnumChatFormatting.RESET + " EU");
            list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(((AbstractProcessingLogic)this.getProcessingLogic()).getCalculatedEut()) + EnumChatFormatting.RESET + " EU/t");
            list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(logic.getVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(logic.getVoltage())] + EnumChatFormatting.RESET);
        }
        this.addProgressStringToScanner(player, logLevel, list);
        list.add("Average CPU load of ~" + GT_Utility.formatNumbers(0L) + "ns over " + GT_Utility.formatNumbers(0L) + " ticks with worst time of " + GT_Utility.formatNumbers(0L) + "ns.");
    }

    protected void addProgressStringToScanner(EntityPlayer player, int logLevel, ArrayList<String> list) {
        P processing = this.getProcessingLogic();
        int progressTime = ((MuTEProcessingLogic)processing).getProgress();
        int maxProgressTime = ((AbstractProcessingLogic)processing).getDuration();
        list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(progressTime > 20 ? (long)(progressTime / 20) : (long)progressTime) + EnumChatFormatting.RESET + (progressTime > 20 ? " s / " : " ticks / ") + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxProgressTime > 20 ? (long)(maxProgressTime / 20) : (long)maxProgressTime) + EnumChatFormatting.RESET + (maxProgressTime > 20 ? " s" : " ticks"));
    }

    protected void stopMachine(boolean powerShutDown) {
        this.setActive(false);
        this.disableWorking();
        if (powerShutDown) {
            this.setSound((byte)6, 8);
        }
        this.issueClientUpdate();
    }

    protected void updateSlots() {
        this.itemInput.update(false);
        this.itemOutput.update(false);
        this.fluidInput.update();
        this.fluidOutput.update();
    }

    @Override
    public int getBooleans() {
        int booleans = 0;
        if (this.isActive()) {
            booleans |= ACTIVE;
        }
        return booleans;
    }

    @Override
    public void setBooleans(int booleans) {
        this.setActive((booleans & ACTIVE) == ACTIVE);
    }

    @Override
    public boolean hasItemInput() {
        return true;
    }

    @Override
    public boolean hasItemOutput() {
        return true;
    }

    @Override
    public boolean hasFluidInput() {
        return true;
    }

    @Override
    public boolean hasFluidOutput() {
        return true;
    }

    @Override
    public void setSound(byte soundEvent, int soundEventValue) {
        this.soundEvent = soundEvent;
        this.soundEventValue = soundEventValue;
        if (this.isServerSide()) {
            return;
        }
        switch (soundEventValue) {
            case 1: {
                if (this.getProcessStartSound() == null) break;
                GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord());
                break;
            }
            case 8: {
                GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord());
            }
        }
    }

    @Override
    @Nullable
    public ItemInventoryLogic getItemLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        ItemInventoryLogic itemInventoryLogic;
        if (side == this.facing) {
            return null;
        }
        switch (type) {
            case Input: {
                itemInventoryLogic = this.itemInput;
                break;
            }
            case Output: {
                itemInventoryLogic = this.itemOutput;
                break;
            }
            default: {
                itemInventoryLogic = null;
            }
        }
        return itemInventoryLogic;
    }

    @Override
    @Nullable
    public FluidInventoryLogic getFluidLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        FluidInventoryLogic fluidInventoryLogic;
        if (side == this.facing) {
            return null;
        }
        switch (type) {
            case Input: {
                fluidInventoryLogic = this.fluidInput;
                break;
            }
            case Output: {
                fluidInventoryLogic = this.fluidOutput;
                break;
            }
            default: {
                fluidInventoryLogic = null;
            }
        }
        return fluidInventoryLogic;
    }

    @Override
    @Nonnull
    public P getProcessingLogic() {
        if (this.processingLogic == null) {
            this.processingLogic = ((MuTEProcessingLogic)this.createProcessingLogic()).setMachineHost(this);
        }
        return (P)((MuTEProcessingLogic)Objects.requireNonNull(this.processingLogic));
    }

    @Nonnull
    @ApiStatus.OverrideOnly
    protected abstract P createProcessingLogic();

    @Override
    public boolean isInputSeparated() {
        return false;
    }

    @Override
    @Nonnull
    public VoidingMode getVoidMode() {
        return this.voidingMode;
    }

    @Override
    public boolean needsUpdate() {
        return this.processingUpdate;
    }

    @Override
    public void setProcessingUpdate(boolean update) {
        this.processingUpdate = update;
    }

    @Override
    @Nonnull
    public PowerLogic getPowerLogic(@Nonnull ForgeDirection side) {
        if (side == this.facing) {
            return new NullPowerLogic();
        }
        return this.power;
    }

    @Override
    @Nonnull
    public ForgeDirection getPowerOutputSide() {
        return Objects.requireNonNull(this.facing.getOpposite());
    }

    protected void updatePowerLogic() {
        this.power.setEnergyCapacity(GT_Values.V[this.tier] * this.power.getMaxAmperage() * 2L * 1200L);
        this.power.setMaxVoltage(GT_Values.V[this.tier]);
        this.power.setMaxAmperage(1L);
    }

    @Nonnull
    protected PowerLogic createPowerLogic() {
        return new PowerLogic().setMaxAmperage(1L).setType(1);
    }

    @Nonnull
    protected GUIProvider<?> createGUIProvider() {
        return new MachineGUIProvider<MultiTileBasicMachine>(this);
    }

    @Override
    @Nonnull
    public GUIProvider<?> getGUI(@Nonnull UIBuildContext uiContext) {
        return this.guiProvider;
    }

    @Override
    public ItemStack getAsItem() {
        return MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()).getItem(this.getMultiTileEntityID());
    }

    @Override
    public String getMachineName() {
        return StatCollector.func_74838_a((String)this.getAsItem().func_77977_a());
    }
}

