/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GT_LanguageManager {
    private static final HashMap<String, String> TEMPMAP = new HashMap();
    public static final Map<String, String> BUFFERMAP = new HashMap<String, String>();
    private static final Map<String, String> LANGMAP = new HashMap<String, String>();
    public static Configuration sEnglishFile;
    public static boolean i18nPlaceholder;
    private static boolean hasUnsavedEntry;
    public static String FACE_ANY;
    public static String FACE_BOTTOM;
    public static String FACE_TOP;
    public static String FACE_LEFT;
    public static String FACE_FRONT;
    public static String FACE_RIGHT;
    public static String FACE_BACK;
    public static String FACE_NONE;
    public static String[] FACES;
    private static final Map<String, String> stringTranslateLanguageList;

    @Deprecated
    public static synchronized String addStringLocalization(String aKey, String aEnglish, boolean aWriteIntoLangFile) {
        return GT_LanguageManager.addStringLocalization(aKey, aEnglish);
    }

    public static synchronized String addStringLocalization(String aKey, String aEnglish) {
        String trimmedKey;
        String string = trimmedKey = aKey != null ? aKey.trim() : "";
        if (trimmedKey.isEmpty()) {
            return "";
        }
        if (sEnglishFile == null) {
            BUFFERMAP.put(trimmedKey, aEnglish);
            return aEnglish;
        }
        if (!BUFFERMAP.isEmpty()) {
            for (Map.Entry<String, String> tEntry : BUFFERMAP.entrySet()) {
                GT_LanguageManager.storeTranslation(tEntry.getKey(), tEntry.getValue());
            }
            BUFFERMAP.clear();
        }
        if (!LANGMAP.containsKey(trimmedKey)) {
            return GT_LanguageManager.storeTranslation(trimmedKey, aEnglish);
        }
        return LANGMAP.get(trimmedKey);
    }

    private static synchronized String storeTranslation(String trimmedKey, String english) {
        String translation = GT_LanguageManager.writeToLangFile(trimmedKey, english);
        LANGMAP.put(trimmedKey, translation);
        GT_LanguageManager.addToMCLangList(trimmedKey, translation);
        TEMPMAP.put(trimmedKey, translation);
        LanguageRegistry.instance().injectLanguage("en_US", TEMPMAP);
        TEMPMAP.clear();
        return translation;
    }

    private static synchronized String writeToLangFile(String trimmedKey, String aEnglish) {
        Property tProperty = sEnglishFile.get("LanguageFile", trimmedKey, aEnglish);
        if (hasUnsavedEntry && GregTech_API.sPostloadFinished) {
            sEnglishFile.save();
            hasUnsavedEntry = false;
        }
        if (!tProperty.wasRead()) {
            if (GregTech_API.sPostloadFinished) {
                sEnglishFile.save();
            } else {
                hasUnsavedEntry = true;
            }
        }
        return tProperty.getString();
    }

    public static String getTranslation(String aKey) {
        String tTrimmedKey;
        String string = tTrimmedKey = aKey != null ? aKey.trim() : "";
        if (tTrimmedKey.isEmpty()) {
            return "";
        }
        if (StatCollector.func_94522_b((String)tTrimmedKey)) {
            return StatCollector.func_74838_a((String)tTrimmedKey);
        }
        String anotherKeyToTry = tTrimmedKey.endsWith(".name") ? tTrimmedKey.substring(0, tTrimmedKey.length() - 5) : tTrimmedKey + ".name";
        if (StatCollector.func_94522_b((String)anotherKeyToTry)) {
            return StatCollector.func_74838_a((String)anotherKeyToTry);
        }
        return tTrimmedKey;
    }

    public static String getTranslation(String aKey, String aSeperator) {
        if (aKey == null) {
            return "";
        }
        String rTranslation = "";
        StringBuilder rTranslationSB = new StringBuilder(rTranslation);
        for (String tString : aKey.split(aSeperator)) {
            rTranslationSB.append(GT_LanguageManager.getTranslation(tString));
        }
        rTranslation = String.valueOf(rTranslationSB);
        return rTranslation;
    }

    public static String getTranslateableItemStackName(ItemStack aStack) {
        String tName;
        if (GT_Utility.isStackInvalid(aStack)) {
            return "null";
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT != null && tNBT.func_74764_b("display") && GT_Utility.isStringValid(tName = tNBT.func_74775_l("display").func_74779_i("Name"))) {
            return tName;
        }
        return aStack.func_77977_a() + ".name";
    }

    public static void writePlaceholderStrings() {
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_001", "Puts out into adjacent Slot #");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_002", "Grabs in for own Slot #");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_003", "Enable with Signal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_004", "Disable with Signal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_005", "Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_006", "Export");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_007", "Import");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_008", "Export (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_009", "Import (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_010", "Export (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_011", "Import (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_012", "Export allow Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_013", "Import allow Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_014", "Export allow Input (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_015", "Import allow Output (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_016", "Export allow Input (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_017", "Import allow Output (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_018", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_019", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_020", "Ready to work");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_021", "Not ready to work");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_022", "Import");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_023", "Import (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_024", "Import (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_025", "Keep Liquids Away");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_026", "Keep Liquids Away (conditional)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_027", "Keep Liquids Away (invert cond)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_031", "Normal Universal Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_032", "Inverted Universal Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_033", "Normal Electricity Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_034", "Inverted Electricity Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_035", "Normal Steam Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_036", "Inverted Steam Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_037", "Normal Average Electric Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_038", "Inverted Average Electric Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_039", "Normal Average Electric Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_040", "Inverted Average Electric Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_041", "Normal Electricity Storage(Including Batteries)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_042", "Inverted Electricity Storage(Including Batteries)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_043", "Filter input, Deny output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_044", "Invert input, Deny output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_045", "Filter input, Permit any output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_046", "Invert input, Permit any output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_047", "Filter Fluid: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_048", "Pump speed: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_049", "L/tick ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_050", "L/sec");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_053", "Slot: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_054", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_055", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_056", "Emit if 1 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_057", "Emit if 1 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_058", "Emit if 2 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_059", "Emit if 2 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_060", "Emit if 3 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_061", "Emit if 3 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_062", "Emit if 4 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_063", "Emit if 4 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_064", "Emit if 5 Maintenance Needed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_065", "Emit if 5 Maintenance Needed(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_066", "Emit if rotor needs maintenance low accuracy mod");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_067", "Emit if rotor needs maintenance low accuracy mod(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_068", "Emit if rotor needs maintenance high accuracy mod");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_068.1", "Emit if any Player is close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_069", "Emit if rotor needs maintenance high accuracy mod(inverted)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_069.1", "Emit if other Player is close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_070", "Emit if you are close");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_071", "Conducts strongest Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_072", "Conducts from bottom Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_073", "Conducts from top Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_074", "Conducts from north Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_075", "Conducts from south Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_076", "Conducts from west Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_077", "Conducts from east Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_078", "Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_079", "Conditional Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_080", "Inverted Conditional Signal = ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_081", "Frequency: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_082", "Open if work enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_083", "Open if work disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_084", "Only Output allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_085", "Only Input allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_086", "Auto-Input: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_087", "Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_088", "Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_089", "  Auto-Output: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_090", "Machine Processing: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_091", "Redstone Output at Side ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_092", " set to: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_093", "Strong");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_094", "Weak");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_094.1", "Not enough soldering material!");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_095", "Input from Output Side allowed");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_096", "Input from Output Side forbidden");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_098", "Do not regulate Item Stack Size");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_099", "Regulate Item Stack Size to: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_100", "This is ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_101", " Ore.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_102", "There is Lava behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_103", "There is a Liquid behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_104", "There is an Air Pocket behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_105", "Material is changing behind this Rock.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_106", "Found traces of ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_107", "No Ores found.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_108", "Outputs misc. Fluids, Steam and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_109", "Outputs Steam and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_110", "Outputs Steam and misc. Fluids");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_111", "Outputs Steam");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_112", "Outputs misc. Fluids and Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_113", "Outputs only Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_114", "Outputs only misc. Fluids");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_115", "Outputs nothing");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_122", "Emit Redstone if slots contain something");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_123", "Don't emit Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_124.1", "Blacklist Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_125.1", "Whitelist Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_128", "Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_128.1", "Redstone ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_129", "Energy");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_129.1", "Energy ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_130", "Fluids");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_130.1", "Fluids ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_131", "Items");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_131.1", "Items ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_132", "Pipe is loose.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_133", "Screws are loose.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_134", "Something is stuck.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_135", "Platings are dented.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_136", "Circuitry burned out.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_137", "That doesn't belong there.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_138", "Incomplete Structure.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_139", "Hit with Soft Mallet");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_140", "to (re-)start the Machine");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_141", "if it doesn't start.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_142", "Running perfectly.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_143", "Missing Mining Pipe");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_144", "Missing Turbine Rotor");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_145", "Step Down, In: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_146", "Step Up, In: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_147", "A, Out: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_148", "V ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_149", "A");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_150", "Chance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_151", "Does not get consumed in the process");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_151.1", "Outputs items and 1 specific Fluid");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_151.2", "Outputs 1 specific Fluid");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_151.4", "Successfully locked Fluid to %s");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_152", "Total: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_153", "Usage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_154", "Voltage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_155", "Amperage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_156", "Voltage: unspecified");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_157", "Amperage: unspecified");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_158", "Time: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_159", "Needs Low Gravity");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_160", "Needs Cleanroom");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_160.1", "Needs Cleanroom & LowGrav");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_161", " secs");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_162", "Name: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_163", " MetaData: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_164", "Hardness: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_165", " Blast Resistance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_166", "Is valid Beacon Pyramid Material");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_167", "Tank ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_168", "Heat: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_169", "HEM: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_170", " Base EU Output: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_171", "Facing: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_172", " / Chance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_173", "You can remove this with a Wrench");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_174", "You can NOT remove this with a Wrench");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_175", "Conduction Loss: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_176", "Contained Energy: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_177", "Has Muffler Upgrade");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_178", "Progress/Load: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_179", "Max IN: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_181", "Max OUT: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_182", " EU at ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_183", " A");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_184", "Energy: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_186", "Owned by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_187", "Type -- Crop-Name: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_188", "  Growth: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_189", "  Gain: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_190", "  Resistance: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_191", "Plant -- Fertilizer: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_192", "  Water: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_193", "  Weed-Ex: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_194", "  Scan-Level: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_195", "Environment -- Nutrients: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_196", "  Humidity: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_197", "  Air-Quality: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_198", "Attributes:");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_199", "Discovered by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_200", "Sort mode: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_200.1", "Automatic Item Shuffling: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_201", "Nothing");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_202", "Pollution in Chunk: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_203", " gibbl");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_204", "No Pollution in Chunk! HAYO!");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_206", "Scan for Assembly Line");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_207", "Pump speed: %dL every %d ticks, %.2f L/sec on average");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_208", " L");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_209", " ticks");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_209.1", " tick");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_210", "Average: %.2f L/sec");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_211", "Items per side: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_212", "Input enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_213", "Input disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_214", "Connected");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_215", "Disconnected");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_216", "Deprecated Recipe");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_219", "Extended Facing: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_220", "Single recipe locking disabled.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_221", "Item threshold");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_222", "Fluid threshold");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_222.1", "Energy threshold");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_223", "Single recipe locking enabled. Will lock to next recipe.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_224", "Always On");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_225", "Active with Redstone Signal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_226", "Inactive with Redstone Signal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_227", "Allow Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_228", "Block Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_229", "Export/Import");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_230", "Conditional");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_231", "Enable Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_232", "Filter Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_233", "Filter Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_234", "Block Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_235", "Allow Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_236", "Whitelist Fluid");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_237", "Blacklist Fluid");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_238", "Filter Direction");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_239", "Filter Type");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_240", "Block Flow");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_241", "Recipe progress");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_242", "Machine idle");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_243", "Enable with Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_244", "Disable with Redstone");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_245", "Disable machine");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_246", "Frequency");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_247", "1 Issue");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_248", "2 Issues");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_249", "3 Issues");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_250", "4 Issues");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_251", "5 Issues");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_252", "Rotor < 80%");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_253", "Rotor < 100%");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_254", "Detect slot#");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_254.0", "Detect Slot");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_254.1", "Internal slot#");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_255", "Adjacent slot#");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_256", "Universal Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_257", "Electricity Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_258", "Steam Storage");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_259", "Average Electric Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_260", "Average Electric Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_261", "Electricity Storage(Including Batteries)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_262", "Fluid Auto Output Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_263", "Fluid Auto Output Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_264", "currently none, will be locked to the next that is put in");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_265", "1 specific Fluid");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_266", "Lock Fluid Mode Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_267", "Overflow Voiding Mode Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_268", "Overflow Voiding Mode Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_269", "Void Full Mode Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_270", "Void Full Mode Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_271", "unspecified");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_272", "Recipe by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_273", "Original Recipe by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_274", "Modified by: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_275", "Original voltage: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_299", "Item Filter: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_300", "Filter Cleared!");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_300.1", "Fluid Lock Cleared.");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_301", "Universal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_302", "Int. EU");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_303", "Steam");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_304", "Avg. Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_305", "Avg. Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_306", "EU stored");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_307", "Deny input, Filter output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_308", "Deny input, Invert output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_309", "Permit any input, Filter output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_310", "Permit any input, Invert output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_311", "Block Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_312", "Allow Output");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_313", "Block Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_314", "Allow Input");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_315", "Filter Empty");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_316", "Pump speed limit reached!");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_317", "Filter: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_318", "Check Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_319", "Any player");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_320", "Other players");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_321", "Only owner");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_322", "Overflow point: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_323", "L");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_324", "Now");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_325", "Max");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_326", "Public");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_327", "Private");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_328", "Channel");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_329", "Public/Private");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_330", "Sneak Rightclick to switch Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_331", "AND Gate");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_332", "NAND Gate");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_333", "OR Gate");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_334", "NOR Gate");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_335", "Gate Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_336", "PCB Factory Tier: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_337", "Upgrade Required: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_338", "Bio");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_339", "Biochamber Upgrade Enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_339.1", "Biochamber Upgrade Disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_340", "Rotated biochamber enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_340.1", "Rotated biochamber disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_341", "Tier 1 cooling enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_341.1", "Tier 1 cooling disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_342", "Tier 2 cooling enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_342.1", "Tier 2 cooling disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_343", "Use Machine Processing State");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_343.1", "Use Inverted Machine Processing State");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_344", "Input Blocking");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_344.1", "Output Blocking");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_500", "Fitting: Loose - More Flow");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_501", "Fitting: Tight - More Efficiency");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_502", "Mining chunk loading enabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_503", "Mining chunk loading disabled");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_505", "Enable with Signal (Safe)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_506", "Disable with Signal (Safe)");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_507", "Safe Mode");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_602", "Use Private Frequency");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_756", "Connectable: ");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_ALL", "All");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_ANY", "Any");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_INVERTED", "Inverted");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_NORMAL", "Normal");
        GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_SIDE", "Side: ");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_000", "Stored Heat: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_001", "Durability: %s/%s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_002", "%s lvl %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_003", "Attack Damage: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_004", "Mining Speed: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_005", "Turbine Efficiency: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_006", "Optimal Steam flow: %s L/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_007", "Energy from Optimal Gas Flow: %s EU/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_008", "Energy from Optimal Plasma Flow: %s EU/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_009", "Contains %s EU   Tier: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_010", "Empty. You should recycle it properly.");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_011", "%s / %s EU - Voltage: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_012", "No Fluids Contained");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_013", "%sL / %sL");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_014", "Missing Coodinates!");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_015", "Device at:");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_018", "State: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_019", "Bath with neutron in a hot reactor");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_020", "Progress: %s/%s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_021", "Radiation Hazard");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_500", "Turbine Efficiency (Loose): %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_501", "Optimal Steam flow (Loose): %s L/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_502", "Overflow Efficiency Tier: %s");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_900", "Energy from Optimal Steam Flow: %s EU/t");
        GT_LanguageManager.addStringLocalization("Item_DESCRIPTION_Index_901", "Energy from Optimal Steam Flow (Loose): %s EU/t");
        GT_LanguageManager.addStringLocalization(FACE_ANY, "Any Side");
        GT_LanguageManager.addStringLocalization(FACE_BOTTOM, "Bottom");
        GT_LanguageManager.addStringLocalization(FACE_TOP, "Top");
        GT_LanguageManager.addStringLocalization(FACE_LEFT, "Left");
        GT_LanguageManager.addStringLocalization(FACE_FRONT, "Front");
        GT_LanguageManager.addStringLocalization(FACE_RIGHT, "Right");
        GT_LanguageManager.addStringLocalization(FACE_BACK, "Back");
        GT_LanguageManager.addStringLocalization(FACE_NONE, "None");
    }

    private static void addToMCLangList(String aKey, String translation) {
        if (stringTranslateLanguageList != null) {
            stringTranslateLanguageList.put(aKey, translation);
        }
    }

    static {
        i18nPlaceholder = true;
        hasUnsavedEntry = false;
        FACE_ANY = "gt.lang.face.any";
        FACE_BOTTOM = "gt.lang.face.bottom";
        FACE_TOP = "gt.lang.face.top";
        FACE_LEFT = "gt.lang.face.left";
        FACE_FRONT = "gt.lang.face.front";
        FACE_RIGHT = "gt.lang.face.right";
        FACE_BACK = "gt.lang.face.back";
        FACE_NONE = "gt.lang.face.none";
        FACES = new String[]{FACE_BOTTOM, FACE_TOP, FACE_LEFT, FACE_FRONT, FACE_RIGHT, FACE_BACK, FACE_NONE};
        try {
            Field fieldStringTranslateLanguageList = ReflectionHelper.findField(StringTranslate.class, (String[])new String[]{"languageList", "field_74816_c"});
            Field fieldStringTranslateInstance = ReflectionHelper.findField(StringTranslate.class, (String[])new String[]{"instance", "field_74817_a"});
            stringTranslateLanguageList = (Map)fieldStringTranslateLanguageList.get(fieldStringTranslateInstance.get(null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

