/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ProcessingPlate
implements IOreRecipeRegistrator {
    public ProcessingPlate() {
        OrePrefixes.plate.add(this);
        OrePrefixes.plateDouble.add(this);
        OrePrefixes.plateTriple.add(this);
        OrePrefixes.plateQuadruple.add(this);
        OrePrefixes.plateQuintuple.add(this);
        OrePrefixes.plateDense.add(this);
        OrePrefixes.plateAlloy.add(this);
        OrePrefixes.itemCasing.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        long aMaterialMass = aMaterial.getMass();
        switch (aPrefix) {
            case plate: {
                this.registerPlate(aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateDouble: {
                this.registerPlateDouble(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateTriple: {
                this.registerPlateTriple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateQuadruple: {
                this.registerPlateQuadruple(aMaterial, aStack, aNoSmashing, aMaterialMass, aNoWorking);
                break;
            }
            case plateQuintuple: {
                this.registerPlateQuintuple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateDense: {
                this.registerPlateDense(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case itemCasing: {
                this.registerItemCasing(aPrefix, aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateAlloy: {
                this.registerPlateAlloy(aOreDictName, aStack);
                break;
            }
        }
    }

    private void registerPlate(Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        GT_ModHandler.removeRecipeDelayed(aStack);
        GT_Utility.removeSimpleIC2MachineRecipe(GT_Utility.copyAmount(9, aStack), GT_ModHandler.getCompressorRecipeList(), GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L));
        if (aMaterial.mFuelPower > 0) {
            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GT_RecipeConstants.Fuel);
        }
        if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
            GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(aMaterial.getPlates(1)).fluidInputs(aMaterial.getMolten(144L)).duration(32).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"hX", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        if (aMaterial == Materials.Paper) {
            GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.harderrecipes, aStack, true) ? 2 : 3, aStack), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"XXX", Character.valueOf('X'), new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE)});
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
            if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"h", "X", "X", Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
            }
            if (aMaterial.contains(SubTag.MORTAR_GRINDABLE) && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.mortar, aMaterial.mName, true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GT_ModHandler.addShapelessCraftingRecipe(aMaterial.getDust(1), GT_Proxy.tBits, new Object[]{ToolDictNames.craftingToolMortar, OrePrefixes.plate.get(aMaterial)});
            }
        }
    }

    private void registerPlateDouble(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            if (GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
            }
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_Utility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(10L)).duration(64).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerdoubleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), aPlateStack, Character.valueOf('B'), aPlateStack});
            }
        }
    }

    private void registerPlateTriple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            if (GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
            }
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_Utility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(20L)).duration(96).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammertripleplate, OrePrefixes.plate.get(aMaterial).toString(), true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateDouble.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack});
        }
        if (GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L) != null) {
            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), ItemList.Block_Powderbarrel.get(4L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L)).duration(20).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.implosionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), GT_ModHandler.getIC2Item("dynamite", 1L, null)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L)).duration(20).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.implosionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), new ItemStack(Blocks.field_150335_W, 2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L)).duration(20).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.implosionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), GT_ModHandler.getIC2Item("industrialTnt", 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L)).duration(20).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.implosionRecipes);
        }
    }

    private void registerPlateQuadruple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass, boolean aNoWorking) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GT_Utility.getIntegratedCircuit(4)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 4L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GT_Utility.getIntegratedCircuit(4)).itemOutputs(GT_Utility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(30L)).duration(128).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquadrupleplate, OrePrefixes.plate.get(aMaterial).toString(), true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateTriple.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
        }
    }

    private void registerPlateQuintuple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GT_Utility.getIntegratedCircuit(5)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 5L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GT_Utility.getIntegratedCircuit(5)).itemOutputs(GT_Utility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(40L)).duration(160).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquintupleplate, OrePrefixes.plate.get(aMaterial).toString(), true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateQuadruple.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
        }
    }

    private void registerPlateDense(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 9L), GT_Utility.getIntegratedCircuit(9)).itemOutputs(GT_Utility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 9L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        }
    }

    private void registerItemCasing(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (aMaterial.mStandardMoltenFluid != null) {
            GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(16).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h X", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"H X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        }
        if (GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) != null) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 2L), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_Utility.copyAmount(3, aStack)).duration(128).eut(GT_Utility.calculateRecipeEU(aMaterial, 15)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 45)).addTo(RecipeMaps.extruderRecipes);
        }
        if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, (int)Math.max(aMaterial.getMass(), 1L) * GT_Utility.calculateRecipeEU(aMaterial, 16) / 320)))).duration(2 * (int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(GT_ModHandler.getDistilledWater(Math.max(3, Math.min(750, (int)Math.max(aMaterial.getMass(), 1L) * GT_Utility.calculateRecipeEU(aMaterial, 16) / 426)))).duration(2 * (int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
            GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, (int)Math.max(aMaterial.getMass(), 1L) * GT_Utility.calculateRecipeEU(aMaterial, 16) / 1280)))).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
        }
        GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
    }

    private void registerPlateAlloy(String aOreDictName, ItemStack aStack) {
        switch (aOreDictName) {
            case "plateAlloyCarbon": {
                GT_Values.RA.stdBuilder().itemInputs(GT_ModHandler.getIC2Item("generator", 1L), GT_Utility.copyAmount(4, aStack)).itemOutputs(GT_ModHandler.getIC2Item("windMill", 1L)).duration(6400).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), new ItemStack(Blocks.field_150359_w, 3, Short.MAX_VALUE)).itemOutputs(GT_ModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack), Materials.Glass.getDust(3)).itemOutputs(GT_ModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                break;
            }
            case "plateAlloyAdvanced": {
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1, aStack), new ItemStack(Blocks.field_150359_w, 3, Short.MAX_VALUE), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1, aStack), Materials.Glass.getDust(3), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                break;
            }
            case "plateAlloyIridium": {
                GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                break;
            }
        }
    }

    private void registerCover(Materials aMaterial, ItemStack aStack) {
        OrePrefixes orePrefix;
        ItemStack tStack = GT_Values.NI;
        OrePrefixes[] orePrefixesArray = new OrePrefixes[]{OrePrefixes.block, OrePrefixes.block_, OrePrefixes.stoneSmooth, OrePrefixes.stone};
        int n = orePrefixesArray.length;
        for (int i = 0; i < n && (tStack = GT_OreDictUnificator.get(orePrefix = orePrefixesArray[i], aMaterial, 1L)) == GT_Values.NI; ++i) {
        }
        GregTech_API.registerCover(aStack, tStack == GT_Values.NI ? TextureFactory.builder().addIcon(aMaterial.mIconSet.mTextures[71]).setRGBA(aMaterial.mRGBa).stdOrient().build() : TextureFactory.of(Block.func_149634_a((Item)tStack.func_77973_b()), tStack.func_77960_j()), null);
    }
}

