/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client;

import aroma1997.core.client.ThreadDownloadCape;
import aroma1997.core.client.events.ClientEventListener;
import aroma1997.core.client.util.Colors;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.web.xml.XMLParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

@SideOnly(value=Side.CLIENT)
public class MiscStuff {
    private static HashMap<String, String> capes = new HashMap();
    private static HashMap<String, Colors> colors = new HashMap();

    public static void init() {
        new Thread((Runnable)new Load(), "Aroma1997Core-InitThread").start();
    }

    private static void load() {
        try {
            XMLParser xml = new XMLParser(new URL("http://a.aroma1997.org/mcmods/info.xml").openStream());
            for (Map.Entry<String, Node> entry : xml.getAll().entrySet()) {
                if (entry.getKey().split("\\.").length != 2) continue;
                String username = entry.getKey().split("\\.")[0];
                String part = entry.getKey().split("\\.")[1];
                if (part.equalsIgnoreCase("cape") && !entry.getValue().getTextContent().isEmpty()) {
                    MiscStuff.setCape(username, entry.getValue().getTextContent());
                    continue;
                }
                if (!part.equalsIgnoreCase("color") || entry.getValue().getTextContent().isEmpty()) continue;
                MiscStuff.setColor(username, entry.getValue().getTextContent());
            }
        }
        catch (Exception e) {
            LogHelperPre.logException("Failed to setup Capes.", e);
        }
        ClientEventListener.resetCounter();
        ThreadDownloadCape.resetThreads();
    }

    public static void setCape(String player, String url) {
        if (capes.containsKey(player = player.toLowerCase())) {
            capes.remove(player);
        }
        capes.put(player, url);
    }

    public static String getCape(String player) {
        return capes.get(player.toLowerCase());
    }

    public static boolean hasCape(String player) {
        return capes.containsKey(player.toLowerCase()) && capes.get(player.toLowerCase()) != null;
    }

    public static void setColor(String player, String color) {
        MiscStuff.setColor(player, Colors.valueOf(color));
    }

    public static void setColor(String player, Colors color) {
        if (colors.containsKey(player = player.toLowerCase())) {
            colors.remove(player);
        }
        colors.put(player, color);
    }

    public static Colors getColor(String player) {
        return colors.get(player.toLowerCase());
    }

    public static boolean hasColor(String player) {
        return colors.containsKey(player.toLowerCase()) && colors.get(player.toLowerCase()) != null;
    }

    public static void reloadAll() {
        capes.clear();
        colors.clear();
        MiscStuff.init();
    }

    private static class Load
    implements Runnable {
        private Load() {
        }

        @Override
        public void run() {
            MiscStuff.load();
        }
    }
}

