/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import java.util.function.IntConsumer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class VertexFormatElement {
    protected final Type type;
    protected final Usage usage;
    protected final int index;
    protected final int count;
    protected final int byteSize;

    public VertexFormatElement(int index, Type type, Usage usage, int count) {
        this.index = index;
        this.type = type;
        this.usage = usage;
        this.count = count;
        this.byteSize = type.getSize() * count;
    }

    public void setupBufferState(long l, int i) {
        this.usage.setupBufferState(this.count, this.type.getGlType(), i, l, this.index);
    }

    public void clearBufferState() {
        this.usage.clearBufferState(this.index);
    }

    public Type getType() {
        return this.type;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public static enum Type {
        FLOAT(4, "Float", 5126),
        UBYTE(1, "Unsigned Byte", 5121),
        BYTE(1, "Byte", 5120),
        USHORT(2, "Unsigned Short", 5123),
        SHORT(2, "Short", 5122),
        UINT(4, "Unsigned Int", 5125),
        INT(4, "Int", 5124);

        private final int size;
        private final String name;
        private final int glType;

        private Type(int size, String name, int glType) {
            this.size = size;
            this.name = name;
            this.glType = glType;
        }

        public int getSize() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        public int getGlType() {
            return this.glType;
        }
    }

    public static enum Usage {
        POSITION("Position", (i, j, k, l, m) -> {
            GL11.glVertexPointer((int)i, (int)j, (int)k, (long)l);
            GL11.glEnableClientState((int)32884);
        }, i -> GL11.glDisableClientState((int)32884)),
        NORMAL("Normal", (i, j, k, l, m) -> {
            GL11.glNormalPointer((int)j, (int)k, (long)l);
            GL11.glEnableClientState((int)32885);
        }, i -> GL11.glDisableClientState((int)32885)),
        COLOR("Vertex Color", (i, j, k, l, m) -> {
            GL11.glColorPointer((int)i, (int)j, (int)k, (long)l);
            GL11.glEnableClientState((int)32886);
        }, i -> GL11.glDisableClientState((int)32886)),
        UV("UV", (i, j, k, l, m) -> {
            GL13.glClientActiveTexture((int)(33984 + m));
            GL11.glTexCoordPointer((int)i, (int)j, (int)k, (long)l);
            GL11.glEnableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }, i -> {
            GL13.glClientActiveTexture((int)(33984 + i));
            GL11.glDisableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }),
        PADDING("Padding", (i, j, k, l, m) -> {}, i -> {}),
        GENERIC("Generic", (i, j, k, l, m) -> {
            GL20.glEnableVertexAttribArray((int)m);
            GL20.glVertexAttribPointer((int)m, (int)i, (int)j, (boolean)false, (int)k, (long)l);
        }, GL20::glDisableVertexAttribArray);

        private final String name;
        private final SetupState setupState;
        private final IntConsumer clearState;

        private Usage(String name, SetupState setupState, IntConsumer clearState) {
            this.name = name;
            this.setupState = setupState;
            this.clearState = clearState;
        }

        private void setupBufferState(int i, int j, int k, long l, int m) {
            this.setupState.setupBufferState(i, j, k, l, m);
        }

        public void clearBufferState(int i) {
            this.clearState.accept(i);
        }

        public String getName() {
            return this.name;
        }

        static interface SetupState {
            public void setupBufferState(int var1, int var2, int var3, long var4, int var6);
        }
    }
}

