/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRHFactory;
import com.gtnewhorizons.angelica.mixins.interfaces.IRenderingRegistryExt;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.block.Block;

public class AngelicaBlockSafetyRegistry {
    private static final Reference2BooleanMap<Block> BLOCK_SAFETY_MAP = new Reference2BooleanOpenHashMap();
    private static final Reference2BooleanMap<Block> ISBRH_SAFETY_MAP = new Reference2BooleanOpenHashMap();
    private static final StampedLock LOCK = new StampedLock();

    public static boolean canBlockRenderOffThread(Block block, boolean checkISBRH, boolean shouldPopulate) {
        Reference2BooleanMap<Block> map;
        Reference2BooleanMap<Block> reference2BooleanMap = map = checkISBRH ? ISBRH_SAFETY_MAP : BLOCK_SAFETY_MAP;
        if (shouldPopulate) {
            return AngelicaBlockSafetyRegistry.populateCanRenderOffThread(block, map);
        }
        return map.getBoolean((Object)block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean populateCanRenderOffThread(Block block, Reference2BooleanMap<Block> map) {
        ISimpleBlockRenderingHandler isbrh;
        boolean canBeOffThread = map == ISBRH_SAFETY_MAP ? (isbrh = ((IRenderingRegistryExt)RenderingRegistry.instance()).getISBRH(block.func_149645_b())) != null && (isbrh.getClass().isAnnotationPresent(ThreadSafeISBRH.class) || isbrh instanceof ThreadSafeISBRHFactory) : true;
        long stamp = LOCK.writeLock();
        try {
            map.put((Object)block, canBeOffThread);
        }
        finally {
            LOCK.unlock(stamp);
        }
        return canBeOffThread;
    }
}

