/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import mist475.mcpatcherforge.config.MCPatcherForgeConfig;

public class MCLogger {
    private static final Map<String, MCLogger> allLoggers = new HashMap<String, MCLogger>();
    public static final Level ERROR = new ErrorLevel();
    private static final long FLOOD_INTERVAL = 1000L;
    private static final long FLOOD_REPORT_INTERVAL = 5000L;
    private static final int FLOOD_LEVEL = Level.INFO.intValue();
    private final String logPrefix;
    private final Logger logger;
    private boolean flooding;
    private long lastFloodReport;
    private int floodCount;
    private long lastMessage = System.currentTimeMillis();

    public static MCLogger getLogger(Category category) {
        return MCLogger.getLogger(category, category.name);
    }

    public static synchronized MCLogger getLogger(Category category, String logPrefix) {
        MCLogger logger = allLoggers.get(category.name);
        if (logger == null) {
            logger = new MCLogger(category, logPrefix);
            allLoggers.put(category.name, logger);
        }
        return logger;
    }

    private MCLogger(Category category, String logPrefix) {
        String string;
        this.logPrefix = logPrefix;
        this.logger = Logger.getLogger(category.name);
        MCPatcherForgeConfig config = MCPatcherForgeConfig.instance();
        switch (category) {
            case CUSTOM_COLORS: {
                string = config.customColorsLoggingLevel;
                break;
            }
            case CUSTOM_ITEM_TEXTURES: {
                string = config.customItemTexturesLoggingLevel;
                break;
            }
            case CONNECTED_TEXTURES: {
                string = config.connectedTexturesLoggingLevel;
                break;
            }
            case EXTENDED_HD: {
                string = config.extendedHDLoggingLevel;
                break;
            }
            case RANDOM_MOBS: {
                string = config.randomMobsLoggingLevel;
                break;
            }
            case BETTER_SKIES: {
                string = config.betterSkiesLoggingLevel;
                break;
            }
            default: {
                string = Level.INFO.getName();
            }
        }
        this.logger.setLevel(Level.parse(string));
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(new Handler(){
            private final Formatter formatter = new Formatter(){

                @Override
                public String format(LogRecord record) {
                    Level level = record.getLevel();
                    if (level == Level.CONFIG) {
                        return record.getMessage();
                    }
                    String message = record.getMessage();
                    StringBuilder prefix = new StringBuilder();
                    while (message.startsWith("\n")) {
                        prefix.append("\n");
                        message = message.substring(1);
                    }
                    return prefix + "[" + MCLogger.this.logPrefix + "] " + level.toString() + ": " + message;
                }
            };

            @Override
            public void publish(LogRecord record) {
                System.out.println(this.formatter.format(record));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    private boolean checkFlood() {
        long now = System.currentTimeMillis();
        boolean showFloodMessage = false;
        if (now - this.lastMessage > 1000L) {
            if (this.flooding) {
                this.reportFlooding(now);
                this.flooding = false;
            } else {
                this.floodCount = 0;
            }
        } else if (this.flooding && now - this.lastFloodReport > 5000L) {
            this.reportFlooding(now);
            showFloodMessage = true;
        }
        this.lastMessage = now;
        ++this.floodCount;
        if (this.flooding) {
            return showFloodMessage;
        }
        return true;
    }

    private void reportFlooding(long now) {
        if (this.floodCount > 0) {
            this.logger.log(Level.WARNING, String.format("%d flood messages dropped in the last %ds", this.floodCount, (now - this.lastFloodReport) / 1000L));
        }
        this.floodCount = 0;
        this.lastFloodReport = now;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, String format, Object ... params) {
        if (this.isLoggable(level)) {
            if (level.intValue() >= FLOOD_LEVEL && !this.checkFlood()) {
                return;
            }
            this.logger.log(level, String.format(format, params));
        }
    }

    public void severe(String format, Object ... params) {
        this.log(Level.SEVERE, format, params);
    }

    public void error(String format, Object ... params) {
        this.log(ERROR, format, params);
    }

    public void warning(String format, Object ... params) {
        this.log(Level.WARNING, format, params);
    }

    public void info(String format, Object ... params) {
        this.log(Level.INFO, format, params);
    }

    public void config(String format, Object ... params) {
        this.log(Level.CONFIG, format, params);
    }

    public void fine(String format, Object ... params) {
        this.log(Level.FINE, format, params);
    }

    public void finer(String format, Object ... params) {
        this.log(Level.FINER, format, params);
    }

    public void finest(String format, Object ... params) {
        this.log(Level.FINEST, format, params);
    }

    public static enum Category {
        CUSTOM_COLORS("Custom Colors"),
        CUSTOM_ITEM_TEXTURES("Custom Item Textures"),
        CONNECTED_TEXTURES("Connected Textures"),
        EXTENDED_HD("Extended HD"),
        RANDOM_MOBS("Random Mobs"),
        BETTER_SKIES("Better Skies"),
        TEXTURE_PACK("Texture Pack"),
        TILESHEET("Tilesheet"),
        BETTER_GLASS("Better Glass");

        public final String name;

        private Category(String name) {
            this.name = name;
        }
    }

    private static class ErrorLevel
    extends Level {
        protected ErrorLevel() {
            super("ERROR", (Level.WARNING.intValue() + Level.SEVERE.intValue()) / 2);
        }
    }
}

