/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.biome.ColorMap;
import com.prupe.mcpatcher.mal.biome.ColorMapBase;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.biome.IColorMap;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mist475.mcpatcherforge.config.MCPatcherForgeConfig;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public class ColorizeWorld {
    private static final int fogBlendRadius = MCPatcherForgeConfig.instance().fogBlendRadius;
    private static final ResourceLocation UNDERWATERCOLOR = TexturePackAPI.newMCPatcherResourceLocation("colormap/underwater.png");
    private static final ResourceLocation UNDERLAVACOLOR = TexturePackAPI.newMCPatcherResourceLocation("colormap/underlava.png");
    private static final ResourceLocation FOGCOLOR0 = TexturePackAPI.newMCPatcherResourceLocation("colormap/fog0.png");
    private static final ResourceLocation SKYCOLOR0 = TexturePackAPI.newMCPatcherResourceLocation("colormap/sky0.png");
    private static final String TEXT_KEY = "text.";
    private static final String TEXT_CODE_KEY = "text.code.";
    private static final int CLOUDS_DEFAULT = -1;
    private static final int CLOUDS_NONE = 0;
    private static final int CLOUDS_FAST = 1;
    private static final int CLOUDS_FANCY = 2;
    private static int cloudType = -1;
    private static Entity fogCamera;
    private static final Map<Integer, Integer> textColorMap;
    private static final int[] textCodeColors;
    private static final boolean[] textCodeColorSet;
    private static int signTextColor;
    static IColorMap underwaterColor;
    private static IColorMap underlavaColor;
    private static IColorMap fogColorMap;
    private static IColorMap skyColorMap;
    public static float[] netherFogColor;
    public static float[] endFogColor;
    public static int endSkyColor;

    static void reset() {
        underwaterColor = null;
        underlavaColor = null;
        fogColorMap = null;
        skyColorMap = null;
        netherFogColor = new float[]{0.2f, 0.03f, 0.03f};
        endFogColor = new float[]{0.075f, 0.075f, 0.094f};
        endSkyColor = 0x181818;
        cloudType = -1;
        textColorMap.clear();
        Arrays.fill(textCodeColorSet, false);
        signTextColor = 0;
    }

    static void reloadFogColors(PropertiesFile properties) {
        underwaterColor = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, UNDERWATERCOLOR));
        underlavaColor = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, UNDERLAVACOLOR));
        fogColorMap = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, FOGCOLOR0));
        skyColorMap = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, SKYCOLOR0));
        Colorizer.loadFloatColor("fog.nether", netherFogColor);
        Colorizer.loadFloatColor("fog.end", endFogColor);
        endSkyColor = Colorizer.loadIntColor("sky.end", endSkyColor);
    }

    static IColorMap wrapFogMap(IColorMap map) {
        if (map == null) {
            return null;
        }
        if (fogBlendRadius > 0) {
            map = new ColorMapBase.Blended(map, fogBlendRadius);
        }
        map = new ColorMapBase.Cached(map);
        map = new ColorMapBase.Smoothed(map, 3000.0f);
        map = new ColorMapBase.Outer(map);
        return map;
    }

    static void reloadCloudType(PropertiesFile properties) {
        String value;
        switch (value = properties.getString("clouds", "").toLowerCase()) {
            case "fast": {
                cloudType = 1;
                break;
            }
            case "fancy": {
                cloudType = 2;
                break;
            }
            case "none": {
                cloudType = 0;
            }
        }
    }

    static void reloadTextColors(PropertiesFile properties) {
        for (int i = 0; i < textCodeColors.length; ++i) {
            ColorizeWorld.textCodeColorSet[i] = Colorizer.loadIntColor(TEXT_CODE_KEY + i, textCodeColors, i);
            if (!textCodeColorSet[i] || i + 16 >= textCodeColors.length) continue;
            ColorizeWorld.textCodeColors[i + 16] = (textCodeColors[i] & 0xFCFCFC) >> 2;
            ColorizeWorld.textCodeColorSet[i + 16] = true;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(TEXT_KEY) || key.startsWith(TEXT_CODE_KEY)) continue;
            key = key.substring(TEXT_KEY.length()).trim();
            try {
                int oldColor = key.equals("xpbar") ? 8453920 : (key.equals("boss") ? 0xFF00FF : Integer.parseInt(key, 16));
                int newColor = Integer.parseInt(value, 16);
                textColorMap.put(oldColor, newColor);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        signTextColor = Colorizer.loadIntColor("text.sign", 0);
    }

    public static void setupForFog(Entity entity) {
        fogCamera = entity;
    }

    private static boolean computeFogColor(IBlockAccess blockAccess, IColorMap colorMap) {
        if (colorMap == null || fogCamera == null) {
            return false;
        }
        int i = (int)ColorizeWorld.fogCamera.field_70165_t;
        int j = (int)ColorizeWorld.fogCamera.field_70163_u;
        int k = (int)ColorizeWorld.fogCamera.field_70161_v;
        Colorizer.setColorF(colorMap.getColorMultiplierF(blockAccess, i, j, k));
        return true;
    }

    public static boolean computeFogColor(WorldProvider worldProvider, float f) {
        return worldProvider.field_76574_g == 0 && ColorizeWorld.computeFogColor((IBlockAccess)worldProvider.field_76579_a, fogColorMap);
    }

    public static boolean computeSkyColor(World world, float f) {
        if (world.field_73011_w.field_76574_g == 0 && ColorizeWorld.computeFogColor((IBlockAccess)world, skyColorMap)) {
            ColorizeWorld.computeLightningFlash(world, f);
            return true;
        }
        return false;
    }

    public static boolean computeUnderwaterColor() {
        return ColorizeWorld.computeFogColor(BiomeAPI.getWorld(), underwaterColor);
    }

    public static boolean computeUnderlavaColor() {
        return ColorizeWorld.computeFogColor(BiomeAPI.getWorld(), underlavaColor);
    }

    private static void computeLightningFlash(World world, float f) {
        if (world.field_73016_r > 0) {
            f = 0.45f * ColorUtils.clamp((float)world.field_73016_r - f);
            Colorizer.setColor[0] = Colorizer.setColor[0] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[1] = Colorizer.setColor[1] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[2] = Colorizer.setColor[2] * (1.0f - f) + 0.8f * f;
        }
    }

    public static boolean drawFancyClouds(boolean fancyGraphics) {
        boolean bl;
        switch (cloudType) {
            case 0: 
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = fancyGraphics;
            }
        }
        return bl;
    }

    public static int colorizeText(int defaultColor) {
        int high = defaultColor & 0xFF000000;
        Integer newColor = textColorMap.get(defaultColor &= 0xFFFFFF);
        if (newColor == null) {
            return high | defaultColor;
        }
        return high | newColor;
    }

    public static int colorizeText(int defaultColor, int index) {
        if (index < 0 || index >= textCodeColors.length || !textCodeColorSet[index]) {
            return defaultColor;
        }
        return defaultColor & 0xFF000000 | textCodeColors[index];
    }

    public static int colorizeSignText() {
        return signTextColor;
    }

    static {
        textColorMap = new HashMap<Integer, Integer>();
        textCodeColors = new int[32];
        textCodeColorSet = new boolean[32];
        try {
            ColorizeWorld.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

