/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.nbt;

import com.gtnewhorizons.angelica.mixins.interfaces.NBTTagCompoundExpansion;
import com.gtnewhorizons.angelica.mixins.interfaces.NBTTagListExpansion;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public abstract class NBTRule {
    public static final String NBT_RULE_PREFIX = "nbt.";
    public static final String NBT_RULE_SEPARATOR = ".";
    public static final String NBT_RULE_WILDCARD = "*";
    public static final String NBT_REGEX_PREFIX = "regex:";
    public static final String NBT_IREGEX_PREFIX = "iregex:";
    public static final String NBT_GLOB_PREFIX = "pattern:";
    public static final String NBT_IGLOB_PREFIX = "ipattern:";
    private final String[] tagName;
    private final Integer[] tagIndex;

    public static NBTRule create(String tag, String value) {
        if (tag == null || value == null || !tag.startsWith(NBT_RULE_PREFIX)) {
            return null;
        }
        try {
            tag = tag.substring(NBT_RULE_PREFIX.length());
            if (value.startsWith(NBT_REGEX_PREFIX)) {
                return new Regex(tag, value.substring(NBT_REGEX_PREFIX.length()), true);
            }
            if (value.startsWith(NBT_IREGEX_PREFIX)) {
                return new Regex(tag, value.substring(NBT_IREGEX_PREFIX.length()), false);
            }
            if (value.startsWith(NBT_GLOB_PREFIX)) {
                return new Glob(tag, value.substring(NBT_GLOB_PREFIX.length()), true);
            }
            if (value.startsWith(NBT_IGLOB_PREFIX)) {
                return new Glob(tag, value.substring(NBT_IGLOB_PREFIX.length()), false);
            }
            return new Exact(tag, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    protected NBTRule(String tag, String value) {
        this.tagName = tag.split(Pattern.quote(NBT_RULE_SEPARATOR));
        this.tagIndex = new Integer[this.tagName.length];
        for (int i = 0; i < this.tagName.length; ++i) {
            if (NBT_RULE_WILDCARD.equals(this.tagName[i])) {
                this.tagName[i] = null;
                this.tagIndex[i] = null;
                continue;
            }
            try {
                this.tagIndex[i] = Integer.valueOf(this.tagName[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.tagIndex[i] = -1;
            }
        }
    }

    public final boolean match(NBTTagCompound nbt) {
        return nbt != null && this.match(nbt, 0);
    }

    private boolean match(NBTTagCompound nbt, int index) {
        if (index >= this.tagName.length) {
            return false;
        }
        if (this.tagName[index] == null) {
            for (NBTBase nbtBase : ((NBTTagCompoundExpansion)nbt).getTags()) {
                if (!this.match1(nbtBase, index + 1)) continue;
                return true;
            }
            return false;
        }
        NBTBase nbtBase = nbt.func_74781_a(this.tagName[index]);
        return this.match1(nbtBase, index + 1);
    }

    private boolean match(NBTTagList nbt, int index) {
        if (index >= this.tagIndex.length) {
            return false;
        }
        if (this.tagIndex[index] == null) {
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                if (!this.match1(((NBTTagListExpansion)nbt).tagAt(i), index + 1)) continue;
                return true;
            }
            return false;
        }
        int tagNum = this.tagIndex[index];
        return tagNum >= 0 && tagNum < nbt.func_74745_c() && this.match1(((NBTTagListExpansion)nbt).tagAt(tagNum), index + 1);
    }

    private boolean match1(NBTBase nbt, int index) {
        if (nbt == null) {
            return false;
        }
        if (nbt instanceof NBTTagCompound) {
            return this.match((NBTTagCompound)nbt, index);
        }
        if (nbt instanceof NBTTagList) {
            return this.match((NBTTagList)nbt, index);
        }
        if (index < this.tagName.length) {
            return false;
        }
        if (nbt instanceof NBTTagString) {
            return this.match((NBTTagString)nbt);
        }
        if (nbt instanceof NBTTagInt) {
            return this.match((NBTTagInt)nbt);
        }
        if (nbt instanceof NBTTagDouble) {
            return this.match((NBTTagDouble)nbt);
        }
        if (nbt instanceof NBTTagFloat) {
            return this.match((NBTTagFloat)nbt);
        }
        if (nbt instanceof NBTTagLong) {
            return this.match((NBTTagLong)nbt);
        }
        if (nbt instanceof NBTTagShort) {
            return this.match((NBTTagShort)nbt);
        }
        if (nbt instanceof NBTTagByte) {
            return this.match((NBTTagByte)nbt);
        }
        return false;
    }

    protected boolean match(NBTTagByte nbt) {
        return false;
    }

    protected boolean match(NBTTagDouble nbt) {
        return false;
    }

    protected boolean match(NBTTagFloat nbt) {
        return false;
    }

    protected boolean match(NBTTagInt nbt) {
        return false;
    }

    protected boolean match(NBTTagLong nbt) {
        return false;
    }

    protected boolean match(NBTTagShort nbt) {
        return false;
    }

    protected boolean match(NBTTagString nbt) {
        return false;
    }

    private static final class Regex
    extends NBTRule {
        private final Pattern pattern;

        Regex(String tag, String value, boolean caseSensitive) {
            super(tag, value);
            this.pattern = Pattern.compile(value, caseSensitive ? 0 : 2);
        }

        @Override
        protected boolean match(NBTTagString nbt) {
            return this.pattern.matcher(nbt.func_150285_a_()).matches();
        }
    }

    private static final class Glob
    extends NBTRule {
        private static final char STAR = '*';
        private static final char SINGLE = '?';
        private static final char ESCAPE = '\\';
        private final String glob;
        private final boolean caseSensitive;

        protected Glob(String tag, String value, boolean caseSensitive) {
            super(tag, value);
            this.caseSensitive = caseSensitive;
            if (!caseSensitive) {
                value = value.toLowerCase();
            }
            this.glob = value;
        }

        @Override
        protected boolean match(NBTTagString nbt) {
            String value = nbt.func_150285_a_();
            return this.matchPartial(value, 0, value.length(), 0, this.glob.length());
        }

        private boolean matchPartial(String value, int curV, int maxV, int curG, int maxG) {
            while (curG < maxG) {
                char g = this.glob.charAt(curG);
                if (g == '*') {
                    while (true) {
                        if (this.matchPartial(value, curV, maxV, curG + 1, maxG)) {
                            return true;
                        }
                        if (curV >= maxV) break;
                        ++curV;
                    }
                    return false;
                }
                if (curV >= maxV) break;
                if (g != '?') {
                    if (g == '\\' && curG + 1 < maxG) {
                        g = this.glob.charAt(++curG);
                    }
                    if (!this.matchChar(g, value.charAt(curV))) {
                        return false;
                    }
                }
                ++curG;
                ++curV;
            }
            return curG == maxG && curV == maxV;
        }

        private boolean matchChar(char a, char b) {
            return a == (this.caseSensitive ? b : Character.toLowerCase(b));
        }
    }

    private static final class Exact
    extends NBTRule {
        private final Byte byteValue;
        private final Double doubleValue;
        private final Float floatValue;
        private final Integer integerValue;
        private final Long longValue;
        private final Short shortValue;
        private final String stringValue;

        Exact(String tag, String value) {
            super(tag, value);
            this.stringValue = value;
            this.doubleValue = Exact.parse(Double.class, value);
            this.floatValue = this.doubleValue == null ? null : Float.valueOf(this.doubleValue.floatValue());
            this.longValue = Exact.parse(Long.class, value);
            if (this.longValue == null) {
                this.byteValue = null;
                this.integerValue = null;
                this.shortValue = null;
            } else {
                this.byteValue = this.longValue.byteValue();
                this.integerValue = this.longValue.intValue();
                this.shortValue = this.longValue.shortValue();
            }
        }

        private static <T extends Number> T parse(Class<T> cl, String value) {
            try {
                Method valueOf = cl.getDeclaredMethod("valueOf", String.class);
                Object result = valueOf.invoke(null, value);
                if (result != null && cl.isAssignableFrom(result.getClass())) {
                    return (T)((Number)cl.cast(result));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected boolean match(NBTTagByte nbt) {
            return this.byteValue != null && this.byteValue.byteValue() == nbt.func_150290_f();
        }

        @Override
        protected boolean match(NBTTagDouble nbt) {
            return this.doubleValue != null && this.doubleValue.doubleValue() == nbt.func_150286_g();
        }

        @Override
        protected boolean match(NBTTagFloat nbt) {
            return this.floatValue != null && this.floatValue.floatValue() == nbt.func_150288_h();
        }

        @Override
        protected boolean match(NBTTagInt nbt) {
            return this.integerValue != null && this.integerValue.intValue() == nbt.func_150287_d();
        }

        @Override
        protected boolean match(NBTTagLong nbt) {
            return this.longValue != null && this.longValue.longValue() == nbt.func_150291_c();
        }

        @Override
        protected boolean match(NBTTagShort nbt) {
            return this.shortValue != null && this.shortValue.shortValue() == nbt.func_150289_e();
        }

        @Override
        protected boolean match(NBTTagString nbt) {
            return nbt.func_150285_a_().equals(this.stringValue);
        }
    }
}

