/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import jss.notfine.config.NotFineConfig;
import jss.notfine.core.Settings;
import jss.notfine.core.SettingsManager;
import jss.notfine.gui.options.control.NotFineControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsMode;
import me.jellysquid.mods.sodium.client.gui.options.named.LightingQuality;
import me.jellysquid.mods.sodium.client.gui.options.named.ParticleMode;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.opengl.Display;

public class NotFineGameOptionPages {
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsMode.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.graphics", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.graphics_quality.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<GraphicsMode>((Option<GraphicsMode>)option, GraphicsMode.class)).setBinding((opts, value) -> {
            opts.field_74347_j = value.isFancy();
            SettingsManager.graphicsUpdated();
        }, opts -> GraphicsMode.fromBoolean(opts.field_74347_j)).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.renderDistance", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_distance.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 2, (int)GameSettings.Options.RENDER_DISTANCE.func_148267_f(), 1, ControlValueFormatter.quantity("options.chunks"))).setBinding((options, value) -> {
            options.field_151451_c = value;
        }, options -> options.field_151451_c).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.vsync", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.v_sync.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74352_v = value;
            Display.setVSyncEnabled((boolean)opts.field_74352_v);
        }, opts -> opts.field_74352_v).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.fullscreen", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fullscreen.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74353_u = value;
            Minecraft client = Minecraft.func_71410_x();
            if (client.func_71372_G() != opts.field_74353_u) {
                client.func_71352_k();
                opts.field_74353_u = client.func_71372_G();
            }
        }, opts -> opts.field_74353_u).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.framerateLimit", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fps_limit.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 1, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_74350_i = value;
        }, opts -> opts.field_74350_i).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.guiScale", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.gui_scale.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_74335_Z = value;
        }, opts -> opts.field_74335_Z).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.viewBobbing", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.view_bobbing.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74336_f = value;
        }, opts -> opts.field_74336_f).build()).add(Settings.DYNAMIC_FOV.option).add(OptionImpl.createBuilder(LightingQuality.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.ao", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.smooth_lighting.tooltip", (Object[])new Object[0])).setControl(option -> new CyclingControl<LightingQuality>((Option<LightingQuality>)option, LightingQuality.class)).setBinding((opts, value) -> {
            opts.field_74348_k = value.getVanilla();
        }, opts -> LightingQuality.fromOrdinal(opts.field_74348_k)).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.gamma", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.brightness.tooltip", (Object[])new Object[0])).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_74333_Y = (float)value.intValue() * 0.01f;
        }, opts -> (int)(opts.field_74333_Y / 0.01f)).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.mipmapLevels", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.mipmap_levels.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_151442_I = value;
        }, opts -> opts.field_151442_I).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.anisotropicFiltering", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.anisotropic_filtering.tooltip", (Object[])new Object[0])).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, NotFineControlValueFormatter.powerOfTwo())).setBinding((opts, value) -> {
            opts.field_151443_J = value == 0 ? 1 : (int)Math.pow(2.0, value.intValue());
        }, opts -> opts.field_151443_J == 1 ? 0 : (int)(Math.log(opts.field_151443_J) / Math.log(2.0))).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage(I18n.func_135052_a((String)"options.video", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage detail() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(Settings.MODE_LEAVES.option).add(Settings.MODE_WATER.option).add(Settings.DOWNFALL_DISTANCE.option).add(Settings.MODE_VIGNETTE.option).add(Settings.MODE_SHADOWS.option).add(Settings.MODE_DROPPED_ITEMS.option).add(Settings.MODE_GLINT_WORLD.option).add(Settings.MODE_GLINT_INV.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.detail", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage atmosphere() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(Settings.MODE_SKY.option).add(Settings.MODE_SUN_MOON.option).add(Settings.MODE_CLOUDS.option).add(Settings.RENDER_DISTANCE_CLOUDS.option).add(Settings.CLOUD_HEIGHT.option).add(Settings.CLOUD_SCALE.option).add(Settings.MODE_CLOUD_TRANSLUCENCY.option).add(Settings.TOTAL_STARS.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.sky", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage particles() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(ParticleMode.class, vanillaOpts).setName(I18n.func_135052_a((String)"options.particles", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.particle_quality.tooltip", (Object[])new Object[0])).setControl(opt -> new CyclingControl<ParticleMode>((Option<ParticleMode>)opt, ParticleMode.class)).setBinding((opts, value) -> {
            opts.field_74362_aa = value.ordinal();
        }, opts -> ParticleMode.fromOrdinal(opts.field_74362_aa)).setImpact(OptionImpact.LOW).build()).add(Settings.PARTICLES_VOID.option).add(Settings.PARTICLES_ENC_TABLE.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.particle", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage other() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.advancedOpengl", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.advanced_opengl.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74349_h = value;
        }, opts -> opts.field_74349_h).setImpact(OptionImpact.VARIES).setEnabled(NotFineConfig.allowAdvancedOpenGL).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.fboEnable", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.fbo.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_151448_g = value;
        }, opts -> opts.field_151448_g).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.anaglyph", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.anaglyph.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_74337_g = value;
        }, opts -> opts.field_74337_g).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName(I18n.func_135052_a((String)"options.showCape", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"sodium.options.show_cape.tooltip", (Object[])new Object[0])).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_82880_z = value;
        }, opts -> opts.field_82880_z).build()).add(Settings.MODE_GUI_BACKGROUND.option).build());
        groups.add(OptionGroup.createBuilder().add(Settings.GUI_BACKGROUND.option).build());
        return new OptionPage(I18n.func_135052_a((String)"options.button.other", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

