/*
 * Decompiled with CFR 0.152.
 */
package com.elisis.gtnhlanth.common.tileentity;

import com.elisis.gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import com.elisis.gtnhlanth.util.DescTextLocalization;
import com.github.bartimaeusnek.bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class DissolutionTank
extends GT_MetaTileEntity_EnhancedMultiBlockBase<DissolutionTank>
implements ISurvivalConstructable,
ISecondaryDescribable {
    private final IStructureDefinition<DissolutionTank> multiDefinition;

    public DissolutionTank(String name) {
        super(name);
        this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" sss ", "sssss", "sssss", "sssss", " sss "}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"ss~ss", "shhhs", "shhhs", "shhhs", "sssss"}, {"s   s", "     ", "     ", "     ", "s   s"}})).addElement('s', (IStructureElement)GT_StructureUtility.buildHatchAdder(DissolutionTank.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy}).casingIndex(49).dot(1).buildAndChain(GregTech_API.sBlockCasings4, 1)).addElement('h', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)).addElement('g', StructureUtility.ofBlockAdder(DissolutionTank::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).build();
    }

    public DissolutionTank(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" sss ", "sssss", "sssss", "sssss", " sss "}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"sgggs", "g---g", "g---g", "g---g", "sgggs"}, {"ss~ss", "shhhs", "shhhs", "shhhs", "sssss"}, {"s   s", "     ", "     ", "     ", "s   s"}})).addElement('s', (IStructureElement)GT_StructureUtility.buildHatchAdder(DissolutionTank.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy}).casingIndex(49).dot(1).buildAndChain(GregTech_API.sBlockCasings4, 1)).addElement('h', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)).addElement('g', StructureUtility.ofBlockAdder(DissolutionTank::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).build();
    }

    public IStructureDefinition<DissolutionTank> getStructureDefinition() {
        return this.multiDefinition;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(this.mName, 2, 3, 0);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private boolean addGlass(Block block, int meta) {
        return block == ItemRegistry.bw_glasses[0];
    }

    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.dissolutionTankRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GT_Recipe recipe) {
                if (!DissolutionTank.this.checkRatio(recipe, Arrays.asList(this.inputFluids))) {
                    DissolutionTank.this.criticalStopMachine();
                    return SimpleCheckRecipeResult.ofFailurePersistOnShutdown((String)"dissolution_ratio");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkRatio(GT_Recipe tRecipe, List<FluidStack> tFluidInputs) {
        int minorAmount;
        int majorAmount;
        FluidStack majorGenericFluid = tRecipe.mFluidInputs[0];
        FluidStack minorGenericFluid = tRecipe.mFluidInputs[1];
        FluidStack fluidInputOne = tFluidInputs.get(0);
        FluidStack fluidInputTwo = tFluidInputs.get(1);
        if (fluidInputOne.getUnlocalizedName().equals(majorGenericFluid.getUnlocalizedName())) {
            if (!fluidInputTwo.getUnlocalizedName().equals(minorGenericFluid.getUnlocalizedName())) return false;
            majorAmount = fluidInputOne.amount;
            minorAmount = fluidInputTwo.amount;
        } else {
            if (!fluidInputTwo.getUnlocalizedName().equals(majorGenericFluid.getUnlocalizedName())) return false;
            if (!fluidInputOne.getUnlocalizedName().equals(minorGenericFluid.getUnlocalizedName())) return false;
            majorAmount = fluidInputTwo.amount;
            minorAmount = fluidInputOne.amount;
        }
        if (majorAmount / tRecipe.mSpecialValue != minorAmount) return false;
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new DissolutionTank(this.mName);
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(this.mName, itemStack, b, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("DissolutionTank.hint", 4);
    }

    public ITexture[] getTexture(IGregTechTileEntity te, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Dissolution Tank").addInfo("Controller block for the Dissolution Tank").addInfo("Input Water and Fluid, output Fluid").addInfo("You must input the Fluids at the correct Ratio").addInfo(DescTextLocalization.BLUEPRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 1").addOutputBus("Hint block with dot 1").addMaintenanceHatch("Hint block with dot 1").toolTipFinisher("GTNH: Lanthanides");
        return tt;
    }

    public boolean explodesOnComponentBreak(ItemStack arg0) {
        return false;
    }

    public int getDamageToComponent(ItemStack arg0) {
        return 0;
    }
}

