/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PatternMultiplierHelper {
    private static final int FINAL_BIT = 0x40000000;

    public static int getMaxBitMultiplier(ICraftingPatternDetails details) {
        int max;
        long size;
        int maxMulti = 30;
        for (IAEItemStack input : details.getInputs()) {
            if (input == null) continue;
            size = input.getStackSize();
            max = 0;
            while ((size & 0x40000000L) == 0L) {
                size <<= 1;
                ++max;
            }
            if (max >= maxMulti) continue;
            maxMulti = max;
        }
        for (IAEItemStack out : details.getOutputs()) {
            if (out == null) continue;
            size = out.getStackSize();
            max = 0;
            while ((size & 0x40000000L) == 0L) {
                size <<= 1;
                ++max;
            }
            if (max >= maxMulti) continue;
            maxMulti = max;
        }
        return maxMulti;
    }

    public static int getMaxBitDivider(ICraftingPatternDetails details) {
        int max;
        long size;
        int maxDiv = 30;
        for (IAEItemStack input : details.getInputs()) {
            if (input == null) continue;
            size = input.getStackSize();
            max = 0;
            while ((size & 1L) == 0L) {
                size >>= 1;
                ++max;
            }
            if (max >= maxDiv) continue;
            maxDiv = max;
        }
        for (IAEItemStack out : details.getOutputs()) {
            if (out == null) continue;
            size = out.getStackSize();
            max = 0;
            while ((size & 1L) == 0L) {
                size >>= 1;
                ++max;
            }
            if (max >= maxDiv) continue;
            maxDiv = max;
        }
        return maxDiv;
    }

    public static void applyModification(ItemStack stack, int bitMultiplier) {
        NBTTagCompound tag;
        int x;
        if (bitMultiplier == 0) {
            return;
        }
        boolean isDividing = false;
        if (bitMultiplier < 0) {
            isDividing = true;
            bitMultiplier = -bitMultiplier;
        }
        NBTTagCompound encodedValue = stack.field_77990_d;
        NBTTagList inTag = encodedValue.func_150295_c("in", 10);
        NBTTagList outTag = encodedValue.func_150295_c("out", 10);
        for (x = 0; x < inTag.func_74745_c(); ++x) {
            tag = inTag.func_150305_b(x);
            if (tag.func_82582_d()) continue;
            if (tag.func_150297_b("Count", 3)) {
                tag.func_74768_a("Count", isDividing ? tag.func_74762_e("Count") >> bitMultiplier : tag.func_74762_e("Count") << bitMultiplier);
            }
            if (!tag.func_150297_b("Cnt", 4)) continue;
            tag.func_74772_a("Cnt", isDividing ? tag.func_74763_f("Cnt") >> bitMultiplier : tag.func_74763_f("Cnt") << bitMultiplier);
        }
        for (x = 0; x < outTag.func_74745_c(); ++x) {
            tag = outTag.func_150305_b(x);
            if (tag.func_82582_d()) continue;
            if (tag.func_150297_b("Count", 3)) {
                tag.func_74768_a("Count", isDividing ? tag.func_74762_e("Count") >> bitMultiplier : tag.func_74762_e("Count") << bitMultiplier);
            }
            if (!tag.func_150297_b("Cnt", 4)) continue;
            tag.func_74772_a("Cnt", isDividing ? tag.func_74763_f("Cnt") >> bitMultiplier : tag.func_74763_f("Cnt") << bitMultiplier);
        }
    }
}

