/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemShuttle
extends Item
implements IHoldableItem {
    public ItemShuttle(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_111206_d("arrow");
        this.func_77655_b(assetName);
    }

    public CreativeTabs func_77640_w() {
        return AmunRa.arTab;
    }

    public EntityShuttle spawnRocketEntity(ItemStack stack, World world, double centerX, double centerY, double centerZ) {
        EntityShuttle spaceship = new EntityShuttle(world, centerX, centerY, centerZ, stack.func_77960_j());
        spaceship.func_70107_b(spaceship.field_70165_t, spaceship.field_70163_u + spaceship.getOnPadYOffset(), spaceship.field_70161_v);
        world.func_72838_d((Entity)spaceship);
        if (EntityShuttle.isPreFueled(stack.func_77960_j())) {
            spaceship.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, spaceship.fuelTank.getCapacity()), true);
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
            spaceship.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
        }
        return spaceship;
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        boolean padFound = false;
        TileEntity tile = null;
        if (p_77648_3_.field_72995_K && p_77648_2_ instanceof EntityPlayerSP) {
            EntityPlayerSP playerSP = (EntityPlayerSP)p_77648_2_;
            ClientProxyCore.playerClientHandler.onBuild(8, playerSP);
            return false;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Block id = p_77648_3_.func_147439_a(p_77648_4_ + i, p_77648_5_, p_77648_6_ + j);
                int meta = p_77648_3_.func_72805_g(p_77648_4_ + i, p_77648_5_, p_77648_6_ + j);
                if (id != GCBlocks.landingPadFull || meta != 0) continue;
                padFound = true;
                tile = p_77648_3_.func_147438_o(p_77648_4_ + i, p_77648_5_, p_77648_6_ + j);
                centerX = (float)(p_77648_4_ + i) + 0.5f;
                centerY = (float)p_77648_5_ + 0.4f;
                centerZ = (float)(p_77648_6_ + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (!(tile instanceof TileEntityLandingPad)) {
                return false;
            }
            TileEntityLandingPad tilePad = (TileEntityLandingPad)tile;
            if (tilePad.getDockedEntity() != null) {
                return false;
            }
        } else {
            centerX = (float)p_77648_4_ + 0.5f;
            centerY = (float)p_77648_5_ + 0.4f;
            centerZ = (float)p_77648_6_ + 0.5f;
        }
        this.spawnRocketEntity(p_77648_1_, p_77648_3_, centerX, centerY, centerZ);
        if (!p_77648_2_.field_71075_bZ.field_75098_d) {
            --p_77648_1_.field_77994_a;
            if (p_77648_1_.field_77994_a <= 0) {
                p_77648_1_ = null;
            }
        }
        return true;
    }

    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List<ItemStack> p_150895_3_) {
        for (int numTanks = 0; numTanks <= 3; ++numTanks) {
            for (int numChests = 0; numChests <= 3; ++numChests) {
                if (numChests + numTanks > 3) continue;
                int dmg = numChests | numTanks << 2;
                p_150895_3_.add(new ItemStack(p_150895_1_, 1, dmg));
            }
        }
        p_150895_3_.add(new ItemStack(p_150895_1_, 1, 15));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List<String> p_77624_3_, boolean p_77624_4_) {
        int dmg = p_77624_1_.func_77960_j();
        IRocketType.EnumRocketType type = EntityShuttle.getRocketTypeFromDamage(dmg);
        if (!type.getTooltip().isEmpty()) {
            p_77624_3_.add(type.getTooltip());
        }
        int fuelTotal = EntityShuttle.getFuelCapacityFromDamage(dmg);
        if (EntityShuttle.isPreFueled(dmg)) {
            p_77624_3_.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelTotal + " / " + fuelTotal);
            p_77624_3_.add(EnumColor.RED + "\u00a7o" + GCCoreUtil.translate((String)"gui.creativeOnly.desc"));
        } else {
            int fuelContained = 0;
            if (p_77624_1_.func_77942_o() && p_77624_1_.func_77978_p().func_74764_b("RocketFuel")) {
                fuelContained = p_77624_1_.func_77978_p().func_74762_e("RocketFuel");
            }
            p_77624_3_.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + fuelContained + " / " + fuelTotal);
        }
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }
}

